/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelTimeInterface;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.converter.LocalTimeStringConverter;

public class GlenixLabelTime
extends GlenixLabelText
implements GlenixLabelTimeInterface {
    private ChangeListener<String> changeListener = null;
    private String lastValidatedValue = null;
    private LocalTimeStringConverter localTimeStringConverter = new LocalTimeStringConverter();
    private DateTimeFormatter inputTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;

    public GlenixLabelTime() throws Exception {
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.matches("^[0-9]{0,2}(:[0-9]{0,2}(:[0-9]{0,2})?)?$")) {
                    GlenixLabelTime.this.setText(oldValue);
                } else if (GlenixLabelTime.this.lastValidatedValue == null && newValue != null || GlenixLabelTime.this.lastValidatedValue != null && !GlenixLabelTime.this.lastValidatedValue.equals(newValue)) {
                    GlenixLabelTime.this.lastValidatedValue = newValue;
                    if (GlenixLabelTime.this.changeListener != null) {
                        GlenixLabelTime.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    String textValue = GlenixLabelTime.this.getText();
                    if (textValue != null && textValue.matches("^[0-9]{1}:[0-9]{2}(:[0-9]{2})?$")) {
                        textValue = "0" + textValue;
                        GlenixLabelTime.this.setText(textValue);
                        return;
                    }
                    if (textValue != null && !textValue.matches("^[0-9]{1,2}(:[0-9]{1,2}(:[0-9]{1,2})?)?$")) {
                        GlenixLabelTime.this.getStyleClass().add((Object)"textFieldError");
                    } else {
                        try {
                            LocalTime lt = LocalTime.parse(textValue, GlenixLabelTime.this.inputTimeFormatter);
                            if (lt != null) {
                                GlenixLabelTime.this.setText(lt.format(GlenixLabelTime.this.inputTimeFormatter));
                                GlenixLabelTime.this.getStyleClass().removeAll((Object[])new String[]{"textFieldError"});
                            } else {
                                GlenixLabelTime.this.getStyleClass().add((Object)"textFieldError");
                            }
                        }
                        catch (Exception e) {
                            GlenixLabelTime.this.getStyleClass().add((Object)"textFieldError");
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean glenixTextIsEmpty() {
        String textValue = this.getText();
        return textValue == null || textValue.equals("");
    }

    @Override
    public LocalTime getLocalTime() {
        String textValue = this.getText();
        if (textValue == null || textValue.equals("")) {
            return null;
        }
        LocalTime lt = null;
        try {
            lt = LocalTime.parse(textValue, this.inputTimeFormatter);
        }
        catch (Exception e) {
            lt = null;
        }
        return lt;
    }

    @Override
    public String getGlenixElementValue() {
        LocalTime lt = this.getLocalTime();
        if (lt == null) {
            return null;
        }
        return lt.format(this.inputTimeFormatter);
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.setText(null);
            return;
        }
        LocalTime lt = null;
        try {
            lt = LocalTime.parse(glenixElementValue, this.inputTimeFormatter);
        }
        catch (Exception e) {
            lt = null;
        }
        if (lt == null) {
            this.setText(null);
        }
        this.setText(lt.format(this.inputTimeFormatter));
    }

    @Override
    public void setLocalTime(LocalTime lt) {
        this.setText(lt.format(this.inputTimeFormatter));
    }

    @Override
    public void setTimeBySeconds(Integer seconds) {
        LocalTime lt = null;
        try {
            lt = LocalTime.parse("00:00:00", this.inputTimeFormatter);
        }
        catch (Exception e) {
            lt = null;
        }
        if (lt == null) {
            this.setText(null);
        }
        lt = lt.plusSeconds(seconds.intValue());
        this.setText(lt.format(this.inputTimeFormatter));
    }

    @Override
    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }
}

