/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelTextController
extends GlenixLabelAbstractController {
    @FXML
    protected TextField glenixText;
    protected ChangeListener<String> changeListener = null;
    private String lastValidatedValue = null;
    private String editRegexPattern = null;
    private String finalRegexPattern = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.glenixText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GlenixLabelTextController.this.validateEdit(observable, oldValue, newValue);
                if (GlenixLabelTextController.this.changeListener != null) {
                    GlenixLabelTextController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
        this.glenixText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                GlenixLabelTextController.this.validateFinal(observable, oldValue, newValue);
            }
        });
    }

    public String getText() {
        return this.glenixText.getText();
    }

    public void setText(String value) {
        this.glenixText.setText(value);
    }

    public StringProperty textProperty() {
        return this.glenixText.textProperty();
    }

    @Override
    public String getGlenixElementValue() {
        return this.getText();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        this.setText(glenixElementValue);
    }

    public void addTextChangeListener(ChangeListener changeListener) {
        this.glenixText.textProperty().addListener(changeListener);
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public boolean glenixTextIsFocused() {
        return this.glenixText.isFocused();
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && isVisible.equals("false")) {
                this.pane.setManaged(false);
                this.pane.setVisible(false);
            } else if (isVisible != null && isVisible.equals("true")) {
                this.pane.setManaged(true);
                this.pane.setVisible(true);
            }
            String isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable");
            if (isEditable != null && isEditable.equals("false")) {
                this.glenixText.setEditable(false);
                this.glenixText.setDisable(true);
            } else if (isEditable != null && isEditable.equals("true")) {
                this.glenixText.setEditable(true);
                this.glenixText.setDisable(false);
            }
        }
    }

    @Override
    public void disableGlenixXBRL() {
        this.glenixText.disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.glenixText.disableProperty().set(false);
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.glenixText.getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.glenixText.getStyleClass().add((Object)"error_background");
        }
    }

    @FXML
    public String getEditRegexPattern() {
        return this.editRegexPattern;
    }

    @FXML
    public void setEditRegexPattern(String value) {
        this.editRegexPattern = value;
    }

    @FXML
    public String getFinalRegexPattern() {
        return this.finalRegexPattern;
    }

    @FXML
    public void setFinalRegexPattern(String value) {
        this.finalRegexPattern = value;
    }

    protected void validateEdit(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        String pattern = this.getEditRegexPattern();
        if (pattern == null || pattern.isEmpty()) {
            return;
        }
        if (newValue != null && !newValue.matches(pattern)) {
            this.glenixText.setText(oldValue);
        } else if (this.lastValidatedValue == null && newValue != null || this.lastValidatedValue != null && !this.lastValidatedValue.equals(newValue)) {
            this.lastValidatedValue = newValue;
            if (this.changeListener != null) {
                this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
            }
        }
    }

    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            String pattern = this.getFinalRegexPattern();
            if (pattern == null || pattern.isEmpty()) {
                return;
            }
            String textValue = this.glenixText.getText();
            if (textValue == null || textValue.isEmpty()) {
                this.setErrorDisplay(null);
            } else if (!textValue.matches(pattern)) {
                this.setErrorDisplay("error");
            }
        }
    }

    public Double getDouble() {
        try {
            String str = this.getGlenixElementValue();
            if (str == null || str.isEmpty()) {
                return null;
            }
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

