/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.text.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelTextAreaController
extends GlenixLabelAbstractController {
    @FXML
    protected TextArea glenixTextArea;
    @FXML
    private Text textForHeight;
    Double oldHeight = 0.0;
    Double oldWidth = 0.0;
    protected ChangeListener<String> changeListener = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.glenixTextArea.setWrapText(true);
        Node node = this.glenixTextArea.lookup(".scroll-bar");
        if (node != null) {
            node.setManaged(false);
            node.setVisible(false);
        }
        this.textForHeight.setWrappingWidth(300.0);
        this.textForHeight.textProperty().bind((ObservableValue)this.glenixTextArea.textProperty());
        this.textForHeight.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                GlenixLabelTextAreaController.this.setTextAreaHeight(newValue);
            }
        });
        this.glenixTextArea.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                GlenixLabelTextAreaController.this.textForHeight.setWrappingWidth(newValue.getWidth() - 40.0);
            }
        });
    }

    private void setTextAreaHeight(Bounds newValue) {
        Double useWidth = this.glenixTextArea.getWidth();
        if (useWidth <= 0.0) {
            useWidth = 300.0;
        }
        if (useWidth != this.oldWidth) {
            this.oldWidth = useWidth;
            this.textForHeight.setWrappingWidth(this.oldWidth - 16.0);
        }
        Double setHeight = this.textForHeight.getLayoutBounds().getHeight();
        if (this.oldHeight.doubleValue() != newValue.getHeight()) {
            this.oldHeight = newValue.getHeight();
            this.glenixTextArea.setPrefHeight(setHeight * 1.1 + 20.0);
        }
    }

    public String getText() {
        return this.glenixTextArea.getText();
    }

    public void setText(String value) {
        this.glenixTextArea.setText(value);
        Bounds b = this.glenixTextArea.getLayoutBounds();
        this.setTextAreaHeight(b);
    }

    public StringProperty textProperty() {
        return this.glenixTextArea.textProperty();
    }

    @Override
    public String getGlenixElementValue() {
        return this.getText();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        this.setText(glenixElementValue);
    }

    public void addTextChangeListener(ChangeListener changeListener) {
        this.glenixTextArea.textProperty().addListener(changeListener);
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public boolean glenixTextIsFocused() {
        return this.glenixTextArea.isFocused();
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && isVisible.equals("false")) {
                this.pane.setManaged(false);
                this.pane.setVisible(false);
            } else if (isVisible != null && isVisible.equals("true")) {
                this.pane.setManaged(true);
                this.pane.setVisible(true);
            }
            String isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable");
            if (isEditable != null && isEditable.equals("false")) {
                this.glenixTextArea.setEditable(false);
                this.glenixTextArea.setDisable(true);
            } else if (isEditable != null && isEditable.equals("true")) {
                this.glenixTextArea.setEditable(true);
                this.glenixTextArea.setDisable(false);
            }
        }
    }

    @Override
    public void disableGlenixXBRL() {
        this.glenixTextArea.disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.glenixTextArea.disableProperty().set(false);
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.glenixTextArea.getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.glenixTextArea.getStyleClass().add((Object)"error_background");
        }
    }
}

