/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelAbstractPane;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelText
extends GlenixLabelAbstractPane {
    protected TextField glenixText = new TextField();
    protected Region indicatorSymbol;

    public GlenixLabelText() {
        this.glenixText.getStyleClass().add((Object)"glenixPaneText");
        this.getChildren().add((Object)this.glenixText);
        this.glenixText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GlenixLabelText.this.validateEdit(observable, oldValue, newValue);
                if (GlenixLabelText.this.changeListener != null) {
                    GlenixLabelText.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
        this.glenixText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                GlenixLabelText.this.validateFinal(observable, oldValue, newValue);
            }
        });
        this.indicatorSymbol = new Region();
        this.indicatorSymbol.getStyleClass().add((Object)"indicatorSymbol");
        this.getChildren().add((Object)this.indicatorSymbol);
    }

    @Override
    public Control getControl() {
        return this.glenixText;
    }

    @Override
    protected Region getIndicatorSymbol() {
        return this.indicatorSymbol;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public void setTextWidth(int textWidth) {
        super.setTextWidth(textWidth);
        String name = this.getGlenixElementDescription();
        if (textWidth == 100 && name != null && !name.isEmpty()) {
            this.glenixText.setPromptText(name);
        }
    }

    @Override
    public int getTextWidth() {
        return super.getTextWidth();
    }

    @Override
    public GlenixController getGlenixController() {
        return this;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        super.setGlenixElementDescription(glenixElementDescription);
        if (this.getTextWidth() == 100 && glenixElementDescription != null && !glenixElementDescription.isEmpty()) {
            this.glenixText.setPromptText(glenixElementDescription);
        }
    }

    public String getText() {
        return this.glenixText.getText();
    }

    public void setText(String value) {
        this.glenixText.setText(value);
    }

    public StringProperty textProperty() {
        return this.glenixText.textProperty();
    }

    @Override
    public String getGlenixElementValue() {
        return this.getText();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        this.setText(glenixElementValue);
    }

    public void addTextChangeListener(ChangeListener<String> changeListener) {
        this.glenixText.textProperty().addListener(changeListener);
    }

    public boolean glenixTextIsFocused() {
        return this.glenixText.isFocused();
    }

    protected void validateEdit(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        String pattern = this.getEditRegexPattern();
        if (pattern == null || pattern.isEmpty()) {
            return;
        }
        if (newValue != null && !newValue.matches(pattern)) {
            this.glenixText.setText(oldValue);
        } else if (this.lastValidatedValue == null && newValue != null || this.lastValidatedValue != null && !this.lastValidatedValue.equals(newValue)) {
            this.lastValidatedValue = newValue;
            if (this.changeListener != null) {
                this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
            }
        }
    }

    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            String pattern = this.getFinalRegexPattern();
            if (pattern == null || pattern.isEmpty()) {
                return;
            }
            String textValue = this.glenixText.getText();
            if (textValue == null || textValue.isEmpty()) {
                this.setErrorDisplay(null);
            } else if (!textValue.matches(pattern)) {
                this.setErrorDisplay("error");
            }
        }
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            String isEditable;
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && !isVisible.isEmpty()) {
                if (isVisible.equals("false")) {
                    this.setManaged(false);
                    this.setVisible(false);
                } else {
                    this.setManaged(true);
                    this.setVisible(true);
                }
            }
            if ((isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable")) != null && !isEditable.isEmpty()) {
                if (isEditable != null && isEditable.equals("false")) {
                    this.glenixText.setEditable(false);
                } else {
                    this.glenixText.setEditable(true);
                }
            }
        }
    }
}

