/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTextController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class GlenixLabelTFNController
extends GlenixLabelTextController {
    private String lastValidatedValue = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.glenixText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.matches("^[0-9]{0,9}$")) {
                    GlenixLabelTFNController.this.setText(oldValue);
                } else if (GlenixLabelTFNController.this.lastValidatedValue == null && newValue != null || GlenixLabelTFNController.this.lastValidatedValue != null && !GlenixLabelTFNController.this.lastValidatedValue.equals(newValue)) {
                    GlenixLabelTFNController.this.lastValidatedValue = newValue;
                    if (GlenixLabelTFNController.this.changeListener != null) {
                        GlenixLabelTFNController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                    }
                }
            }
        });
        this.glenixText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    String textValue = GlenixLabelTFNController.this.getText();
                    if (textValue != null && !textValue.isEmpty()) {
                        if (!textValue.matches("^[0-9]{8,9}$")) {
                            GlenixLabelTFNController.this.setText("");
                            GlenixLabelTFNController.this.setErrorDisplay(null);
                        } else if (!GlenixLabelTFNController.this.checkTFN(textValue)) {
                            GlenixLabelTFNController.this.setErrorDisplay("error");
                        } else {
                            GlenixLabelTFNController.this.setErrorDisplay(null);
                        }
                    } else {
                        GlenixLabelTFNController.this.setErrorDisplay(null);
                    }
                }
            }
        });
    }

    private boolean checkTFN(String value) {
        if (value.length() == 9) {
            int[] weights = new int[]{10, 7, 8, 4, 6, 3, 5, 2, 1};
            int total = 0;
            for (int i = 0; i < 9; ++i) {
                char c = value.charAt(i);
                int ci = Character.getNumericValue(c);
                if (ci < 0) {
                    return false;
                }
                total += weights[i] * ci;
            }
            if (total % 11 == 0) {
                return true;
            }
        } else if (value.length() == 8) {
            int[] weights = new int[]{10, 7, 8, 4, 6, 3, 5, 1};
            int total = 0;
            for (int i = 0; i < 8; ++i) {
                char c = value.charAt(i);
                int ci = Character.getNumericValue(c);
                if (ci < 0) {
                    return false;
                }
                total += weights[i] * ci;
            }
            if (total % 11 == 0) {
                return true;
            }
        }
        return false;
    }
}

