/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTwoDecimalNumber;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javafx.beans.value.ObservableValue;

public class GlenixLabelSixDecimalNumber
extends GlenixLabelTwoDecimalNumber {
    protected NumberFormat format6dp = new DecimalFormat("#0.000000");

    public GlenixLabelSixDecimalNumber() throws Exception {
        super("#0.000000");
    }

    @Override
    public String getEditRegexPattern() {
        return "^-?[0-9]*(\\.[0-9]{0,6})?$";
    }

    @Override
    public String getFinalRegexPattern() {
        return "^-?[0-9]*(\\.[0-9]{1,6})?$";
    }

    @Override
    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            String pattern = this.getFinalRegexPattern();
            if (pattern == null || pattern.isEmpty()) {
                return;
            }
            String textValue = this.glenixText.getText();
            if (textValue != null && !textValue.matches("^-?[0-9]*(\\.[0-9]{1,6})?$")) {
                textValue = textValue.replace(".", "");
            }
            this.glenixText.setText(this.formatSixDp(textValue));
        }
    }

    protected String formatSixDp(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            Number number = this.format6dp.parse(text);
            return this.format6dp.format(number);
        }
        catch (Exception e) {
            return null;
        }
    }
}

