/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelComboAbstractController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.Pair;

public class GlenixLabelPairComboController
extends GlenixLabelComboAbstractController {
    private ChangeListener<Pair<String, String>> changeListener = null;
    private ObservableList<Pair<String, String>> itemKeyValues = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        Callback<ListView<Pair<String, String>>, ListCell<Pair<String, String>>> cellFactory = new Callback<ListView<Pair<String, String>>, ListCell<Pair<String, String>>>(){

            public ListCell<Pair<String, String>> call(ListView<Pair<String, String>> p) {
                ListCell<Pair<String, String>> cell = new ListCell<Pair<String, String>>(){

                    protected void updateItem(Pair<String, String> t, boolean bln) {
                        super.updateItem(t, bln);
                        if (t != null) {
                            this.setText((String)t.getValue());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.glenixCombo.setButtonCell((ListCell)cellFactory.call(null));
        this.glenixCombo.setCellFactory((Callback)cellFactory);
        if (this.itemKeyValues != null) {
            this.glenixCombo.setItems(this.itemKeyValues);
        }
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                if (GlenixLabelPairComboController.this.changeListener != null) {
                    GlenixLabelPairComboController.this.changeListener.changed(observable, oldValue, newValue);
                }
            }
        });
    }

    public void setSingleChangeListener(ChangeListener<Pair<String, String>> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setComboId(String id) {
        if (id == null) {
            this.glenixCombo.valueProperty().set(null);
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            Pair t;
            Object o = ol.get(i);
            if (o == null || !(o instanceof Pair) || !id.equals((t = (Pair)o).getKey())) continue;
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
        }
    }

    @Override
    public String getGlenixElementValue() {
        Pair t;
        int index = this.glenixCombo.getSelectionModel().getSelectedIndex();
        if (index >= 0 && (t = (Pair)this.glenixCombo.getItems().get(index)) != null) {
            return (String)t.getKey();
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<Pair<String, String>> ol) {
        this.itemKeyValues = ol;
        if (this.glenixCombo != null) {
            this.glenixCombo.setItems(ol);
        }
    }

    public String getDisplayValue(String key) {
        if (this.itemKeyValues == null || key == null) {
            return null;
        }
        for (Pair p : this.itemKeyValues) {
            if (!key.equals(p.getKey())) continue;
            return (String)p.getValue();
        }
        return null;
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.glenixCombo.getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.glenixCombo.getStyleClass().add((Object)"error_background");
        }
    }
}

