/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelOnlyController
implements GlenixController {
    protected ChangeListener<String> changeListener = null;
    @FXML
    protected Label label;
    private String glenixElementDescription;
    private String glenixElementGuidance;
    private String glenixElementTRLabel;
    private String glenixElementName;
    private String glenixElementNamespace;
    private String glenixElementDefaultValue;
    private String glenixElementImmutableValue;

    public void initialize(URL url, ResourceBundle rb) {
        this.label.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (GlenixLabelOnlyController.this.changeListener != null) {
                    GlenixLabelOnlyController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    @Override
    public Pane getPane() {
        return null;
    }

    @Override
    public GlenixPane getGlenixPane() {
        return null;
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 1;
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
    }

    @Override
    public String getGlenixElementGuidance() {
        return this.glenixElementGuidance;
    }

    @Override
    public void setGlenixElementGuidance(String glenixElementGuidance) {
        this.glenixElementGuidance = glenixElementGuidance;
    }

    @Override
    public String getGlenixElementTRLabel() {
        return this.glenixElementTRLabel;
    }

    @Override
    public void setGlenixElementTRLabel(String glenixElementTRLabel) {
        this.glenixElementTRLabel = glenixElementTRLabel;
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.glenixElementImmutableValue;
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        this.glenixElementImmutableValue = glenixElementImmutableValue;
        if (glenixElementImmutableValue == null) {
            this.label.setText(null);
        } else {
            this.label.setText(glenixElementImmutableValue.replace("\\n", "\n"));
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) {
        String name = this.getGlenixElementName();
        if (name == null) {
            return;
        }
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + name);
        el.setTextContent(this.getGlenixElementValue());
        resultElement.appendChild(el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
        }
    }

    @Override
    public void clearGlenixXBRL() {
        this.setGlenixElementValue(null);
    }

    @Override
    public String getGlenixElementValue() {
        return this.label.getText();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null) {
            this.label.setText(null);
        } else {
            this.label.setText(glenixElementValue.replace("\\n", "\n"));
        }
    }

    public void addTextChangeListener(ChangeListener changeListener) {
        this.label.textProperty().addListener(changeListener);
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void disableGlenixXBRL() {
    }

    @Override
    public void enableGlenixXBRL() {
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        throw new Exception("Error, Glenix label only does not implement build pdf");
    }
}

