/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelNoTruncate;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelOnly
extends Pane
implements GlenixPane,
GlenixController {
    protected Hyperlink glenixGuidance;
    protected Label glenixText = new GlenixLabelNoTruncate();
    protected ChangeListener<String> changeListener = null;
    protected GlenixController controller = null;
    protected String glenixElementName;
    protected String glenixElementNamespace;
    protected String glenixElementDefaultValue;
    protected String glenixElementImmutableValue;
    protected String glenixElementDescription;
    protected String glenixElementTRLabel;
    protected String glenixElementGuidance;
    protected boolean guidanceInited = false;
    protected boolean guidanceClicked = false;
    double lastwidth = -1.0;

    public GlenixLabelOnly() {
        this.glenixText.getStyleClass().add((Object)"glenixPaneText");
        this.getChildren().add((Object)this.glenixText);
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    public Control getControl() {
        return this.glenixText;
    }

    @Override
    public GlenixController getGlenixController() {
        return this;
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public String getGlenixElementValue() {
        return this.glenixText.getText();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null) {
            this.glenixText.setText(null);
        } else {
            this.glenixText.setText(glenixElementValue.replace("\\n", "\n"));
        }
    }

    @Override
    public void disableGlenixXBRL() {
    }

    @Override
    public void enableGlenixXBRL() {
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        throw new Exception("Error, Glenix label only does not implement build pdf");
    }

    public void addTextChangeListener(ChangeListener<String> changeListener) {
        this.glenixText.textProperty().addListener(changeListener);
    }

    public boolean glenixTextIsFocused() {
        return this.glenixText.isFocused();
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.getControl().getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.getControl().getStyleClass().add((Object)"error_background");
        }
    }

    @Override
    public Double getPDFFontSize() {
        return this.getFontSize();
    }

    @Override
    public boolean hasPDFValue() {
        String val = this.getGlenixElementValue();
        return val != null && !val.isEmpty();
    }

    @Override
    public boolean hasSearchText(String searchText) {
        String val = this.getGlenixElementValue();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementDescription();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementName();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        if (searchText.toLowerCase().startsWith("label:") && (val = this.getGlenixElementTRLabel()) != null && !val.isEmpty()) {
            String actualSearchText = searchText.toLowerCase().substring(6).trim();
            if (val.toLowerCase().equals(actualSearchText)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doPDFOutput(boolean printblanks) {
        if (printblanks) {
            return true;
        }
        return this.hasPDFValue();
    }

    @Override
    public String getPDFValueImageRight() {
        return null;
    }

    @Override
    public String getPDFValueImageLeft() {
        return null;
    }

    @Override
    public String getPDFLabelLetter() {
        return null;
    }

    @Override
    public String getPDFValueAlignment() {
        return null;
    }

    @Override
    public String getPDFValue() {
        return this.getGlenixElementValue();
    }

    @Override
    public String getPDFLabel() {
        return this.getGlenixElementDescription();
    }

    @Override
    public List<Node> getPDFChildNodes() {
        return null;
    }

    @Override
    public Pane getPane() {
        return this;
    }

    @Override
    public GlenixPane getGlenixPane() {
        return this;
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 2;
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.glenixElementImmutableValue;
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        this.setGlenixElementValue(glenixElementImmutableValue);
        this.glenixElementImmutableValue = glenixElementImmutableValue;
        if (glenixElementImmutableValue == null) {
            this.glenixText.setText(null);
        } else {
            this.glenixText.setText(glenixElementImmutableValue.replace("\\n", "\n"));
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String name = this.getGlenixElementName();
        if (name == null) {
            return;
        }
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + name);
        el.setTextContent(this.getGlenixElementValue());
        resultElement.appendChild(el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
        }
    }

    @Override
    public void clearGlenixXBRL() {
        this.setGlenixElementValue(null);
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
    }

    @Override
    public String getGlenixElementTRLabel() {
        return this.glenixElementTRLabel;
    }

    @Override
    public void setGlenixElementTRLabel(String glenixElementTRLabel) {
        this.glenixElementTRLabel = glenixElementTRLabel;
    }

    public Double getFontSize() {
        if (this.glenixText == null) {
            return null;
        }
        return this.glenixText.getFont().getSize();
    }

    public Double getDouble() {
        try {
            String str = this.getGlenixElementValue();
            if (str == null || str.isEmpty()) {
                return null;
            }
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public String getGlenixElementGuidance() {
        return this.glenixElementGuidance;
    }

    @Override
    public void setGlenixElementGuidance(String glenixElementGuidance) {
        this.glenixElementGuidance = glenixElementGuidance;
        if (glenixElementGuidance == null || glenixElementGuidance.isEmpty()) {
            this.glenixGuidance = null;
            return;
        }
        if (this.glenixGuidance == null) {
            this.glenixGuidance = new Hyperlink();
            this.glenixGuidance.setText("?");
            this.glenixGuidance.getStyleClass().add((Object)"glenixPaneGuidance");
            this.getChildren().add((Object)this.glenixGuidance);
        }
        this.initializeGlenixElementGuidance();
    }

    public void initializeGlenixElementGuidance() {
        this.guidanceInited = true;
        if (this.glenixElementGuidance == null) {
            this.glenixGuidance.setTooltip(null);
        } else {
            Tooltip tt = new Tooltip();
            tt.setText(this.glenixElementGuidance.replace("\\n", "\n"));
            tt.setAutoHide(false);
            tt.setMaxWidth(500.0);
            tt.setMaxHeight(1000.0);
            tt.wrapTextProperty().set(true);
            this.glenixGuidance.setTooltip(tt);
            this.glenixGuidance.setOnAction(event -> {
                Tooltip att = this.glenixGuidance.getTooltip();
                if (att != null) {
                    if (att.isShowing()) {
                        if (this.guidanceClicked) {
                            att.hide();
                            this.guidanceClicked = false;
                        } else {
                            Bounds boundsInScreen = this.glenixGuidance.localToScreen(this.glenixGuidance.getBoundsInLocal());
                            att.show((Node)this.glenixGuidance, boundsInScreen.getMaxX(), boundsInScreen.getMaxY() + 10.0);
                            this.guidanceClicked = true;
                        }
                    } else {
                        Bounds boundsInScreen = this.glenixGuidance.localToScreen(this.glenixGuidance.getBoundsInLocal());
                        att.show((Node)this.glenixGuidance, boundsInScreen.getMaxX(), boundsInScreen.getMaxY() + 10.0);
                        this.guidanceClicked = true;
                    }
                }
            });
        }
    }

    protected void layoutChildren() {
        double width = this.getWidth();
        Insets ins = this.getInsets();
        double realwidth = width - ins.getLeft() - ins.getRight();
        int fontsize = (int)this.glenixText.getFont().getSize();
        if (fontsize <= 0) {
            fontsize = 13;
        } else if (fontsize < 4) {
            fontsize = 4;
        }
        int hgap = 0;
        int guidewidth = 0;
        if (this.glenixGuidance != null) {
            guidewidth = (int)((double)fontsize * 1.5);
            hgap = 5;
        }
        double textwidth = realwidth - (double)guidewidth - (double)hgap;
        double maxh = this.glenixText.prefHeight(textwidth);
        Control control = this.getControl();
        double tmph = control.prefHeight(textwidth);
        if (tmph > maxh) {
            maxh = tmph;
        }
        control.setPrefWidth(textwidth);
        control.setMinWidth(textwidth);
        control.setMaxWidth(textwidth);
        this.layoutInArea((Node)control, 0.0, 0.0, textwidth, maxh, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
        if (this.glenixGuidance != null) {
            this.layoutInArea((Node)this.glenixGuidance, textwidth + (double)hgap, 0.0, guidewidth, maxh, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
        }
        if (width != this.lastwidth) {
            Platform.runLater(() -> this.requestLayout());
        }
        this.lastwidth = width;
    }

    protected double computePrefHeight(double forWidth) {
        double usewidth = forWidth;
        if (usewidth <= 0.0) {
            usewidth = this.getWidth();
        }
        if (usewidth <= 0.0) {
            usewidth = -1.0;
        }
        Insets ins = this.getInsets();
        int fontsize = (int)this.glenixText.getFont().getSize();
        if (fontsize <= 0) {
            fontsize = 13;
        } else if (fontsize < 4) {
            fontsize = 4;
        }
        int guidewidth = 0;
        if (this.glenixGuidance != null) {
            guidewidth = (int)((double)fontsize * 1.5) + 5;
        }
        double realwidth = -1.0;
        if (usewidth > 0.0) {
            realwidth = usewidth - ins.getLeft() - ins.getRight() - (double)guidewidth;
        }
        return this.glenixText.prefHeight(realwidth);
    }

    @Override
    public Double getPDFValueWidthRatio() {
        return 0.0;
    }
}

