/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelLabelController
extends GlenixLabelAbstractController {
    @FXML
    protected Label glenixText;
    protected ChangeListener<String> changeListener = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.glenixText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (GlenixLabelLabelController.this.changeListener != null) {
                    GlenixLabelLabelController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    public String getText() {
        return this.glenixText.getText();
    }

    public void setText(String value) {
        this.glenixText.setText(value);
    }

    public StringProperty textProperty() {
        return this.glenixText.textProperty();
    }

    @Override
    public String getGlenixElementValue() {
        return this.getText();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null) {
            this.setText(null);
            return;
        }
        this.setText(glenixElementValue.replace("\\n", "\n"));
    }

    public void addTextChangeListener(ChangeListener changeListener) {
        this.glenixText.textProperty().addListener(changeListener);
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public boolean glenixTextIsFocused() {
        return this.glenixText.isFocused();
    }

    @Override
    public void disableGlenixXBRL() {
    }

    @Override
    public void enableGlenixXBRL() {
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && isVisible.equals("false")) {
                this.pane.setManaged(false);
                this.pane.setVisible(false);
            } else {
                this.pane.setManaged(true);
                this.pane.setVisible(true);
            }
        }
    }
}

