/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTwoDecimalNumber;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javafx.beans.value.ObservableValue;

public class GlenixLabelFourDecimalPositiveNumber
extends GlenixLabelTwoDecimalNumber {
    private NumberFormat format4dp = new DecimalFormat("#0.0000");

    public GlenixLabelFourDecimalPositiveNumber() throws Exception {
        super("#0.0000");
    }

    @Override
    public String getEditRegexPattern() {
        return "^[0-9]*(\\.[0-9]{0,4})?$";
    }

    @Override
    public String getFinalRegexPattern() {
        return "^[0-9]*(\\.[0-9]{1,4})?$";
    }

    @Override
    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            String pattern = this.getFinalRegexPattern();
            if (pattern == null || pattern.isEmpty()) {
                return;
            }
            String textValue = this.glenixText.getText();
            if (textValue != null && !textValue.matches("^[0-9]*(\\.[0-9]{1,4})?$")) {
                textValue = textValue.replace(".", "");
            }
            this.glenixText.setText(this.formatFourDp(textValue));
        }
    }

    protected String formatFourDp(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            Number number = this.format4dp.parse(text);
            return this.format4dp.format(number);
        }
        catch (Exception e) {
            return null;
        }
    }
}

