/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTwoDecimalNumberController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelEightDecimalNumberController
extends GlenixLabelTwoDecimalNumberController {
    private String lastValidatedValue = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.glenixText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.matches("^-?[0-9]*(\\.[0-9]{0,8})?$")) {
                    GlenixLabelEightDecimalNumberController.this.glenixText.setText(oldValue);
                } else if (GlenixLabelEightDecimalNumberController.this.lastValidatedValue == null && newValue != null || GlenixLabelEightDecimalNumberController.this.lastValidatedValue != null && !GlenixLabelEightDecimalNumberController.this.lastValidatedValue.equals(newValue)) {
                    GlenixLabelEightDecimalNumberController.this.lastValidatedValue = newValue;
                    if (GlenixLabelEightDecimalNumberController.this.changeListener != null) {
                        GlenixLabelEightDecimalNumberController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                    }
                }
            }
        });
        this.glenixText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                String textValue;
                if (!newValue.booleanValue() && (textValue = GlenixLabelEightDecimalNumberController.this.glenixText.getText()) != null && !textValue.matches("^-?[0-9]*(\\.[0-9]{1,8})?$")) {
                    GlenixLabelEightDecimalNumberController.this.glenixText.setText(textValue.replace(".", ""));
                }
            }
        });
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && isVisible.equals("false")) {
                this.pane.setManaged(false);
                this.pane.setVisible(false);
            } else {
                this.pane.setManaged(true);
                this.pane.setVisible(true);
            }
            String isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable");
            if (isEditable != null && isEditable.equals("false")) {
                this.glenixText.setEditable(false);
            } else {
                this.glenixText.setEditable(true);
            }
        }
    }
}

