/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelTwoDecimalNumber;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javafx.beans.value.ObservableValue;

public class GlenixLabelEightDecimalNumber
extends GlenixLabelTwoDecimalNumber {
    private NumberFormat format8dp = new DecimalFormat("#0.00000000");

    public GlenixLabelEightDecimalNumber() throws Exception {
        super("#0.00000000");
    }

    @Override
    public String getPDFLabelLetter() {
        return this.getGlenixElementTRLabel();
    }

    @Override
    public String getPDFValueAlignment() {
        return "right";
    }

    @Override
    public String getPDFValue() {
        Double d = this.getDouble();
        if (d == null) {
            return null;
        }
        return this.numberFormat.format(d);
    }

    @Override
    public String getPDFLabel() {
        return this.getGlenixElementDescription();
    }

    @Override
    public String getEditRegexPattern() {
        return "^-?[0-9]*(\\.[0-9]{0,8})?$";
    }

    @Override
    public String getFinalRegexPattern() {
        return "^-?[0-9]*(\\.[0-9]{1,8})?$";
    }

    @Override
    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            String pattern = this.getFinalRegexPattern();
            if (pattern == null || pattern.isEmpty()) {
                return;
            }
            String textValue = this.glenixText.getText();
            if (textValue != null && !textValue.matches("^-?[0-9]*(\\.[0-9]{1,8})?$")) {
                textValue = textValue.replace(".", "");
            }
            this.glenixText.setText(this.formatEightDp(textValue));
        }
    }

    protected String formatEightDp(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            Number number = this.format8dp.parse(text);
            return this.format8dp.format(number);
        }
        catch (Exception e) {
            return null;
        }
    }
}

