/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelDateLabelController;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;

public class GlenixLabelDateTimeLabelController
extends GlenixLabelDateLabelController {
    private String pattern = "dd MMM yyyy HH:mm";

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.inputDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.glenixText.setText(null);
            return;
        }
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(glenixElementValue);
            this.setDateTime(zdt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDateTime(ZonedDateTime zdt) {
        if (zdt != null) {
            this.glenixElementValue = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            ZoneId zoneIdDefault = ZoneId.systemDefault();
            ZonedDateTime hereTime = ZonedDateTime.ofInstant(zdt.toInstant(), zoneIdDefault);
            String formattedDateTime = hereTime.format(this.inputDateFormatter);
            this.glenixText.setText(formattedDateTime);
            return;
        }
        this.glenixElementValue = null;
        this.glenixText.setText(null);
    }

    public void setDateTimeToNow() {
        ZoneId zoneIdUTC = ZoneId.of("UTC");
        ZonedDateTime now = ZonedDateTime.now(zoneIdUTC);
        this.setDateTime(now);
    }
}

