/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractController;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Label;

public class GlenixLabelDateLabelController
extends GlenixLabelAbstractController {
    @FXML
    protected Label glenixText;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter inputDateFormatter;
    protected DateTimeFormatter outputDateFormatter;
    private ChangeListener<LocalDate> changeListener = null;
    protected LocalDate localDate;
    protected String glenixElementValue = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.inputDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.outputDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    @Override
    public String getGlenixElementValue() {
        return this.glenixElementValue;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.glenixElementValue = glenixElementValue;
            this.glenixText.setText(null);
            return;
        }
        this.localDate = LocalDate.parse(glenixElementValue, this.outputDateFormatter);
        if (this.localDate != null) {
            this.glenixElementValue = glenixElementValue;
            String formattedDate = this.localDate.format(this.inputDateFormatter);
            this.glenixText.setText(formattedDate);
            return;
        }
        this.glenixElementValue = null;
        this.glenixText.setText(null);
    }

    @Override
    public void disableGlenixXBRL() {
        this.glenixText.disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.glenixText.disableProperty().set(false);
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public void setLocalDate(LocalDate date) {
        this.localDate = date;
        if (this.localDate != null) {
            this.glenixElementValue = this.localDate.format(this.outputDateFormatter);
            String formattedDate = this.localDate.format(this.inputDateFormatter);
            this.glenixText.setText(formattedDate);
        }
    }

    public void setSingleChangeListener(ChangeListener<LocalDate> changeListener) {
        this.changeListener = changeListener;
    }

    public String getDisplayValue() {
        return this.glenixText.getText();
    }
}

