/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelDateInterface;
import au.com.glenix.widget.GlenixLabelLabel;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ChangeListener;

public class GlenixLabelDateLabel
extends GlenixLabelLabel
implements GlenixLabelDateInterface {
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter inputDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
    protected DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private ChangeListener<LocalDate> dateChangeListener = null;
    protected LocalDate localDate;
    protected String glenixElementValue = null;

    @Override
    public String getGlenixElementValue() {
        return this.glenixElementValue;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.glenixElementValue = glenixElementValue;
            this.glenixText.setText(null);
            return;
        }
        this.localDate = LocalDate.parse(glenixElementValue, this.outputDateFormatter);
        if (this.localDate != null) {
            this.glenixElementValue = glenixElementValue;
            String formattedDate = this.localDate.format(this.inputDateFormatter);
            this.glenixText.setText(formattedDate);
            return;
        }
        this.glenixElementValue = null;
        this.glenixText.setText(null);
    }

    @Override
    public LocalDate getLocalDate() {
        return this.localDate;
    }

    @Override
    public void setLocalDate(LocalDate date) {
        this.localDate = date;
        if (this.localDate != null) {
            this.glenixElementValue = this.localDate.format(this.outputDateFormatter);
            String formattedDate = this.localDate.format(this.inputDateFormatter);
            this.glenixText.setText(formattedDate);
        }
    }

    @Override
    public void setSingleDateChangeListener(ChangeListener<LocalDate> changeListener) {
        this.dateChangeListener = changeListener;
    }

    public String getDisplayValue() {
        return this.glenixText.getText();
    }
}

