/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractController;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;

public class GlenixLabelDateController
extends GlenixLabelAbstractController {
    @FXML
    protected DatePicker glenixDate;
    private String pattern = "dd/MM/yyyy";
    private DateTimeFormatter inputDateFormatter;
    private DateTimeFormatter outputDateFormatter;
    private ChangeListener<LocalDate> changeListener = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.inputDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.outputDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){

            public String toString(LocalDate date) {
                if (date != null) {
                    return GlenixLabelDateController.this.inputDateFormatter.format(date);
                }
                return "";
            }

            public LocalDate fromString(String string) {
                if (string != null && !string.isEmpty()) {
                    return LocalDate.parse(string, GlenixLabelDateController.this.inputDateFormatter);
                }
                return null;
            }
        };
        this.glenixDate.setConverter((StringConverter)converter);
        this.glenixDate.setPromptText(this.pattern.toLowerCase());
        this.glenixDate.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                if (GlenixLabelDateController.this.changeListener != null) {
                    GlenixLabelDateController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    @Override
    public String getGlenixElementValue() {
        LocalDate ld = (LocalDate)this.glenixDate.getValue();
        if (ld == null) {
            return null;
        }
        return this.outputDateFormatter.format(ld);
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.glenixDate.setValue(null);
            return;
        }
        LocalDate localDate = LocalDate.parse(glenixElementValue, this.outputDateFormatter);
        if (localDate != null) {
            this.glenixDate.setValue((Object)localDate);
        }
    }

    public LocalDate getLocalDate() {
        return (LocalDate)this.glenixDate.getValue();
    }

    public void setLocalDate(LocalDate date) {
        this.glenixDate.valueProperty().setValue((Object)date);
    }

    public void setSingleDateChangeListener(ChangeListener<LocalDate> changeListener) {
        this.changeListener = changeListener;
    }

    public void fireSingleChangeListener() {
        LocalDate ld = this.getLocalDate();
        this.changeListener.changed(null, (Object)ld, (Object)ld);
    }

    @Override
    public void disableGlenixXBRL() {
        this.glenixDate.disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.glenixDate.disableProperty().set(false);
    }

    public void requestFocus() {
        this.glenixDate.requestFocus();
    }

    public void show() {
        this.glenixDate.show();
    }

    public boolean isShowing() {
        return this.glenixDate.isShowing();
    }
}

