/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractPane;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;

public class GlenixLabelDate
extends GlenixLabelAbstractPane {
    protected DatePicker glenixDate = new DatePicker();
    private DateTimeFormatter inputDateFormatter;
    private DateTimeFormatter inputDateFormatter2;
    private DateTimeFormatter inputDateFormatter3;
    private DateTimeFormatter displayDateFormatter;
    private DateTimeFormatter outputDateFormatter;
    private ChangeListener<LocalDate> dateChangeListener = null;

    public GlenixLabelDate() {
        this.glenixDate.getStyleClass().add((Object)"glenixPaneDate");
        this.getChildren().add((Object)this.glenixDate);
        this.inputDateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        this.inputDateFormatter2 = DateTimeFormatter.ofPattern("d/MM/yyyy");
        this.inputDateFormatter3 = DateTimeFormatter.ofPattern("d/MM/yy");
        this.displayDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
        this.outputDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){

            public String toString(LocalDate date) {
                if (date != null) {
                    return GlenixLabelDate.this.displayDateFormatter.format(date);
                }
                return "";
            }

            public LocalDate fromString(String string) {
                if (string != null && !string.isEmpty()) {
                    try {
                        return LocalDate.parse(string, GlenixLabelDate.this.inputDateFormatter);
                    }
                    catch (Exception e) {
                        try {
                            return LocalDate.parse(string, GlenixLabelDate.this.displayDateFormatter);
                        }
                        catch (Exception ee) {
                            try {
                                return LocalDate.parse(string, GlenixLabelDate.this.inputDateFormatter2);
                            }
                            catch (Exception eee) {
                                try {
                                    return LocalDate.parse(string, GlenixLabelDate.this.inputDateFormatter3);
                                }
                                catch (Exception eeee) {
                                    e.printStackTrace();
                                    return null;
                                }
                            }
                        }
                    }
                }
                return null;
            }
        };
        this.glenixDate.setConverter((StringConverter)converter);
        this.glenixDate.setPromptText("dd/mm/yyyy");
        this.glenixDate.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                if (GlenixLabelDate.this.dateChangeListener != null) {
                    GlenixLabelDate.this.dateChangeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.glenixDate;
    }

    @Override
    public String getGlenixElementValue() {
        LocalDate ld = (LocalDate)this.glenixDate.getValue();
        if (ld == null) {
            return null;
        }
        return this.outputDateFormatter.format(ld);
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null || glenixElementValue.equals("")) {
            this.glenixDate.setValue(null);
            return;
        }
        LocalDate localDate = LocalDate.parse(glenixElementValue, this.outputDateFormatter);
        if (localDate != null) {
            this.glenixDate.setValue((Object)localDate);
        }
    }

    public LocalDate getLocalDate() {
        return (LocalDate)this.glenixDate.getValue();
    }

    public void setLocalDate(LocalDate date) {
        this.glenixDate.valueProperty().setValue((Object)date);
    }

    public void setSingleDateChangeListener(ChangeListener<LocalDate> changeListener) {
        this.dateChangeListener = changeListener;
    }

    public void fireSingleChangeListener() {
        LocalDate ld = this.getLocalDate();
        this.dateChangeListener.changed(null, (Object)ld, (Object)ld);
    }

    public boolean glenixTextIsFocused() {
        return this.glenixDate.isFocused();
    }

    @Override
    public String getPDFValue() {
        LocalDate ld = this.getLocalDate();
        if (ld == null) {
            return null;
        }
        return this.displayDateFormatter.format(ld);
    }
}

