/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelComboAbstractController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public class GlenixLabelComboController
extends GlenixLabelComboAbstractController {
    private ChangeListener<String> changeListener = null;
    private ObservableList<String> itemKeyValues = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (GlenixLabelComboController.this.changeListener != null) {
                    GlenixLabelComboController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setComboId(String id) {
        if (id == null) {
            this.glenixCombo.valueProperty().set(null);
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            String o = (String)ol.get(i);
            String t = o.toString();
            if (!id.equals(t)) continue;
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
        }
    }

    @Override
    public String getGlenixElementValue() {
        int index = this.glenixCombo.getSelectionModel().getSelectedIndex();
        if (index >= 0) {
            String t = (String)this.glenixCombo.getItems().get(index);
            return t;
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<String> ol) {
        this.itemKeyValues = ol;
        if (this.glenixCombo != null) {
            this.glenixCombo.setItems(ol);
        }
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.glenixCombo.getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.glenixCombo.getStyleClass().add((Object)"error_background");
        }
    }
}

