/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractPane;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelCombo
extends GlenixLabelAbstractPane {
    protected ComboBox glenixCombo = new ComboBox();
    private ChangeListener<String> changeListener = null;
    private ObservableList<String> itemKeyValues = null;

    public GlenixLabelCombo() throws Exception {
        this.glenixCombo.getStyleClass().add((Object)"glenixPaneCombo");
        this.getChildren().add((Object)this.glenixCombo);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (GlenixLabelCombo.this.changeListener != null) {
                    GlenixLabelCombo.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.glenixCombo;
    }

    @Override
    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public void setComboId(String id) {
        if (id == null) {
            this.glenixCombo.valueProperty().set(null);
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            String o = (String)ol.get(i);
            String t = o.toString();
            if (!id.equals(t)) continue;
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
        }
    }

    @Override
    public String getGlenixElementValue() {
        int index = this.glenixCombo.getSelectionModel().getSelectedIndex();
        if (index >= 0) {
            String t = (String)this.glenixCombo.getItems().get(index);
            return t;
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<String> ol) {
        this.itemKeyValues = ol;
        if (this.glenixCombo != null) {
            this.glenixCombo.setItems(ol);
        }
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    @Override
    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.glenixCombo.getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.glenixCombo.getStyleClass().add((Object)"error_background");
        }
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && isVisible.equals("false")) {
                this.setManaged(false);
                this.setVisible(false);
            } else {
                this.setManaged(true);
                this.setVisible(true);
            }
            String isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable");
            if (isEditable != null && isEditable.equals("false")) {
                this.glenixCombo.setEditable(false);
            } else {
                this.glenixCombo.setEditable(true);
            }
        }
    }
}

