/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractPane;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelCheckbox
extends GlenixLabelAbstractPane {
    protected CheckBox glenixCheckbox = new CheckBox();

    public GlenixLabelCheckbox() throws Exception {
        this.glenixCheckbox.getStyleClass().add((Object)"glenixPaneCheckbox");
        this.getChildren().add((Object)this.glenixCheckbox);
        this.glenixCheckbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (GlenixLabelCheckbox.this.changeListener != null) {
                    GlenixLabelCheckbox.this.changeListener.changed(null, null, (Object)GlenixLabelCheckbox.this.getGlenixElementValue());
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.glenixCheckbox;
    }

    @Override
    public String getGlenixElementValue() {
        if (this.glenixCheckbox.isSelected()) {
            return this.getGlenixElementDefaultValue();
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        if (glenixElementValue == null) {
            this.glenixCheckbox.setSelected(false);
        } else if (glenixElementValue.equals(this.getGlenixElementDefaultValue())) {
            this.glenixCheckbox.setSelected(true);
            return;
        }
        this.glenixCheckbox.setSelected(false);
    }

    @Override
    public void disableGlenixXBRL() {
        this.glenixCheckbox.disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.glenixCheckbox.disableProperty().set(false);
    }

    @Override
    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            String isEditable;
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && !isVisible.isEmpty()) {
                if (isVisible.equals("false")) {
                    this.setManaged(false);
                    this.setVisible(false);
                } else {
                    this.setManaged(true);
                    this.setVisible(true);
                }
            }
            if ((isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable")) != null && !isEditable.isEmpty()) {
                if (isEditable.equals("false")) {
                    this.glenixCheckbox.disableProperty().set(true);
                } else {
                    this.glenixCheckbox.disableProperty().set(false);
                }
            }
        }
    }
}

