/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelAbstractPane;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.text.Font;
import javafx.util.Callback;
import javafx.util.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelBlankNoYesCombo
extends GlenixLabelAbstractPane {
    protected ComboBox glenixCombo = new ComboBox();
    private ChangeListener<Pair<String, String>> comboChangeListener = null;
    private ObservableList<Pair<String, String>> itemKeyValues = null;

    public GlenixLabelBlankNoYesCombo() {
        this.setDefaultItems();
        this.glenixCombo.getStyleClass().add((Object)"glenixPaneCombo");
        this.getChildren().add((Object)this.glenixCombo);
        Callback<ListView<Pair<String, String>>, ListCell<Pair<String, String>>> cellFactory = new Callback<ListView<Pair<String, String>>, ListCell<Pair<String, String>>>(){

            public ListCell<Pair<String, String>> call(ListView<Pair<String, String>> p) {
                ListCell<Pair<String, String>> cell = new ListCell<Pair<String, String>>(){

                    protected void updateItem(Pair<String, String> t, boolean bln) {
                        super.updateItem(t, bln);
                        if (t != null) {
                            this.setText((String)t.getValue());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.glenixCombo.setButtonCell((ListCell)cellFactory.call(null));
        this.glenixCombo.setCellFactory((Callback)cellFactory);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                if (GlenixLabelBlankNoYesCombo.this.comboChangeListener != null) {
                    GlenixLabelBlankNoYesCombo.this.comboChangeListener.changed(observable, oldValue, newValue);
                }
            }
        });
    }

    public void setDefaultItems() {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair((Object)"", (Object)""));
        pairs.add(new Pair((Object)"false", (Object)"No"));
        pairs.add(new Pair((Object)"true", (Object)"Yes"));
        ObservableList ol = FXCollections.observableArrayList(pairs);
        this.setItems((ObservableList<Pair<String, String>>)ol);
    }

    public void setSingleComboChangeListener(ChangeListener<Pair<String, String>> changeListener) {
        this.comboChangeListener = changeListener;
    }

    @Override
    public Control getControl() {
        return this.glenixCombo;
    }

    public void setComboId(String id) {
        if (id == null) {
            this.glenixCombo.valueProperty().set(null);
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            Pair t;
            Object o = ol.get(i);
            if (o == null || !(o instanceof Pair) || !id.equals((t = (Pair)o).getKey())) continue;
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
        }
    }

    @Override
    public String getGlenixElementValue() {
        Pair t;
        int index = this.glenixCombo.getSelectionModel().getSelectedIndex();
        if (index >= 0 && (t = (Pair)this.glenixCombo.getItems().get(index)) != null) {
            return (String)t.getKey();
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<Pair<String, String>> ol) {
        this.itemKeyValues = ol;
        if (this.glenixCombo != null) {
            this.glenixCombo.setItems(ol);
        }
    }

    public String getDisplayValue(String key) {
        if (this.itemKeyValues == null || key == null) {
            return null;
        }
        for (Pair p : this.itemKeyValues) {
            if (!key.equals(p.getKey())) continue;
            return (String)p.getValue();
        }
        return null;
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    @Override
    public void disableGlenixXBRL() {
        this.glenixCombo.disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.glenixCombo.disableProperty().set(false);
    }

    @Override
    public Double getPDFValueWidthRatio() {
        int tw = this.getTextWidth();
        if (tw >= 0 && tw <= 100) {
            return (double)tw / 100.0;
        }
        if (this.glenixLabel == null) {
            return 1.0;
        }
        Double result = 1.0 - this.glenixLabel.getWidth() / this.glenixCombo.getWidth();
        if (result < 0.0) {
            return 0.0;
        }
        if (result > 1.0) {
            return 1.0;
        }
        return result;
    }

    @Override
    public Double getFontSize() {
        Font f;
        ListCell lc;
        if (this.glenixCombo != null && (lc = this.glenixCombo.getButtonCell()) != null && (f = (Font)lc.fontProperty().get()) != null) {
            return f.getSize();
        }
        return this.glenixLabel.getFont().getSize();
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            String isEditable;
            this.setGlenixElementValue(loadElement.getTextContent());
            String isVisible = loadElement.getAttributeNS("http://www.glenix.com.au/", "isVisible");
            if (isVisible != null && !isVisible.isEmpty()) {
                if (isVisible.equals("false")) {
                    this.setManaged(false);
                    this.setVisible(false);
                } else {
                    this.setManaged(true);
                    this.setVisible(true);
                }
            }
            if ((isEditable = loadElement.getAttributeNS("http://www.glenix.com.au/", "isEditable")) != null && !isEditable.isEmpty()) {
                if (isEditable.equals("false")) {
                    this.glenixCombo.disableProperty().set(true);
                } else {
                    this.glenixCombo.disableProperty().set(false);
                }
            }
        }
    }
}

