/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelNoTruncate;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GlenixLabelAbstractPane
extends Pane
implements GlenixPane,
GlenixController {
    protected Label glenixLabel = new GlenixLabelNoTruncate();
    protected Hyperlink glenixGuidance;
    protected Label taxReturnLabel;
    protected int spacing = 5;
    protected int textWidth = 40;
    protected ChangeListener<String> changeListener = null;
    protected GlenixController controller = null;
    protected String glenixElementName;
    protected String glenixElementNamespace;
    protected String glenixElementDefaultValue;
    protected String glenixElementImmutableValue;
    protected String glenixElementDescription;
    protected String glenixElementGuidance;
    protected boolean guidanceInited = false;
    protected boolean guidanceClicked = false;
    protected String glenixElementTRLabel;
    protected String lastValidatedValue = null;
    protected String editRegexPattern = null;
    protected String finalRegexPattern = null;
    double lastwidth = -1.0;

    public GlenixLabelAbstractPane() {
        this.glenixLabel.getStyleClass().add((Object)"glenixPaneLabel");
        this.getChildren().add((Object)this.glenixLabel);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
    }

    public abstract Control getControl();

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setTextWidth(int textWidth) {
        this.textWidth = textWidth;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    @Override
    public GlenixController getGlenixController() {
        return this;
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.getControl().getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.getControl().getStyleClass().add((Object)"error_background");
        }
    }

    @Override
    public Double getPDFFontSize() {
        return this.getFontSize();
    }

    @Override
    public boolean hasPDFValue() {
        String val = this.getGlenixElementValue();
        return val != null && !val.isEmpty();
    }

    @Override
    public boolean hasSearchText(String searchText) {
        String val = this.getGlenixElementValue();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementDescription();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        val = this.getGlenixElementName();
        if (val != null && !val.isEmpty() && val.toLowerCase().contains(searchText)) {
            return true;
        }
        if (searchText.toLowerCase().startsWith("label:") && (val = this.getGlenixElementTRLabel()) != null && !val.isEmpty()) {
            String actualSearchText = searchText.toLowerCase().substring(6).trim();
            if (val.toLowerCase().equals(actualSearchText)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doPDFOutput(boolean printblanks) {
        if (printblanks) {
            return true;
        }
        return this.hasPDFValue();
    }

    @Override
    public String getPDFValueImageRight() {
        return null;
    }

    @Override
    public String getPDFValueImageLeft() {
        return null;
    }

    @Override
    public String getPDFLabelLetter() {
        return null;
    }

    @Override
    public String getPDFValueAlignment() {
        return null;
    }

    @Override
    public String getPDFValue() {
        return this.getGlenixElementValue();
    }

    @Override
    public String getPDFLabel() {
        return this.getGlenixElementDescription();
    }

    @Override
    public List<Node> getPDFChildNodes() {
        return null;
    }

    @Override
    public Pane getPane() {
        return this;
    }

    @Override
    public GlenixPane getGlenixPane() {
        return this;
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 2;
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.glenixElementImmutableValue;
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        this.setGlenixElementValue(glenixElementImmutableValue);
        this.glenixElementImmutableValue = glenixElementImmutableValue;
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String name = this.getGlenixElementName();
        if (name == null) {
            return;
        }
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + name);
        el.setTextContent(this.getGlenixElementValue());
        resultElement.appendChild(el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
        }
    }

    @Override
    public void clearGlenixXBRL() {
        this.setGlenixElementValue(null);
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
        this.glenixLabel.setText(glenixElementDescription);
    }

    @Override
    public String getGlenixElementGuidance() {
        return this.glenixElementGuidance;
    }

    @Override
    public void setGlenixElementGuidance(String glenixElementGuidance) {
        this.glenixElementGuidance = glenixElementGuidance;
        if (glenixElementGuidance == null || glenixElementGuidance.isEmpty()) {
            this.glenixGuidance = null;
            return;
        }
        if (this.glenixGuidance == null) {
            this.glenixGuidance = new Hyperlink();
            this.glenixGuidance.setText("?");
            this.glenixGuidance.getStyleClass().add((Object)"glenixPaneGuidance");
            this.getChildren().add((Object)this.glenixGuidance);
        }
        this.initializeGlenixElementGuidance();
    }

    public void initializeGlenixElementGuidance() {
        this.guidanceInited = true;
        if (this.glenixElementGuidance == null) {
            this.glenixGuidance.setTooltip(null);
        } else {
            Tooltip tt = new Tooltip();
            tt.setText(this.glenixElementGuidance.replace("\\n", "\n"));
            tt.setAutoHide(false);
            tt.setMaxWidth(500.0);
            tt.setMaxHeight(1000.0);
            tt.wrapTextProperty().set(true);
            this.glenixGuidance.setTooltip(tt);
            this.glenixGuidance.setOnAction(event -> {
                Tooltip att = this.glenixGuidance.getTooltip();
                if (att != null) {
                    if (att.isShowing()) {
                        if (this.guidanceClicked) {
                            att.hide();
                            this.guidanceClicked = false;
                        } else {
                            Bounds boundsInScreen = this.glenixGuidance.localToScreen(this.glenixGuidance.getBoundsInLocal());
                            att.show((Node)this.glenixGuidance, boundsInScreen.getMaxX(), boundsInScreen.getMaxY() + 10.0);
                            this.guidanceClicked = true;
                        }
                    } else {
                        Bounds boundsInScreen = this.glenixGuidance.localToScreen(this.glenixGuidance.getBoundsInLocal());
                        att.show((Node)this.glenixGuidance, boundsInScreen.getMaxX(), boundsInScreen.getMaxY() + 10.0);
                        this.guidanceClicked = true;
                    }
                }
            });
        }
    }

    @Override
    public String getGlenixElementTRLabel() {
        return this.glenixElementTRLabel;
    }

    @Override
    public void setGlenixElementTRLabel(String glenixElementTRLabel) {
        this.glenixElementTRLabel = glenixElementTRLabel;
        if (glenixElementTRLabel == null || glenixElementTRLabel.isEmpty()) {
            this.taxReturnLabel = null;
            return;
        }
        if (this.taxReturnLabel == null) {
            this.taxReturnLabel = new Label();
            this.taxReturnLabel.setText(glenixElementTRLabel);
            this.taxReturnLabel.getStyleClass().add((Object)"glenixPaneTRLabel");
            this.getChildren().add((Object)this.taxReturnLabel);
        }
        this.taxReturnLabel.setText(glenixElementTRLabel);
    }

    public Double getFontSize() {
        if (this.glenixLabel == null) {
            return null;
        }
        return this.glenixLabel.getFont().getSize();
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        throw new Exception("Error, Glenix Label does not implement build pdf");
    }

    @FXML
    public String getEditRegexPattern() {
        return this.editRegexPattern;
    }

    @FXML
    public void setEditRegexPattern(String value) {
        this.editRegexPattern = value;
    }

    @FXML
    public String getFinalRegexPattern() {
        return this.finalRegexPattern;
    }

    @FXML
    public void setFinalRegexPattern(String value) {
        this.finalRegexPattern = value;
    }

    public Double getDouble() {
        try {
            String str = this.getGlenixElementValue();
            if (str == null || str.isEmpty()) {
                return null;
            }
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected void layoutChildren() {
        Region zeroCrossOutCross;
        Region indicatorDollar;
        Control control;
        double tmph;
        double tmph2;
        int twp;
        int fontsize;
        double width = this.getWidth();
        Insets ins = this.getInsets();
        double realwidth = width - ins.getLeft() - ins.getRight();
        int hgap = this.spacing;
        if (hgap < 0 || (double)hgap > realwidth / 2.0) {
            hgap = 5;
        }
        if ((fontsize = (int)this.glenixLabel.getFont().getSize()) <= 0) {
            fontsize = 13;
        } else if (fontsize < 4) {
            fontsize = 4;
        }
        int guidewidth = 0;
        int sumhgap = hgap;
        if (this.glenixGuidance != null) {
            guidewidth = (int)((double)fontsize * 1.5);
            sumhgap += hgap;
        }
        int trlabelwidth = 0;
        if (this.taxReturnLabel != null) {
            trlabelwidth = fontsize * 2;
            sumhgap += hgap;
        }
        if ((twp = this.textWidth) > 100 || twp < 0) {
            twp = 40;
        }
        int text_width = (int)((double)twp * realwidth / 100.0);
        int labelwidth = (int)realwidth - text_width - guidewidth - trlabelwidth - sumhgap;
        double maxh = this.glenixLabel.prefHeight((double)labelwidth);
        if (this.glenixGuidance != null) {
            tmph2 = this.glenixGuidance.prefHeight((double)guidewidth);
            if (tmph2 > maxh) {
                maxh = tmph2;
            }
            if (twp == 100) {
                text_width -= guidewidth;
            }
        }
        if (this.taxReturnLabel != null) {
            tmph2 = this.taxReturnLabel.prefHeight((double)trlabelwidth);
            if (tmph2 > maxh) {
                maxh = tmph2;
            }
            if (twp == 100) {
                text_width -= trlabelwidth;
            }
        }
        if ((tmph = (control = this.getControl()).prefHeight((double)text_width)) > maxh) {
            maxh = tmph;
        }
        int sumx = 0;
        if (labelwidth > 0) {
            this.layoutInArea((Node)this.glenixLabel, 0.0, 0.0, labelwidth, maxh, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
            sumx = labelwidth + hgap;
        }
        if (this.glenixGuidance != null) {
            this.layoutInArea((Node)this.glenixGuidance, sumx, 0.0, guidewidth, maxh, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
            sumx += guidewidth + hgap;
        }
        if (this.taxReturnLabel != null) {
            this.layoutInArea((Node)this.taxReturnLabel, sumx, 0.0, trlabelwidth, maxh, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
            sumx += trlabelwidth + hgap;
        }
        control.setPrefWidth((double)text_width);
        control.setMinWidth((double)text_width);
        control.setMaxWidth((double)text_width);
        this.layoutInArea((Node)control, sumx, 0.0, text_width, maxh, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
        double height = control.getHeight();
        if (height <= 0.0) {
            height = maxh;
        }
        double ypos = (maxh - height) / 2.0;
        double symbolx = 0.0;
        Region indicatorSymbol = this.getIndicatorSymbol();
        if (indicatorSymbol != null) {
            double swidth = 12.0 * (double)(fontsize / 13);
            this.layoutInArea((Node)indicatorSymbol, sumx, ypos, swidth, height, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
            symbolx += swidth;
        }
        if ((indicatorDollar = this.getIndicatorDollar()) != null) {
            double swidth = indicatorDollar.prefWidth(height);
            if (swidth <= 0.0) {
                swidth = indicatorDollar.getWidth();
            }
            this.layoutInArea((Node)indicatorDollar, (double)sumx + symbolx, ypos, swidth, height, this.getBaselineOffset(), HPos.LEFT, VPos.CENTER);
        }
        double crossoutlabelwidth = -1.0;
        Region zeroCrossOutLabel = this.getZeroCrossOutLabel();
        if (zeroCrossOutLabel != null) {
            double swidth = zeroCrossOutLabel.prefWidth(height);
            if (swidth <= 0.0) {
                swidth = zeroCrossOutLabel.getWidth();
            }
            crossoutlabelwidth = swidth;
            this.layoutInArea((Node)zeroCrossOutLabel, (double)(sumx + text_width) - swidth, ypos, swidth, height, this.getBaselineOffset(), HPos.RIGHT, VPos.CENTER);
        }
        if ((zeroCrossOutCross = this.getZeroCrossOutCross()) != null) {
            double swidth = crossoutlabelwidth;
            if (swidth <= 0.0) {
                swidth = zeroCrossOutCross.prefWidth(height);
            }
            if (swidth <= 0.0) {
                swidth = zeroCrossOutCross.getWidth();
            }
            this.layoutInArea((Node)zeroCrossOutCross, (double)(sumx + text_width) - swidth, ypos, swidth, height, this.getBaselineOffset(), HPos.RIGHT, VPos.CENTER);
        }
        if (width != this.lastwidth) {
            Platform.runLater(() -> this.requestLayout());
        }
        this.lastwidth = width;
    }

    protected Region getIndicatorSymbol() {
        return null;
    }

    protected Region getIndicatorDollar() {
        return null;
    }

    public Region getZeroCrossOutLabel() {
        return null;
    }

    protected Region getZeroCrossOutCross() {
        return null;
    }

    protected double computePrefHeight(double forWidth) {
        Control control;
        double tmph;
        double tmph2;
        int twp;
        int fontsize;
        int hgap;
        double usewidth = forWidth;
        if (usewidth <= 0.0) {
            usewidth = this.getWidth();
        }
        if (usewidth <= 0.0) {
            usewidth = -1.0;
        }
        Insets ins = this.getInsets();
        double realwidth = -1.0;
        if (usewidth > 0.0) {
            realwidth = usewidth - ins.getLeft() - ins.getRight();
        }
        if ((hgap = this.spacing) < 0 || (double)hgap > realwidth / 2.0) {
            hgap = 5;
        }
        if ((fontsize = (int)this.glenixLabel.getFont().getSize()) <= 0) {
            fontsize = 13;
        } else if (fontsize < 4) {
            fontsize = 4;
        }
        int guidewidth = 0;
        int sumhgap = hgap;
        if (this.glenixGuidance != null) {
            guidewidth = (int)((double)fontsize * 1.5);
            sumhgap += hgap;
        }
        int trlabelwidth = 0;
        if (this.taxReturnLabel != null) {
            trlabelwidth = fontsize * 2;
            sumhgap += hgap;
        }
        if ((twp = this.textWidth) > 100 || twp < 0) {
            twp = 40;
        }
        int textwidth = (int)((double)twp * realwidth / 100.0);
        int labelwidth = (int)realwidth - textwidth - guidewidth - trlabelwidth - sumhgap;
        if (textwidth <= 0) {
            textwidth = -1;
        }
        if (labelwidth <= 0) {
            labelwidth = -1;
        }
        if (guidewidth <= 0) {
            guidewidth = -1;
        }
        if (trlabelwidth <= 0) {
            trlabelwidth = -1;
        }
        double maxh = this.glenixLabel.prefHeight((double)labelwidth);
        if (this.glenixGuidance != null) {
            tmph2 = this.glenixGuidance.prefHeight((double)guidewidth);
            if (tmph2 > maxh) {
                maxh = tmph2;
            }
            if (twp == 100) {
                textwidth -= guidewidth;
            }
        }
        if (this.taxReturnLabel != null) {
            tmph2 = this.taxReturnLabel.prefHeight((double)trlabelwidth);
            if (tmph2 > maxh) {
                maxh = tmph2;
            }
            if (twp == 100) {
                textwidth -= trlabelwidth;
            }
        }
        if ((tmph = (control = this.getControl()).prefHeight((double)textwidth)) > maxh) {
            maxh = tmph;
        }
        return maxh;
    }

    @Override
    public Double getPDFValueWidthRatio() {
        if (this.glenixLabel == null) {
            return 1.0;
        }
        Double result = 1.0 - this.glenixLabel.getWidth() / this.getControl().getWidth();
        if (result < 0.0) {
            return 0.0;
        }
        if (result > 1.0) {
            return 1.0;
        }
        return result;
    }

    @Override
    public void disableGlenixXBRL() {
        this.getControl().disableProperty().set(true);
    }

    @Override
    public void enableGlenixXBRL() {
        this.getControl().disableProperty().set(false);
    }
}

