/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GlenixLabelAbstractNotPane
implements GlenixController {
    @FXML
    protected Label glenixLabel;
    protected String glenixtag;
    protected Pane pane;
    private String glenixElementDescription;
    private String glenixElementName;
    private String glenixElementNamespace;
    private String glenixElementDefaultValue;

    @Override
    public Pane getPane() {
        return this.pane;
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 2;
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    public String getLabel() {
        return (String)this.labelTextProperty().get();
    }

    public void setLabel(String value) {
        this.labelTextProperty().set((Object)value);
    }

    public StringProperty labelTextProperty() {
        return this.glenixLabel.textProperty();
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
        this.setLabel(this.getGlenixElementDescription());
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    private void buildGlenixXBRLSub(Pane pane, Document resultDoc, Element resultElement) throws Exception {
        for (Node component : pane.getChildren()) {
            if (component instanceof GlenixController) {
                ((GlenixController)component).buildGlenixXBRL(resultDoc, resultElement);
                continue;
            }
            if (!(component instanceof Pane)) continue;
            this.buildGlenixXBRLSub((Pane)component, resultDoc, resultElement);
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + this.getGlenixElementName());
        el.setTextContent(this.getGlenixElementValue());
        resultElement.appendChild(el);
        this.buildGlenixXBRLSub(this.pane, resultDoc, el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
        }
    }

    private void clearGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            if (component instanceof GlenixController) {
                ((GlenixController)component).clearGlenixXBRL();
                continue;
            }
            if (!(component instanceof Pane)) continue;
            this.clearGlenixXBRLSub((Pane)component);
        }
    }

    @Override
    public void clearGlenixXBRL() {
        System.out.println("CLEAR LabelText " + this.getGlenixElementName());
        this.setGlenixElementValue(null);
        this.clearGlenixXBRLSub(this.pane);
    }
}

