/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GlenixLabelAbstractController
implements GlenixController {
    @FXML
    protected Label glenixLabel;
    @FXML
    protected Label taxReturnLabel;
    @FXML
    protected Hyperlink glenixGuidance;
    protected String glenixtag;
    @FXML
    protected Pane pane;
    protected boolean descriptionInited = false;
    protected String glenixElementDescription;
    protected String glenixElementName;
    protected String glenixElementNamespace;
    protected String glenixElementDefaultValue;
    protected String glenixElementImmutableValue;
    protected String glenixElementGuidance;
    protected boolean guidanceInited = false;
    protected boolean guidanceClicked = false;
    protected boolean trLabelInited = false;
    protected String glenixElementTRLabel;

    @Override
    public Pane getPane() {
        return this.pane;
    }

    @Override
    public GlenixPane getGlenixPane() {
        if (this.pane instanceof GlenixPane) {
            return (GlenixPane)this.pane;
        }
        return null;
    }

    public void initialize(URL url, ResourceBundle rb) {
        if (!this.descriptionInited && this.glenixElementDescription != null) {
            this.setLabel(this.glenixElementDescription);
        }
        if (!this.guidanceInited && this.glenixElementGuidance != null) {
            this.initializeGlenixElementGuidance();
        }
        if (!this.trLabelInited && this.glenixElementTRLabel != null) {
            this.initializeGlenixElementTRLabel();
        }
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 2;
    }

    public String getLabel() {
        return (String)this.labelTextProperty().get();
    }

    public void setLabel(String value) {
        this.labelTextProperty().set((Object)value);
    }

    public StringProperty labelTextProperty() {
        this.descriptionInited = true;
        return this.glenixLabel.textProperty();
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
        if (this.glenixLabel != null) {
            this.setLabel(this.getGlenixElementDescription());
        }
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.glenixElementImmutableValue;
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        this.setGlenixElementValue(glenixElementImmutableValue);
        this.glenixElementImmutableValue = glenixElementImmutableValue;
    }

    private void buildGlenixXBRLSub(Pane pane, Document resultDoc, Element resultElement) throws Exception {
        for (Node component : pane.getChildren()) {
            if (component instanceof GlenixController) {
                ((GlenixController)component).buildGlenixXBRL(resultDoc, resultElement);
                continue;
            }
            if (!(component instanceof Pane)) continue;
            this.buildGlenixXBRLSub((Pane)component, resultDoc, resultElement);
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String name = this.getGlenixElementName();
        if (name == null) {
            return;
        }
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + name);
        el.setTextContent(this.getGlenixElementValue());
        resultElement.appendChild(el);
        this.buildGlenixXBRLSub(this.getPane(), resultDoc, el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
        }
    }

    private void clearGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            if (component instanceof GlenixController) {
                ((GlenixController)component).clearGlenixXBRL();
                continue;
            }
            if (!(component instanceof Pane)) continue;
            this.clearGlenixXBRLSub((Pane)component);
        }
    }

    @Override
    public void clearGlenixXBRL() {
        this.setGlenixElementValue(null);
        this.clearGlenixXBRLSub(this.getPane());
    }

    private void setDisplayTRLabel(boolean show) {
        this.taxReturnLabel.setVisible(show);
        if (show || this.glenixGuidance.isVisible()) {
            this.glenixGuidance.setManaged(true);
            this.taxReturnLabel.setManaged(true);
            this.glenixLabel.getStyleClass().removeAll((Object[])new String[]{"glenixLabel"});
            this.glenixLabel.getStyleClass().add((Object)"glenixTRLabel");
        } else {
            this.glenixGuidance.setManaged(false);
            this.taxReturnLabel.setManaged(false);
            this.glenixLabel.getStyleClass().removeAll((Object[])new String[]{"glenixTRLabel"});
            this.glenixLabel.getStyleClass().add((Object)"glenixLabel");
        }
    }

    private void setDisplayGuidance(boolean show) {
        this.glenixGuidance.setVisible(show);
        if (show || this.taxReturnLabel.isVisible()) {
            this.glenixGuidance.setManaged(true);
            this.taxReturnLabel.setManaged(true);
            this.glenixLabel.getStyleClass().removeAll((Object[])new String[]{"glenixLabel"});
            this.glenixLabel.getStyleClass().add((Object)"glenixTRLabel");
        } else {
            this.glenixGuidance.setManaged(false);
            this.taxReturnLabel.setManaged(false);
            this.glenixLabel.getStyleClass().removeAll((Object[])new String[]{"glenixTRLabel"});
            this.glenixLabel.getStyleClass().add((Object)"glenixLabel");
        }
    }

    @Override
    public String getGlenixElementGuidance() {
        return this.glenixElementGuidance;
    }

    @Override
    public void setGlenixElementGuidance(String glenixElementGuidance) {
        this.glenixElementGuidance = glenixElementGuidance;
        if (this.glenixGuidance != null) {
            this.initializeGlenixElementGuidance();
        }
    }

    public void initializeGlenixElementGuidance() {
        this.guidanceInited = true;
        if (this.glenixElementGuidance == null) {
            this.glenixGuidance.setTooltip(null);
            this.setDisplayGuidance(false);
        } else {
            this.setDisplayGuidance(true);
            Tooltip tt = new Tooltip();
            tt.setText(this.glenixElementGuidance.replace("\\n", "\n"));
            tt.setAutoHide(false);
            tt.setMaxWidth(500.0);
            tt.setMaxHeight(1000.0);
            tt.wrapTextProperty().set(true);
            this.glenixGuidance.setTooltip(tt);
            this.glenixGuidance.setOnAction(event -> {
                Tooltip att = this.glenixGuidance.getTooltip();
                if (att != null) {
                    if (att.isShowing()) {
                        if (this.guidanceClicked) {
                            att.hide();
                            this.guidanceClicked = false;
                        } else {
                            Bounds boundsInScreen = this.glenixGuidance.localToScreen(this.glenixGuidance.getBoundsInLocal());
                            att.show((Node)this.glenixGuidance, boundsInScreen.getMaxX(), boundsInScreen.getMaxY() + 10.0);
                            this.guidanceClicked = true;
                        }
                    } else {
                        Bounds boundsInScreen = this.glenixGuidance.localToScreen(this.glenixGuidance.getBoundsInLocal());
                        att.show((Node)this.glenixGuidance, boundsInScreen.getMaxX(), boundsInScreen.getMaxY() + 10.0);
                        this.guidanceClicked = true;
                    }
                }
            });
        }
    }

    @Override
    public String getGlenixElementTRLabel() {
        return this.glenixElementTRLabel;
    }

    @Override
    public void setGlenixElementTRLabel(String glenixElementTRLabel) {
        this.glenixElementTRLabel = glenixElementTRLabel;
        if (this.taxReturnLabel != null) {
            this.initializeGlenixElementTRLabel();
        }
    }

    public void initializeGlenixElementTRLabel() {
        this.trLabelInited = true;
        if (this.glenixElementTRLabel == null) {
            this.setDisplayTRLabel(false);
        } else {
            this.setDisplayTRLabel(true);
            this.taxReturnLabel.setText(this.glenixElementTRLabel);
        }
    }

    public Double getFontSize() {
        if (this.glenixLabel == null) {
            return null;
        }
        return this.glenixLabel.getFont().getSize();
    }

    public Double getPDFValueWidthRatio() {
        if (this.glenixLabel == null) {
            return 1.0;
        }
        if (this.pane == null) {
            return 0.0;
        }
        Double result = 1.0 - this.glenixLabel.getWidth() / this.pane.getWidth();
        if (result < 0.0) {
            return 0.0;
        }
        if (result > 1.0) {
            return 1.0;
        }
        return result;
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        throw new Exception("Error, Glenix Label does not implement build pdf");
    }
}

