/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixLabelText;
import javafx.beans.value.ObservableValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelABN
extends GlenixLabelText {
    @Override
    protected void validateEdit(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (newValue != null && !newValue.matches("^[0-9]{0,11}$")) {
            this.setText(oldValue);
        } else if (this.lastValidatedValue == null && newValue != null || this.lastValidatedValue != null && !this.lastValidatedValue.equals(newValue)) {
            this.lastValidatedValue = newValue;
            if (this.changeListener != null) {
                this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
            }
        }
    }

    @Override
    protected void validateFinal(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue == null || !newValue.booleanValue()) {
            String textValue = this.getText();
            if (textValue != null && !textValue.isEmpty()) {
                if (!textValue.matches("^[0-9]{11}$")) {
                    this.setText("");
                    this.setErrorDisplay(null);
                } else if (!this.checkABN(textValue)) {
                    this.setErrorDisplay("error");
                } else {
                    this.setErrorDisplay(null);
                }
            } else {
                this.setErrorDisplay(null);
            }
        }
    }

    protected void validateFriendly(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue == null || !newValue.booleanValue()) {
            String textValue = this.getText();
            if (textValue != null && !textValue.isEmpty()) {
                if (!textValue.matches("^[0-9]{11}$") || !this.checkABN(textValue)) {
                    this.setErrorDisplay("error");
                } else {
                    this.setErrorDisplay(null);
                }
            } else {
                this.setErrorDisplay(null);
            }
        }
    }

    private boolean checkABN(String value) {
        if (value.length() == 11) {
            int[] weights = new int[]{10, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19};
            int total = 0;
            char c = value.charAt(0);
            int ci = Character.getNumericValue(c);
            if (ci <= 0) {
                return false;
            }
            total += weights[0] * (ci - 1);
            for (int i = 1; i < 11; ++i) {
                c = value.charAt(i);
                ci = Character.getNumericValue(c);
                if (ci < 0) {
                    return false;
                }
                total += weights[i] * ci;
            }
            if (total % 89 == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        super.loadGlenixXBRL(loadDoc, loadElement);
        this.validateFriendly(null, null, null);
    }
}

