/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixFlowPane;
import javafx.application.Platform;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class GlenixHeaderDetailFlowPane
extends GlenixFlowPane {
    private double lastwidth = -1.0;

    public GlenixHeaderDetailFlowPane() {
        this(10, 10);
    }

    public GlenixHeaderDetailFlowPane(int v, int h) {
        super(v, h);
    }

    @Override
    protected void layoutChildren() {
        double width = this.getWidth();
        Insets ins = this.getInsets();
        double realwidth = width - ins.getLeft() - ins.getRight();
        int columns = this.calcColumns(realwidth);
        int colwidth = (int)realwidth;
        if (columns > 1) {
            colwidth = (int)((realwidth - (double)((columns - 1) * this.hgap)) * 3.0) / (columns * 4);
        }
        if (columns > 2) {
            columns = 2;
        }
        int currcol = 0;
        double curx = ins.getLeft();
        double maxh = 0.0;
        double totalh = 0.0;
        double detailwidth = colwidth;
        if (realwidth > (double)colwidth && columns > 1) {
            detailwidth = realwidth - (double)colwidth - (double)this.hgap;
        }
        for (Node n : this.getChildren()) {
            if (!n.isManaged()) continue;
            double height = -1.0;
            if (currcol == 0) {
                if (n instanceof Region) {
                    ((Region)n).setPrefWidth((double)colwidth);
                    ((Region)n).setMaxWidth((double)colwidth);
                }
                maxh = height = n.prefHeight((double)colwidth);
                this.layoutInArea(n, curx, totalh, colwidth, height, this.getBaselineOffset(), HPos.LEFT, VPos.TOP);
            } else {
                if (n instanceof Region) {
                    ((Region)n).setPrefWidth(detailwidth);
                    ((Region)n).setMaxWidth(detailwidth);
                }
                height = n.prefHeight(detailwidth);
                maxh = Math.max(maxh, height);
                this.layoutInArea(n, curx, totalh, detailwidth, height, this.getBaselineOffset(), HPos.LEFT, VPos.TOP);
            }
            curx += (double)(colwidth + this.hgap);
            if (++currcol != columns) continue;
            totalh += maxh;
            currcol = 0;
            maxh = 0.0;
            totalh += (double)this.vgap;
            curx = ins.getLeft();
        }
        if (width != this.lastwidth) {
            Platform.runLater(() -> this.requestLayout());
        }
        this.lastwidth = width;
    }

    @Override
    protected double computePrefHeight(double forWidth) {
        double usewidth = forWidth;
        if (usewidth <= 0.0) {
            usewidth = this.wrapWidth;
        }
        if (usewidth <= 0.0) {
            usewidth = this.getWidth();
        }
        if (usewidth <= 0.0) {
            usewidth = -1.0;
        }
        Insets ins = this.getInsets();
        double realwidth = usewidth - ins.getLeft() - ins.getRight();
        int columns = this.calcColumns(realwidth);
        int colwidth = (int)realwidth;
        if (columns > 1) {
            colwidth = (int)((realwidth - (double)((columns - 1) * this.hgap)) * 3.0) / (columns * 4);
        }
        if (columns > 2) {
            columns = 2;
        }
        int currcol = 0;
        double maxh = 0.0;
        double totalh = 0.0;
        double detailwidth = colwidth;
        if (realwidth > (double)colwidth && columns > 1) {
            detailwidth = realwidth - (double)colwidth - (double)this.hgap;
        }
        for (Node n : this.getChildren()) {
            if (!n.isManaged()) continue;
            maxh = currcol == 0 ? n.prefHeight((double)colwidth) : Math.max(maxh, n.prefHeight(detailwidth));
            if (++currcol != columns) continue;
            totalh += maxh;
            currcol = 0;
            maxh = 0.0;
            totalh += (double)this.vgap;
        }
        totalh += maxh;
        if (maxh > 0.0) {
            totalh += (double)this.vgap;
        }
        return totalh;
    }
}

