/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class GlenixFlowPane
extends Pane {
    protected int vgap = 10;
    protected int hgap = 10;
    protected double wrapWidth = -1.0;

    public GlenixFlowPane() {
        this(10, 10);
    }

    public GlenixFlowPane(int v, int h) {
        this.vgap = v;
        this.hgap = h;
    }

    protected int calcColumns(double realwidth) {
        int preferred_column_width;
        int columns;
        Double font_size = 13.0;
        for (Node n : this.getChildren()) {
            if (!n.isManaged() || !(n instanceof TitledPane)) continue;
            font_size = ((TitledPane)n).getFont().getSize();
            break;
        }
        if ((columns = (int)Math.floor(realwidth / (double)(preferred_column_width = 400 * (font_size.intValue() - (13 - font_size.intValue())) / 13))) < 1) {
            columns = 1;
        }
        return columns;
    }

    protected void layoutChildren() {
        double width = this.getWidth();
        Insets ins = this.getInsets();
        double realwidth = width - ins.getLeft() - ins.getRight();
        int columns = this.calcColumns(realwidth);
        int colwidth = (int)(realwidth - (double)((columns - 1) * this.hgap)) / columns;
        int currcol = 0;
        double curx = ins.getLeft();
        double maxh = 0.0;
        double totalh = 0.0;
        for (Node n : this.getChildren()) {
            if (!n.isManaged()) continue;
            if (n instanceof Region) {
                ((Region)n).setPrefWidth((double)colwidth);
                ((Region)n).setMaxWidth((double)colwidth);
            }
            double height = n.prefHeight((double)colwidth);
            maxh = currcol == 0 ? height : Math.max(maxh, height);
            this.layoutInArea(n, curx, totalh, colwidth, height, this.getBaselineOffset(), HPos.LEFT, VPos.TOP);
            curx += (double)(colwidth + this.hgap);
            if (++currcol != columns) continue;
            totalh += maxh;
            currcol = 0;
            maxh = 0.0;
            totalh += (double)this.vgap;
            curx = ins.getLeft();
        }
    }

    public void setWrapWidth(double w) {
        this.wrapWidth = w;
    }

    protected double computePrefHeight(double forWidth) {
        double usewidth = forWidth;
        if (usewidth <= 0.0) {
            usewidth = this.wrapWidth;
        }
        if (usewidth <= 0.0) {
            usewidth = this.getWidth();
        }
        if (usewidth <= 0.0) {
            usewidth = -1.0;
        }
        Insets ins = this.getInsets();
        double realwidth = -1.0;
        int columns = 1;
        int colwidth = -1;
        if (usewidth > 0.0) {
            realwidth = usewidth - ins.getLeft() - ins.getRight();
            columns = this.calcColumns(realwidth);
            colwidth = (int)(realwidth - (double)(columns * this.hgap)) / columns;
        }
        int currcol = 0;
        double maxh = 0.0;
        double totalh = 0.0;
        for (Node n : this.getChildren()) {
            if (!n.isManaged()) continue;
            maxh = currcol == 0 ? n.prefHeight((double)colwidth) : Math.max(maxh, n.prefHeight((double)colwidth));
            if (++currcol != columns) continue;
            totalh += maxh;
            currcol = 0;
            maxh = 0.0;
            totalh += (double)this.vgap;
        }
        totalh += maxh;
        if (maxh > 0.0) {
            totalh += (double)this.vgap;
        }
        return totalh;
    }
}

