/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.widget;

import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelSignatoryIdentifier;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlenixBranchController
implements GlenixController {
    @FXML
    protected Pane pane;
    private String glenixElementDescription;
    private String glenixElementGuidance;
    private String glenixElementTRLabel;
    private String glenixElementName;
    private String glenixElementNamespace;
    private String glenixElementDefaultValue;
    private String glenixElementImmutableValue;
    HashMap gcs = null;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public Pane getPane() {
        return this.pane;
    }

    @Override
    public GlenixPane getGlenixPane() {
        if (this.pane instanceof GlenixPane) {
            return (GlenixPane)this.pane;
        }
        return null;
    }

    @Override
    public int getMaxColumns(Number newStageWidth) {
        return 4;
    }

    protected void buildGlenixXBRLSubComponent(Node component, Document resultDoc, Element resultElement) throws Exception {
        if (component instanceof GlenixController) {
            ((GlenixController)component).buildGlenixXBRL(resultDoc, resultElement);
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            gc.buildGlenixXBRL(resultDoc, resultElement);
        } else if (component instanceof ScrollPane) {
            this.buildGlenixXBRLSubScrollPane((ScrollPane)component, resultDoc, resultElement);
        } else if (component instanceof TitledPane) {
            this.buildGlenixXBRLSubTitledPane((TitledPane)component, resultDoc, resultElement);
        } else if (component instanceof Pane) {
            this.buildGlenixXBRLSub((Pane)component, resultDoc, resultElement);
        }
    }

    protected void buildGlenixXBRLSubScrollPane(ScrollPane scrollPane, Document resultDoc, Element resultElement) throws Exception {
        Node component = scrollPane.getContent();
        this.buildGlenixXBRLSubComponent(component, resultDoc, resultElement);
    }

    protected void buildGlenixXBRLSubTitledPane(TitledPane titledPane, Document resultDoc, Element resultElement) throws Exception {
        Node component = titledPane.getContent();
        this.buildGlenixXBRLSubComponent(component, resultDoc, resultElement);
    }

    protected void buildGlenixXBRLSub(Pane pane, Document resultDoc, Element resultElement) throws Exception {
        if (pane != null) {
            for (Node component : pane.getChildren()) {
                this.buildGlenixXBRLSubComponent(component, resultDoc, resultElement);
            }
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String namespace = this.getGlenixElementNamespace();
        String name = this.getGlenixElementName();
        if (name != null && namespace != null) {
            String nsp = GlenixController.getNSP(namespace);
            Element el = resultDoc.createElementNS(namespace, nsp + ":" + name);
            if (resultElement == null) {
                resultDoc.appendChild(el);
            } else {
                resultElement.appendChild(el);
            }
            this.buildGlenixXBRLSub(this.getPane(), resultDoc, el);
        } else {
            this.buildGlenixXBRLSub(this.getPane(), resultDoc, resultElement);
        }
    }

    @Override
    public String getGlenixElementDescription() {
        return this.glenixElementDescription;
    }

    @Override
    public void setGlenixElementDescription(String glenixElementDescription) {
        this.glenixElementDescription = glenixElementDescription;
    }

    @Override
    public String getGlenixElementGuidance() {
        return this.glenixElementGuidance;
    }

    @Override
    public void setGlenixElementGuidance(String glenixElementGuidance) {
        this.glenixElementGuidance = glenixElementGuidance;
    }

    @Override
    public String getGlenixElementTRLabel() {
        return this.glenixElementTRLabel;
    }

    @Override
    public void setGlenixElementTRLabel(String glenixElementTRLabel) {
        this.glenixElementTRLabel = glenixElementTRLabel;
    }

    @Override
    public String getGlenixElementValue() {
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
    }

    @Override
    public String getGlenixElementName() {
        return this.glenixElementName;
    }

    @Override
    public void setGlenixElementName(String glenixElementName) {
        this.glenixElementName = glenixElementName;
    }

    @Override
    public String getGlenixElementNamespace() {
        return this.glenixElementNamespace;
    }

    @Override
    public void setGlenixElementNamespace(String glenixElementNamespace) {
        this.glenixElementNamespace = glenixElementNamespace;
    }

    @Override
    public String getGlenixElementDefaultValue() {
        return this.glenixElementDefaultValue;
    }

    @Override
    public void setGlenixElementDefaultValue(String glenixElementDefaultValue) {
        this.glenixElementDefaultValue = glenixElementDefaultValue;
    }

    @Override
    public String getGlenixElementImmutableValue() {
        return this.glenixElementImmutableValue;
    }

    @Override
    public void setGlenixElementImmutableValue(String glenixElementImmutableValue) {
        this.glenixElementImmutableValue = glenixElementImmutableValue;
    }

    protected void invalidateComponentsCache() {
        this.gcs = null;
    }

    protected void buildGCHashComponent(Node component) {
        if (component instanceof GlenixController) {
            this.gcs.put(((GlenixController)component).getGlenixElementName() + "-" + ((GlenixController)component).getGlenixElementNamespace(), component);
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                this.gcs.put(gc.getGlenixElementName() + "-" + gc.getGlenixElementNamespace(), gc);
            }
        } else if (component instanceof ScrollPane) {
            this.buildGCHashScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.buildGCHashTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.buildGCHash((Pane)component);
        }
    }

    protected void buildGCHashScrollPane(ScrollPane scrollPane) {
        Node child = scrollPane.getContent();
        if (child != null) {
            this.buildGCHashComponent(child);
        }
    }

    protected void buildGCHashTitledPane(TitledPane titledPane) {
        Node child = titledPane.getContent();
        if (child != null) {
            this.buildGCHashComponent(child);
        }
    }

    protected void buildGCHash(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.buildGCHashComponent(component);
        }
    }

    public GlenixController getGlenixControllerByNameNS(String namespace, String name) {
        if (this.gcs == null) {
            this.gcs = new HashMap();
            this.buildGCHash(this.getPane());
        }
        return (GlenixController)this.gcs.get(name + "-" + namespace);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                GlenixController gc;
                org.w3c.dom.Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (gc = this.getGlenixControllerByNameNS((el = (Element)node).getNamespaceURI(), el.getLocalName())) == null) continue;
                gc.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    protected void clearGlenixXBRLSubComponent(Node component) {
        if (component instanceof GlenixController) {
            ((GlenixController)component).clearGlenixXBRL();
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                gc.clearGlenixXBRL();
            }
        } else if (component instanceof ScrollPane) {
            this.clearGlenixXBRLSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.clearGlenixXBRLSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.clearGlenixXBRLSub((Pane)component);
        }
    }

    private void clearGlenixXBRLSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.clearGlenixXBRLSubComponent(component);
    }

    private void clearGlenixXBRLSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        this.clearGlenixXBRLSubComponent(component);
    }

    private void clearGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.clearGlenixXBRLSubComponent(component);
        }
    }

    @Override
    public void clearGlenixXBRL() {
        Pane apane = this.getPane();
        for (Node component : apane.getChildren()) {
            this.clearGlenixXBRLSubComponent(component);
        }
    }

    protected void disableGlenixXBRLSubComponent(Node component) {
        if (component instanceof GlenixController) {
            ((GlenixController)component).disableGlenixXBRL();
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                gc.disableGlenixXBRL();
            }
        } else if (component instanceof ScrollPane) {
            this.disableGlenixXBRLSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.disableGlenixXBRLSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.disableGlenixXBRLSub((Pane)component);
        }
    }

    private void disableGlenixXBRLSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.disableGlenixXBRLSubComponent(component);
    }

    private void disableGlenixXBRLSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        this.disableGlenixXBRLSubComponent(component);
    }

    private void disableGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.disableGlenixXBRLSubComponent(component);
        }
    }

    @Override
    public void disableGlenixXBRL() {
        Pane apane = this.getPane();
        for (Node component : apane.getChildren()) {
            this.disableGlenixXBRLSubComponent(component);
        }
    }

    protected void enableGlenixXBRLSubComponent(Node component) {
        if (component instanceof GlenixController) {
            ((GlenixController)component).enableGlenixXBRL();
        } else if (component instanceof GlenixPane) {
            GlenixController gc = ((GlenixPane)component).getGlenixController();
            if (gc != null) {
                gc.enableGlenixXBRL();
            }
        } else if (component instanceof ScrollPane) {
            this.enableGlenixXBRLSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.enableGlenixXBRLSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.enableGlenixXBRLSub((Pane)component);
        }
    }

    private void enableGlenixXBRLSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.enableGlenixXBRLSubComponent(component);
    }

    private void enableGlenixXBRLSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        this.enableGlenixXBRLSubComponent(component);
    }

    private void enableGlenixXBRLSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.enableGlenixXBRLSubComponent(component);
        }
    }

    @Override
    public void enableGlenixXBRL() {
        Pane apane = this.getPane();
        for (Node component : apane.getChildren()) {
            this.enableGlenixXBRLSubComponent(component);
        }
    }

    private boolean sectionHasValue(Node node) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (node instanceof Label) {
                            return false;
                        }
                        if (node instanceof GlenixPane) {
                            GlenixPane gp = (GlenixPane)node;
                            return gp.hasPDFValue();
                        }
                        if (!(node instanceof FlowPane)) break block6;
                        FlowPane fp = (FlowPane)node;
                        for (Node childNode : fp.getChildren()) {
                            if (!this.sectionHasValue(childNode)) continue;
                            return true;
                        }
                        break block7;
                    }
                    if (!(node instanceof TitledPane)) break block8;
                    Node childNode = ((TitledPane)node).getContent();
                    if (this.sectionHasValue(childNode)) {
                        return true;
                    }
                    break block7;
                }
                if (!(node instanceof ScrollPane)) break block9;
                Node childNode = ((ScrollPane)node).getContent();
                if (this.sectionHasValue(childNode)) {
                    return true;
                }
                break block7;
            }
            if (!(node instanceof Pane)) break block7;
            Pane p = (Pane)node;
            for (Node childNode : p.getChildren()) {
                if (!this.sectionHasValue(childNode)) continue;
                return true;
            }
        }
        return false;
    }

    protected void expandTitlePanesSubComponent(Node component) {
        if (component instanceof ScrollPane) {
            this.expandTitlePanesSubScrollPane((ScrollPane)component);
        } else if (component instanceof TitledPane) {
            this.expandTitlePanesSubTitledPane((TitledPane)component);
        } else if (component instanceof Pane) {
            this.expandTitlePanesSub((Pane)component);
        }
    }

    private void expandTitlePanesSubScrollPane(ScrollPane scrollPane) {
        Node component = scrollPane.getContent();
        this.expandTitlePanesSubComponent(component);
    }

    private void expandTitlePanesSubTitledPane(TitledPane titledPane) {
        Node component = titledPane.getContent();
        if (this.sectionHasValue(component)) {
            titledPane.setExpanded(true);
        }
        this.expandTitlePanesSubComponent(component);
    }

    private void expandTitlePanesSub(Pane pane) {
        for (Node component : pane.getChildren()) {
            this.expandTitlePanesSubComponent(component);
        }
    }

    public void expandTitlePanes() {
        Pane apane = this.getPane();
        for (Node component : apane.getChildren()) {
            this.expandTitlePanesSubComponent(component);
        }
    }

    protected boolean buildPDFSectionHasValue(Node node) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (!node.isVisible()) {
                            return false;
                        }
                        if (node instanceof GlenixPane) {
                            GlenixPane gp = (GlenixPane)node;
                            return gp.hasPDFValue();
                        }
                        if (node instanceof Label) {
                            return false;
                        }
                        if (!(node instanceof FlowPane)) break block7;
                        FlowPane fp = (FlowPane)node;
                        for (Node childNode : fp.getChildren()) {
                            if (!this.buildPDFSectionHasValue(childNode)) continue;
                            return true;
                        }
                        break block8;
                    }
                    if (!(node instanceof TitledPane)) break block9;
                    Node childNode = ((TitledPane)node).getContent();
                    if (this.buildPDFSectionHasValue(childNode)) {
                        return true;
                    }
                    break block8;
                }
                if (!(node instanceof ScrollPane)) break block10;
                Node childNode = ((ScrollPane)node).getContent();
                if (this.buildPDFSectionHasValue(childNode)) {
                    return true;
                }
                break block8;
            }
            if (!(node instanceof Pane)) break block8;
            Pane p = (Pane)node;
            for (Node childNode : p.getChildren()) {
                if (!this.buildPDFSectionHasValue(childNode)) continue;
                return true;
            }
        }
        return false;
    }

    protected Double convertFontSize(Double screenFontSize) {
        if (screenFontSize == null || screenFontSize < 4.5) {
            return 4.0;
        }
        if (screenFontSize < 5.0) {
            return screenFontSize - 1.5;
        }
        if (screenFontSize < 6.0) {
            return screenFontSize - 2.0;
        }
        if (screenFontSize < 7.0) {
            return screenFontSize - 2.5;
        }
        if (screenFontSize < 8.0) {
            return screenFontSize - 3.0;
        }
        if (screenFontSize < 11.0) {
            return screenFontSize - 3.5;
        }
        if (screenFontSize < 14.0) {
            return screenFontSize - 4.0;
        }
        if (screenFontSize < 16.0) {
            return screenFontSize - 4.5;
        }
        if (screenFontSize < 17.0) {
            return screenFontSize - 5.0;
        }
        if (screenFontSize < 18.0) {
            return screenFontSize - 5.5;
        }
        if (screenFontSize < 23.0) {
            return screenFontSize - 6.0;
        }
        if (screenFontSize < 30.0) {
            return screenFontSize - 6.5;
        }
        return screenFontSize - 7.0;
    }

    protected void setPDFColumnWidths(GlenixPDFWrapper gpw, Double valueWidthRatio) throws Exception {
        if (valueWidthRatio == null || valueWidthRatio < 0.55) {
            gpw.setTPColumnLeftPosAndWidthMM(20.0, 48.0, 68.0, 10.0, 78.0, 30.0);
        } else {
            gpw.setTPColumnLeftPosAndWidthMM(20.0, 30.0, 45.0, 10.0, 50.0, 58.0);
        }
    }

    protected boolean buildPDF(GlenixPDFWrapper gpw, boolean inTP, Node node, boolean includeBlanks) throws Exception {
        boolean result;
        block33: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block32: {
                                        if (!node.isVisible()) {
                                            return false;
                                        }
                                        result = false;
                                        if (!(node instanceof Label)) break block32;
                                        Double fontSize = this.convertFontSize(((Label)node).getFont().getSize());
                                        String lval = ((Label)node).getText();
                                        if (includeBlanks || lval != null && !lval.isEmpty()) {
                                            if (inTP) {
                                                gpw.prepareTPStringFullWidthText(lval, true, fontSize);
                                                gpw.ruleOffTP();
                                            } else {
                                                gpw.prepareString(1, lval, true, fontSize);
                                                gpw.drawStrings();
                                            }
                                            result = true;
                                        }
                                        break block33;
                                    }
                                    if (!(node instanceof GlenixLabelSignatoryIdentifier)) break block34;
                                    if (inTP) {
                                        gpw.ruleOffTP(10.0);
                                        gpw.prepareTPStringFullWidthText("Signed: _______________________", true);
                                    } else {
                                        gpw.ruleOff(10.0);
                                        gpw.prepareString(1, "Signed: _______________________", true);
                                    }
                                    result = true;
                                    break block33;
                                }
                                if (!(node instanceof GlenixPane)) break block35;
                                GlenixPane gp = (GlenixPane)node;
                                if (gp.doPDFOutput(includeBlanks)) {
                                    List<Node> childNodes;
                                    Double fontSize = this.convertFontSize(gp.getPDFFontSize());
                                    String label = gp.getPDFLabel();
                                    String value = gp.getPDFValue();
                                    if (node instanceof TitledPane) {
                                        label = ((TitledPane)node).getText();
                                    }
                                    if (label == null && value != null) {
                                        String align = gp.getPDFValueAlignment();
                                        if (align == null) {
                                            gpw.prepareTPStringFullWidthText(value, true, fontSize);
                                        } else {
                                            gpw.prepareTPStringFullWidthText(value, true, fontSize, align);
                                        }
                                        result = true;
                                    } else if (value == null && label != null) {
                                        gpw.prepareTPStringFullWidthText(label, true, fontSize);
                                        result = true;
                                    } else if (label != null && value != null) {
                                        Double ratio = gp.getPDFValueWidthRatio();
                                        if (ratio == 1.0) {
                                            gpw.prepareTPStringFullWidthText(label, true, fontSize);
                                            String align = gp.getPDFValueAlignment();
                                            if (align == null) {
                                                gpw.prepareTPStringFullWidthText(value, true, fontSize);
                                            } else {
                                                gpw.prepareTPStringFullWidthText(value, true, fontSize, align);
                                            }
                                        } else {
                                            String align;
                                            System.out.println("Label " + label);
                                            this.setPDFColumnWidths(gpw, gp.getPDFValueWidthRatio());
                                            gpw.prepareTPStringLabel(label, true, fontSize);
                                            String letter = gp.getPDFLabelLetter();
                                            if (letter != null) {
                                                gpw.prepareTPStringLetter(letter, true, fontSize, "centre");
                                            }
                                            if ((align = gp.getPDFValueAlignment()) == null) {
                                                gpw.prepareTPStringValue(value, true, fontSize);
                                            } else {
                                                gpw.prepareTPStringValue(value, true, fontSize, align);
                                            }
                                        }
                                        result = true;
                                    }
                                    if (result) {
                                        gpw.ruleOffTP();
                                    }
                                    if ((childNodes = gp.getPDFChildNodes()) != null && childNodes.size() > 0) {
                                        for (Node childNode : childNodes) {
                                            if (!this.buildPDF(gpw, inTP, childNode, includeBlanks)) continue;
                                            result = true;
                                        }
                                    }
                                }
                                if (result) {
                                    gpw.ruleOffTP();
                                }
                                break block33;
                            }
                            if (!(node instanceof FlowPane)) break block36;
                            if (!includeBlanks && !this.buildPDFSectionHasValue(node)) break block33;
                            FlowPane fp = (FlowPane)node;
                            boolean didDraw = false;
                            for (Node childNode : fp.getChildren()) {
                                if (!this.buildPDF(gpw, true, childNode, includeBlanks)) continue;
                                result = true;
                                didDraw = gpw.nextTP(true, 10.0);
                            }
                            if (!result || didDraw) break block33;
                            gpw.drawStrings(10.0);
                            gpw.drawHorizontalRule(0);
                            break block33;
                        }
                        if (!(node instanceof GlenixFlowPane)) break block37;
                        if (!includeBlanks && !this.buildPDFSectionHasValue(node)) break block33;
                        GlenixFlowPane fp = (GlenixFlowPane)node;
                        boolean didDraw = false;
                        for (Node childNode : fp.getChildren()) {
                            if (!this.buildPDF(gpw, true, childNode, includeBlanks)) continue;
                            result = true;
                            didDraw = gpw.nextTP(true, 10.0);
                        }
                        if (!result || didDraw) break block33;
                        gpw.drawStrings(10.0);
                        gpw.drawHorizontalRule(0);
                        break block33;
                    }
                    if (!(node instanceof ScrollPane)) break block38;
                    if (this.buildPDF(gpw, inTP, ((ScrollPane)node).getContent(), includeBlanks)) {
                        result = true;
                    }
                    break block33;
                }
                if (!(node instanceof TitledPane)) break block39;
                if (!includeBlanks && !this.buildPDFSectionHasValue(((TitledPane)node).getContent())) break block33;
                Double fontSize = this.convertFontSize(((TitledPane)node).getFont().getSize());
                String lval = ((TitledPane)node).getText();
                if (lval != null && !lval.isEmpty()) {
                    gpw.prepareTPStringHeading(lval, true, fontSize);
                    gpw.ruleOffTP();
                    result = true;
                }
                if (!this.buildPDF(gpw, inTP, ((TitledPane)node).getContent(), includeBlanks)) break block33;
                result = true;
                break block33;
            }
            if (node instanceof Pane && (includeBlanks || this.buildPDFSectionHasValue(node))) {
                Pane p = (Pane)node;
                for (Node childNode : p.getChildren()) {
                    if (!this.buildPDF(gpw, inTP, childNode, includeBlanks)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        Pane node = this.getPane();
        if (node == null) {
            return null;
        }
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(12);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 88.0);
        gpw.setColumnLeftPosAndWidthMM(3, 20.0, 88.0);
        gpw.setColumnLeftPosAndWidthMM(4, 20.0, 48.0);
        gpw.setColumnLeftPosAndWidthMM(5, 68.0, 10.0);
        gpw.setColumnLeftPosAndWidthMM(6, 78.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(7, 112.0, 88.0);
        gpw.setColumnLeftPosAndWidthMM(8, 112.0, 88.0);
        gpw.setColumnLeftPosAndWidthMM(9, 112.0, 48.0);
        gpw.setColumnLeftPosAndWidthMM(10, 160.0, 10.0);
        gpw.setColumnLeftPosAndWidthMM(11, 170.0, 30.0);
        gpw.setColumnType(5, "TRLABEL");
        gpw.setColumnType(10, "TRLABEL");
        gpw.setTPHeadingColumns(new int[]{2, 7});
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        gpw.setColumnFont(10, gpw.muliLightFont);
        gpw.setColumnFont(11, gpw.muliLightFont);
        this.buildPDF(gpw, false, (Node)node, includeBlanks);
        gpw.drawStrings();
        return gpw;
    }
}

