/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.Provision;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleStringProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionLine
extends GlenixAbstractBranchElement {
    private DateTimeFormatter outputDateFormatter;
    private NumberFormat formatTwoDp = new DecimalFormat("#,##0.00");
    private NumberFormat formatTwoDpInput = new DecimalFormat("0.00");
    private NumberFormat formatSixDpInput = new DecimalFormat("0.000000");
    private DateTimeFormatter inputDateTimeFormatter;

    public TransactionLine() {
        this.name = "transactionLine";
        this.namespace = "http://www.glenix.com.au/";
        this.childrenAndMeta.put("lineNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "lineNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("lineComment", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "lineComment", null, null, null, 1, true));
        this.childrenAndMeta.put("account", new GlenixElementChildList(Account.class, "http://www.glenix.com.au/", "account", null, null, null, 1, false));
        this.childrenAndMeta.put("amount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "amount", null, null, null, 1, true));
        this.childrenAndMeta.put("quantity", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "quantity", null, null, null, 1, true));
        this.childrenAndMeta.put("startDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "startDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("endDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "endDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("breakTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "breakTime", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionLineRate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionLineRate", null, null, null, 1, true));
        this.childrenAndMeta.put("provision", new GlenixElementChildList(Provision.class, "http://www.glenix.com.au/", "provision", null, null, null, 1, false));
        this.childrenAndMeta.put("provisionAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionQuantity", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionQuantity", null, null, null, 1, true));
        this.childrenAndMeta.put("reconciliationNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "reconciliationNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("reconciliationMaxDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "reconciliationMaxDate", null, null, null, 1, true));
        this.childrenAndMeta.put("reconciliationAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "reconciliationAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionReconciliationNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionReconciliationNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionReconciliationMaxDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionReconciliationMaxDate", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionReconciliationAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionReconciliationAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("fullAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "fullAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("apportionmentMethod", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "apportionmentMethod", null, null, null, 1, true));
        this.childrenAndMeta.put("activityStatement", new GlenixElementChildList(ActivityStatement.class, "http://www.glenix.com.au/", "activityStatement", null, null, null, 1, false));
        this.childrenAndMeta.put("homeOffice", new GlenixElementChildList(HomeOffice.class, "http://www.glenix.com.au/", "homeOffice", null, null, null, 1, false));
        this.childrenAndMeta.put("fuelTaxCredit", new GlenixElementChildList(FuelTaxCredit.class, "http://www.glenix.com.au/", "fuelTaxCredit", null, null, null, 1, false));
        this.childrenAndMeta.put("importData", new GlenixElementChildList(ImportData.class, "http://www.glenix.com.au/", "importData", null, null, null, 1, false));
        this.childrenAndMeta.put("invoiceComment", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "invoiceComment", null, null, null, 1, true));
        this.outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
        this.inputDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    public Provision getProvision() {
        return (Provision)this.getChild("provision");
    }

    public String getProvisionIdentifier() {
        Provision p = (Provision)this.getChild("provision");
        if (p == null) {
            return null;
        }
        return p.getProvisionIdentifier();
    }

    public Provision getOrAddProvision() throws Exception {
        Provision result = (Provision)this.getChild("provision");
        if (result == null) {
            result = (Provision)((GlenixElementChildList)this.childrenAndMeta.get("provision")).addChild();
        }
        return result;
    }

    public void removeProvision() throws Exception {
        ((GlenixElementChildList)this.childrenAndMeta.get("provision")).clearChildren();
    }

    public void setProvisionIdentifier(String provisionIdentifier) throws Exception {
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            Provision a = this.getProvision();
            if (a != null) {
                a.setProvisionIdentifier(null);
            }
            return;
        }
        Provision a = this.getOrAddProvision();
        a.setProvisionIdentifier(provisionIdentifier);
    }

    public void setProvision(Provision provision) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("provision");
        if (glenixElementChildList.getChildCount() > 0) {
            glenixElementChildList.clearChildren();
        }
        glenixElementChildList.addChild(provision);
    }

    public Provision addProvision() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("provision");
        if (glenixElementChildList.getChildCount() > 0) {
            throw new Exception("Error, cannot add a provision, transaction line already has a provision.");
        }
        return (Provision)glenixElementChildList.addChild();
    }

    public Account getAccount() {
        return (Account)this.getChild("account");
    }

    public String getAccountIdentifier() {
        Account a = (Account)this.getChild("account");
        if (a == null) {
            return null;
        }
        return a.getAccountIdentifier();
    }

    public Account getOrAddAccount() throws Exception {
        Account result = (Account)this.getChild("account");
        if (result == null) {
            result = (Account)((GlenixElementChildList)this.childrenAndMeta.get("account")).addChild();
        }
        return result;
    }

    public Account addAccount() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("account");
        if (glenixElementChildList.getChildCount() > 0) {
            throw new Exception("Error, cannot add a account, transaction line already has a account.");
        }
        return (Account)glenixElementChildList.addChild();
    }

    public void removeAccount() throws Exception {
        ((GlenixElementChildList)this.childrenAndMeta.get("account")).clearChildren();
    }

    public void setAccount(Account account) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("account");
        if (glenixElementChildList.getChildCount() > 0) {
            glenixElementChildList.clearChildren();
        }
        glenixElementChildList.addChild(account);
    }

    public void setAccountIdentifier(String accountIdentifier) throws Exception {
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            Account a = this.getAccount();
            if (a != null) {
                a.setAccountIdentifier(null);
            }
            return;
        }
        Account a = this.getOrAddAccount();
        a.setAccountIdentifier(accountIdentifier);
    }

    public String getStartDateTime() {
        return this.getChildValue("startDateTime");
    }

    public LocalDateTime parseDateTime(String value) {
        try {
            LocalDateTime ldt = LocalDateTime.parse(value, this.inputDateTimeFormatter);
            return ldt;
        }
        catch (Exception e) {
            try {
                return LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (Exception ee) {
                return null;
            }
        }
    }

    public LocalDateTime getStartDateTimeAsDateTime() {
        String val = this.getChildValue("startDateTime");
        if (val == null || val.isEmpty()) {
            return null;
        }
        return this.parseDateTime(val);
    }

    public LocalDate getStartDateTimeAsDate() {
        LocalDateTime ldt = this.getStartDateTimeAsDateTime();
        if (ldt == null) {
            return null;
        }
        return ldt.toLocalDate();
    }

    public LocalTime getStartDateTimeAsTime() {
        LocalDateTime ldt = this.getStartDateTimeAsDateTime();
        if (ldt == null) {
            return null;
        }
        return ldt.toLocalTime();
    }

    public String getEndDateTime() {
        return this.getChildValue("endDateTime");
    }

    public LocalDateTime getEndDateTimeAsDateTime() {
        String val = this.getChildValue("endDateTime");
        if (val == null || val.isEmpty()) {
            return null;
        }
        return this.parseDateTime(val);
    }

    public LocalDate getEndDateTimeAsDate() {
        LocalDateTime ldt = this.getEndDateTimeAsDateTime();
        if (ldt == null) {
            return null;
        }
        return ldt.toLocalDate();
    }

    public LocalTime getEndDateTimeAsTime() {
        LocalDateTime ldt = this.getEndDateTimeAsDateTime();
        if (ldt == null) {
            return null;
        }
        return ldt.toLocalTime();
    }

    public String getBreakTime() {
        return this.getChildValue("breakTime");
    }

    public LocalTime getBreakTimeAsTime() {
        String val = this.getChildValue("breakTime");
        if (val == null || val.isEmpty()) {
            return null;
        }
        return LocalTime.parse(val, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public GlenixStringElement getAmount() {
        return (GlenixStringElement)this.getChild("amount");
    }

    public Double getCreditAmount(String transactionType) {
        Double amount = this.getAmountAsDouble();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return amount;
        }
        return -amount.doubleValue();
    }

    public Double getDebitAmount(String transactionType) {
        Double amount = this.getAmountAsDouble();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -amount.doubleValue();
        }
        return amount;
    }

    public void setAmount(Double value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("amount");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(this.formatTwoDpInput.format(value));
        }
    }

    public void setAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("amount");
        gse.setGlenixElementValue(value);
    }

    public Double getAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("amount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public GlenixStringElement getFullAmount() {
        return (GlenixStringElement)this.getChild("fullAmount");
    }

    public void setFullAmount(Double value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("fullAmount");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(this.formatTwoDpInput.format(value));
        }
    }

    public void setFullAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("fullAmount");
        gse.setGlenixElementValue(value);
    }

    public Double getFullAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("fullAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public GlenixStringElement getApportionmentMethod() {
        return (GlenixStringElement)this.getChild("apportionmentMethod");
    }

    public String getApportionmentMethodString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("apportionmentMethod");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setApportionmentMethod(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("apportionmentMethod");
        gse.setGlenixElementValue(value);
    }

    public GlenixStringElement getQuantity() {
        return (GlenixStringElement)this.getChild("quantity");
    }

    public Double getCreditQuantity(String transactionType) {
        Double quantity = this.getQuantityAsDouble();
        if (quantity == null || quantity.equals(0.0)) {
            return quantity;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return quantity;
        }
        return -quantity.doubleValue();
    }

    public Double getDebitQuantity(String transactionType) {
        Double quantity = this.getQuantityAsDouble();
        if (quantity == null || quantity.equals(0.0)) {
            return quantity;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -quantity.doubleValue();
        }
        return quantity;
    }

    public Double getQuantityAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("quantity");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public GlenixStringElement getProvisionAmount() {
        return (GlenixStringElement)this.getChild("provisionAmount");
    }

    public Double getCreditProvisionAmount(String transactionType) {
        Double amount = this.getProvisionAmountAsDouble();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return amount;
        }
        return -amount.doubleValue();
    }

    public Double getDebitProvisionAmount(String transactionType) {
        Double amount = this.getProvisionAmountAsDouble();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -amount.doubleValue();
        }
        return amount;
    }

    public Double getProvisionAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("provisionAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public GlenixStringElement getProvisionQuantity() {
        return (GlenixStringElement)this.getChild("provisionQuantity");
    }

    public Double getCreditProvisionQuantity(String transactionType) {
        Double quantity = this.getProvisionQuantityAsDouble();
        if (quantity == null || quantity.equals(0.0)) {
            return quantity;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return quantity;
        }
        return -quantity.doubleValue();
    }

    public Double getDebitProvisionQuantity(String transactionType) {
        Double quantity = this.getProvisionQuantityAsDouble();
        if (quantity == null || quantity.equals(0.0)) {
            return quantity;
        }
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -quantity.doubleValue();
        }
        return quantity;
    }

    public Double getProvisionQuantityAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("provisionQuantity");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public GlenixStringElement getLineComment() {
        return (GlenixStringElement)this.getChild("lineComment");
    }

    public GlenixStringElement getInvoiceComment() {
        return (GlenixStringElement)this.getChild("invoiceComment");
    }

    public String getLineNumber() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("lineNumber");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public Integer getLineNumberAsInt() {
        String ln = this.getLineNumber();
        if (ln == null || ln.isEmpty()) {
            return null;
        }
        return Integer.parseInt(ln);
    }

    public String getAmountString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("amount");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getFullAmountString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("fullAmount");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getQuantityString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("quantity");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setQuantity(Double value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("quantity");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(this.formatSixDpInput.format(value));
        }
    }

    public String getProvisionAmountString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("provisionAmount");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getProvisionQuantityString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("provisionQuantity");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getLineCommentString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("lineComment");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getInvoiceCommentString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("invoiceComment");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setLineComment(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("lineComment");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(value);
        }
    }

    public void setInvoiceComment(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("invoiceComment");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(value);
        }
    }

    public void setProvisionAmount(Double value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionAmount");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(this.formatTwoDpInput.format(value));
        }
    }

    public void setProvisionAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionAmount");
        gse.setGlenixElementValue(value);
    }

    public void setProvisionQuantity(Double value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionQuantity");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(this.formatSixDpInput.format(value));
        }
    }

    public void setProvisionQuantity(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionQuantity");
        gse.setGlenixElementValue(value);
    }

    public ActivityStatement getActivityStatement() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatement");
        if (glenixElementChildList == null) {
            return null;
        }
        if (glenixElementChildList.getChildCount() == 1) {
            return (ActivityStatement)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getActivityStatementNumber() {
        ActivityStatement as = this.getActivityStatement();
        if (as == null) {
            return null;
        }
        return as.getActivityStatementNumber();
    }

    public SimpleStringProperty getActivityStatementNumberProperty() {
        ActivityStatement as = this.getActivityStatement();
        if (as == null) {
            return null;
        }
        return as.getActivityStatementNumberProperty();
    }

    public void setActivityStatementNumber(String asNumber) throws Exception {
        if (asNumber == null || asNumber.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatement");
            if (glenixElementChildList != null) {
                glenixElementChildList.clearChildren();
            }
            return;
        }
        ActivityStatement as = (ActivityStatement)this.getOrAddChild("activityStatement");
        if (as != null) {
            as.setActivityStatementNumber(asNumber);
        }
    }

    public void deleteActivityStatement() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatement");
        if (glenixElementChildList != null) {
            glenixElementChildList.clearChildren();
        }
    }

    public void loadFasV2ProvisionList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("taxMaster")) {
            Provision p = this.getOrAddProvision();
            p.loadFasV2ProvisionList(doc, element);
        }
    }

    public void loadFasV2AccountList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("account")) {
            Account a = this.getOrAddAccount();
            a.loadFasV2AccountList(doc, element);
        }
    }

    public void loadFasV2AccountListMeasurable(Document doc, Element element, Business business) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("measurableMaster")) {
            Account a = this.getOrAddAccount();
            a.loadFasV2AccountListMeasurable(doc, element, business);
        }
    }

    public void loadFasV2ActivityStatement(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("SBRDocumentAS")) {
            ActivityStatement as = (ActivityStatement)this.getOrAddChild("activityStatement");
            as.loadFasV2ActivityStatement(doc, element);
        }
    }

    public void loadFasV2Transactions(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("entryDetail")) {
            NodeList nodeList = element.getChildNodes();
            boolean hasmeas = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Element el2;
                Node node2;
                int j;
                NodeList nodeList2;
                GlenixStringElement gse2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("lineNumber")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("lineNumber");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("detailComment")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("lineComment");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("account") && !hasmeas) {
                    Account a = this.getOrAddAccount();
                    a.loadFasV2Transactions(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("amount")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("amount");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("reconciliationReference")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("reconciliationNumber");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("measurable")) {
                    nodeList2 = el.getChildNodes();
                    for (j = 0; j < nodeList2.getLength(); ++j) {
                        node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1) continue;
                        el2 = (Element)node2;
                        if (el2.getLocalName().equals("measurableQuantity")) {
                            gse = (GlenixStringElement)this.getOrAddChild("quantity");
                            gse.setGlenixElementValue(el2.getTextContent());
                            continue;
                        }
                        if (el2.getLocalName().equals("measurableStartDateTime")) {
                            gse = (GlenixStringElement)this.getOrAddChild("startDateTime");
                            gse.setGlenixElementValue(el2.getTextContent());
                            continue;
                        }
                        if (el2.getLocalName().equals("measurableEndDateTime")) {
                            gse = (GlenixStringElement)this.getOrAddChild("endDateTime");
                            gse.setGlenixElementValue(el2.getTextContent());
                            continue;
                        }
                        if (!el2.getLocalName().equals("measurableMaster")) continue;
                        Account a = this.getOrAddAccount();
                        a.loadFasV2TransactionsMeasurable(doc, el2);
                        hasmeas = true;
                    }
                    continue;
                }
                if (!el.getLocalName().equals("taxes")) continue;
                nodeList2 = el.getChildNodes();
                for (j = 0; j < nodeList2.getLength(); ++j) {
                    node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    el2 = (Element)node2;
                    if (el2.getLocalName().equals("taxAmount")) {
                        gse = (GlenixStringElement)this.getOrAddChild("provisionAmount");
                        gse.setGlenixElementValue(el2.getTextContent());
                        continue;
                    }
                    if (el2.getLocalName().equals("taxReconciliationReference")) {
                        gse = (GlenixStringElement)this.getOrAddChild("provisionReconciliationNumber");
                        gse.setGlenixElementValue(el2.getTextContent());
                        continue;
                    }
                    if (!el2.getLocalName().equals("taxMaster")) continue;
                    Provision p = this.getOrAddProvision();
                    p.loadFasV2Transactions(doc, el2);
                }
            }
        }
    }

    public String getReconciliationNumber() {
        return this.getChildValue("reconciliationNumber");
    }

    public Integer getReconciliationNumberAsInt() {
        String num = this.getReconciliationNumber();
        if (num == null || num.isEmpty()) {
            return null;
        }
        return Integer.parseInt(num);
    }

    public void setReconciliationNumber(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("reconciliationNumber");
        gse.setGlenixElementValue(value);
    }

    public String getReconciliationMaxDate() {
        return this.getChildValue("reconciliationMaxDate");
    }

    public LocalDate getReconciliationMaxDateAsDate() {
        String val = this.getChildValue("reconciliationMaxDate");
        if (val == null || val.isEmpty()) {
            return null;
        }
        return LocalDate.parse(val, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public Double getCreditReconciliationAmountAsDouble() {
        Double ra = this.getReconciliationAmountAsDouble();
        if (ra == null) {
            return null;
        }
        return -ra.doubleValue();
    }

    public Double getReconciliationAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("reconciliationAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public void setReconciliationAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("reconciliationAmount");
        gse.setGlenixElementValue(value);
    }

    public String getReconciliationAmount() {
        return this.getChildValue("reconciliationAmount");
    }

    public String getReconciliationDetails() {
        String recDet = this.getReconciliationNumber();
        LocalDate ld = this.getReconciliationMaxDateAsDate();
        if (ld != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ")";
        }
        return recDet;
    }

    private String formatTwoDp(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.formatTwoDp.format(amount);
    }

    public String getReconciliationDetailsAndAmount() {
        String recDet = this.getReconciliationNumber();
        LocalDate ld = this.getReconciliationMaxDateAsDate();
        Double amt = this.getReconciliationAmountAsDouble();
        if (ld != null && amt != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ", " + this.formatTwoDp(amt) + ")";
        }
        return recDet;
    }

    public String getReconciliationDetailsAndCreditAmount() {
        String recDet = this.getReconciliationNumber();
        LocalDate ld = this.getReconciliationMaxDateAsDate();
        Double amt = this.getCreditReconciliationAmountAsDouble();
        if (ld != null && amt != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ", " + this.formatTwoDp(-amt.doubleValue()) + ")";
        }
        return recDet;
    }

    public String getProvisionReconciliationNumber() {
        return this.getChildValue("provisionReconciliationNumber");
    }

    public void setProvisionReconciliationNumber(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionReconciliationNumber");
        gse.setGlenixElementValue(value);
    }

    public Integer getProvisionReconciliationNumberAsInt() {
        String num = this.getProvisionReconciliationNumber();
        if (num == null || num.isEmpty()) {
            return null;
        }
        return Integer.parseInt(num);
    }

    public String getProvisionReconciliationMaxDate() {
        return this.getChildValue("provisionReconciliationMaxDate");
    }

    public LocalDate getProvisionReconciliationMaxDateAsDate() {
        String val = this.getChildValue("provisionReconciliationMaxDate");
        if (val == null || val.isEmpty()) {
            return null;
        }
        return LocalDate.parse(val, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public String getProvisionReconciliationAmount() {
        return this.getChildValue("provisionReconciliationAmount");
    }

    public Double getProvisionReconciliationAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("provisionReconciliationAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public String getProvisionReconciliationDetails() {
        String recDet = this.getProvisionReconciliationNumber();
        LocalDate ld = this.getProvisionReconciliationMaxDateAsDate();
        if (ld != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ")";
        }
        return recDet;
    }

    public String getProvisionReconciliationDetailsAndAmount() {
        String recDet = this.getProvisionReconciliationNumber();
        LocalDate ld = this.getProvisionReconciliationMaxDateAsDate();
        Double amt = this.getProvisionReconciliationAmountAsDouble();
        if (ld != null && amt != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ", " + this.formatTwoDp(amt) + ")";
        }
        return recDet;
    }

    public HomeOffice getHomeOffice() {
        return (HomeOffice)this.getChild("homeOffice");
    }

    public String getHomeOfficeIdentifier() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeIdentifier();
    }

    public void setHomeOfficeIdentifier(String value) throws Exception {
        HomeOffice ho = this.getOrAddHomeOffice();
        if (ho != null) {
            ho.setHomeOfficeIdentifier(value);
        }
    }

    public void setHomeOffice(HomeOffice homeOffice) throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("homeOffice");
        if (gecl.getChildCount() > 0) {
            gecl.clearChildren();
        }
        gecl.addChild(homeOffice);
    }

    public String getHomeOfficeFullAddress() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getFullAddress();
    }

    public String getHomeOfficeStartDate() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeStartDate();
    }

    public String getHomeOfficeEndDate() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeEndDate();
    }

    public String getHomeOfficeWeeksUnused() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeWeeksUnused();
    }

    public String getHomeOfficeFloorArea() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeFloorArea();
    }

    public String getHomeOfficeHomeTotalArea() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeHomeTotalArea();
    }

    public String getHomeOfficeComment() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeComment();
    }

    public HomeOffice getOrAddHomeOffice() throws Exception {
        HomeOffice result = (HomeOffice)this.getChild("homeOffice");
        if (result == null) {
            result = (HomeOffice)((GlenixElementChildList)this.childrenAndMeta.get("homeOffice")).addChild();
        }
        return result;
    }

    public FuelTaxCredit getFuelTaxCredit() {
        return (FuelTaxCredit)this.getChild("fuelTaxCredit");
    }

    public String getFuelTaxCreditIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditIdentifier();
    }

    public void setFuelTaxCreditIdentifier(String value) throws Exception {
        FuelTaxCredit ho = this.getOrAddFuelTaxCredit();
        if (ho != null) {
            ho.setFuelTaxCreditIdentifier(value);
        }
    }

    public void setFuelTaxCredit(FuelTaxCredit fuelTaxCredit) throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("fuelTaxCredit");
        if (gecl.getChildCount() > 0) {
            gecl.clearChildren();
        }
        gecl.addChild(fuelTaxCredit);
    }

    public String getFuelTaxCreditComment() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditComment();
    }

    public FuelTaxCredit getOrAddFuelTaxCredit() throws Exception {
        FuelTaxCredit result = (FuelTaxCredit)this.getChild("fuelTaxCredit");
        if (result == null) {
            result = (FuelTaxCredit)((GlenixElementChildList)this.childrenAndMeta.get("fuelTaxCredit")).addChild();
        }
        return result;
    }

    public String getFuelTaxCreditAccountIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditAccountIdentifier();
    }

    public String getFTCProvisionIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFTCProvisionIdentifier();
    }

    public String getFTCOverclaimedProvisionIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFTCOverclaimedProvisionIdentifier();
    }

    public String getFuelTaxCreditUsageType() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditUsageType();
    }

    public String getFuelTaxCreditFuelType() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditFuelType();
    }

    public String getFuelTaxCreditOverrideRate() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditOverrideRate();
    }

    public ImportData getImportData() {
        return (ImportData)this.getChild("importData");
    }

    public ImportData getOrAddImportData() throws Exception {
        ImportData result = (ImportData)this.getChild("importData");
        if (result == null) {
            result = (ImportData)((GlenixElementChildList)this.childrenAndMeta.get("importData")).addChild();
        }
        return result;
    }

    public void deleteImportData() throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("importData");
        gecl.clearChildren();
    }

    public void setImportData(ImportData importData) throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("importData");
        gecl.addChild(importData);
    }

    public void copyImportData(ImportData importData) throws Exception {
        this.setImportDataAccount(importData.getImportDataAccount());
        this.setImportDataAmount(importData.getImportDataAmount());
        this.setImportDataBankAccount(importData.getImportDataBankAccount());
        this.setImportDataComment(importData.getImportDataComment());
        this.setImportDataCounterparty(importData.getImportDataCounterparty());
        this.setImportDataDate(importData.getImportDataDate());
        this.setImportDataFileName(importData.getImportDataFileName());
        this.setImportDataIdentifier(importData.getImportDataIdentifier());
        this.setImportDataProvision(importData.getImportDataProvision());
        this.setImportDataProvisionAmount(importData.getImportDataProvisionAmount());
        this.setImportDataQuantity(importData.getImportDataQuantity());
        this.setImportDataTransactionReference(importData.getImportDataTransactionReference());
        this.setImportDataTransactionType(importData.getImportDataTransactionType());
    }

    public void setImportData(Document doc) throws Exception {
        if (doc == null) {
            this.setImportDataIdentifier(null);
            return;
        }
        ImportData id = this.getOrAddImportData();
        id.loadDocumentElementOverwrite(doc, doc.getDocumentElement());
    }

    public String getImportDataIdentifier() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataIdentifier();
    }

    public void setImportDataIdentifier(String value) throws Exception {
        if (value == null) {
            ((GlenixElementChildList)this.childrenAndMeta.get("importData")).clearChildren();
            return;
        }
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataIdentifier(value);
        }
    }

    public String getImportDataFileName() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataFileName();
    }

    public void setImportDataFileName(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataFileName(value);
        }
    }

    public String getImportDataTransactionReference() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataTransactionReference();
    }

    public void setImportDataTransactionReference(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataTransactionReference(value);
        }
    }

    public String getImportDataTransactionType() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataTransactionType();
    }

    public void setImportDataTransactionType(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataTransactionType(value);
        }
    }

    public String getImportDataDate() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataDate();
    }

    public LocalDate getImportDataDateAsDate() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataDateAsDate();
    }

    public void setImportDataDate(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataDate(value);
        }
    }

    public String getImportDataCounterparty() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataCounterparty();
    }

    public void setImportDataCounterparty(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataCounterparty(value);
        }
    }

    public String getImportDataComment() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataComment();
    }

    public void setImportDataComment(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataComment(value);
        }
    }

    public String getImportDataAmount() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataAmount();
    }

    public Double getImportDataAmountAsDouble() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataAmountAsDouble();
    }

    public void setImportDataAmount(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataAmount(value);
        }
    }

    public String getImportDataQuantity() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataQuantity();
    }

    public Double getImportDataQuantityAsDouble() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataQuantityAsDouble();
    }

    public void setImportDataQuantity(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataQuantity(value);
        }
    }

    public String getImportDataProvisionAmount() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataProvisionAmount();
    }

    public Double getImportDataProvisionAmountAsDouble() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataProvisionAmountAsDouble();
    }

    public void setImportDataProvisionAmount(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataProvisionAmount(value);
        }
    }

    public String getImportDataAccount() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataAccount();
    }

    public void setImportDataAccount(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataAccount(value);
        }
    }

    public String getImportDataProvision() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataProvision();
    }

    public void setImportDataProvision(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataProvision(value);
        }
    }

    public String getImportDataBankAccount() {
        ImportData ho = this.getImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataBankAccount();
    }

    public void setImportDataBankAccount(String value) throws Exception {
        ImportData ho = this.getOrAddImportData();
        if (ho != null) {
            ho.setImportDataBankAccount(value);
        }
    }

    public void removeMasterFileInformation() {
        ImportData id;
        FuelTaxCredit ftc;
        HomeOffice ho;
        ActivityStatement as;
        Provision p;
        Account a = this.getAccount();
        if (a != null) {
            a.removeMasterFileInformation();
        }
        if ((p = this.getProvision()) != null) {
            p.removeMasterFileInformation();
        }
        if ((as = this.getActivityStatement()) != null) {
            as.removeMasterFileInformation();
        }
        if ((ho = this.getHomeOffice()) != null) {
            ho.removeMasterFileInformation();
        }
        if ((ftc = this.getFuelTaxCredit()) != null) {
            ftc.removeMasterFileInformation();
        }
        if ((id = this.getImportData()) != null) {
            id.removeMasterFileInformation();
        }
    }
}

