/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.CounterpartyPayrollDetails;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.PEE0003Payee;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.TransactionBankAccount;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.trn.TransactionPaySlipDetail;
import au.com.glenix.trn.TransactionProvisionDetails;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Transaction
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private DateTimeFormatter outputDateFormatter;
    private NumberFormat formatTwoDp = new DecimalFormat("#,##0.00");
    private GlenixTrnXBRL provisionTrnXBRL;

    public Transaction() throws Exception {
        this.name = "transaction";
        this.namespace = "http://www.glenix.com.au/";
        this.sbrName = "PAYEVNTEMP";
        this.sbrNamespace = "http://www.sbr.gov.au/ato/payevntemp";
        this.sbrContext = "RP";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("transactionNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionType", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionType", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionStatus", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionStatus", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionDate", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionComment", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionComment", null, null, null, 1, true));
        this.childrenAndMeta.put("counterparty", new GlenixElementChildList(Counterparty.class, "http://www.glenix.com.au/", "counterparty", null, null, null, 1, false));
        this.childrenAndMeta.put("transactionLine", new GlenixElementChildList(TransactionLine.class, "http://www.glenix.com.au/", "transactionLine", null, null, null, -1, false));
        this.childrenAndMeta.put("transactionReconciliationNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionReconciliationNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionReconciliationMaxDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionReconciliationMaxDate", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionReconciliationAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionReconciliationAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("batch", new GlenixElementChildList(Batch.class, "http://www.glenix.com.au/", "batch", null, null, null, 1, false));
        this.childrenAndMeta.put("transactionPaySlipDetail", new GlenixElementChildList(TransactionPaySlipDetail.class, "http://www.glenix.com.au/", "transactionPaySlipDetail", null, null, null, 1, false));
        this.childrenAndMeta.put("transactionProvisionDetails", new GlenixElementChildList(TransactionProvisionDetails.class, "http://www.glenix.com.au/", "transactionProvisionDetails", null, null, null, 1, false));
        this.childrenAndMeta.put("transactionBankAccount", new GlenixElementChildList(TransactionBankAccount.class, "http://www.glenix.com.au/", "transactionBankAccount", null, null, null, -1, false));
        this.childrenAndMeta.put("transactionPayEventEmp", new GlenixElementChildList(PEE0003Payee.class, "http://www.glenix.com.au/", "transactionPayEventEmp", null, null, null, 1, false));
        this.childrenAndMeta.put("documentNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "documentNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("documentDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "documentDate", null, null, null, 1, true));
        this.childrenAndMeta.put("dueDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "dueDate", null, null, null, 1, true));
        this.childrenAndMeta.put("AITransactionNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "AITransactionNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("transactionTypeRef", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "transactionTypeRef", null, null, null, 1, true));
        this.outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private void setChildValue(String fieldName, String value) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(fieldName);
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot set child list for " + fieldName + ", invalid field.");
        }
        if (glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement glenixStringElement = (GlenixStringElement)glenixElementChildList.getChild(0);
            glenixStringElement.setGlenixElementValue(value);
            return;
        }
        GlenixStringElement glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild(value);
    }

    public TransactionPaySlipDetail getTransactionPaySlipDetail() {
        return (TransactionPaySlipDetail)this.getChild("transactionPaySlipDetail");
    }

    public TransactionProvisionDetails getTransactionProvisionDetails() {
        return (TransactionProvisionDetails)this.getChild("transactionProvisionDetails");
    }

    public void setTransactionComment(String value) throws Exception {
        this.setChildValue("transactionComment", value);
    }

    public String getTransactionComment() {
        return this.getChildValue("transactionComment");
    }

    public String getTransactionNumber() {
        return this.getChildValue("transactionNumber");
    }

    public void setTransactionDate(String value) throws Exception {
        this.setChildValue("transactionDate", value);
    }

    public String getTransactionDate() {
        return this.getChildValue("transactionDate");
    }

    public void setTransactionType(String value) throws Exception {
        this.setChildValue("transactionType", value);
    }

    public String getTransactionType() {
        return this.getChildValue("transactionType");
    }

    public void setTransactionStatus(String value) throws Exception {
        this.setChildValue("transactionStatus", value);
    }

    public String getTransactionStatus() {
        return this.getChildValue("transactionStatus");
    }

    public void setTransactionNumber(String value) throws Exception {
        this.setChildValue("transactionNumber", value);
    }

    public LocalDate getTransactionDateAsDate() {
        String date = this.getChildValue("transactionDate");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PEE0003Payee getTransactionPayEventEmp() {
        return (PEE0003Payee)this.getChild("transactionPayEventEmp");
    }

    public int getTransactionLineCount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            return glenixElementChildList.getChildCount();
        }
        return 0;
    }

    public TransactionLine getTransactionLine(int index) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null && index >= 0 && index < glenixElementChildList.getChildCount()) {
            return (TransactionLine)glenixElementChildList.getChild(index);
        }
        return null;
    }

    public TransactionLine getTransactionLineByLineNumber(String lineNumber) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                String ln = tl.getLineNumber();
                if (ln == null || !ln.equals(lineNumber)) continue;
                return tl;
            }
        }
        return null;
    }

    public ArrayList<TransactionTransactionLine> getTransactionTransactionLineLineArrayList() {
        int count = this.getTransactionLineCount();
        if (count <= 0) {
            return null;
        }
        ArrayList<TransactionTransactionLine> result = new ArrayList<TransactionTransactionLine>();
        for (int i = 0; i < count; ++i) {
            result.add(new TransactionTransactionLine(i));
        }
        return result;
    }

    public TransactionLine getFirstTransactionLine() {
        return (TransactionLine)this.getChild("transactionLine");
    }

    public TransactionLine addBlankTransactionLine() throws Exception {
        return (TransactionLine)((GlenixElementChildList)this.childrenAndMeta.get("transactionLine")).addChild();
    }

    public void addTransactionLine(TransactionLine transactionLine) throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (gecl == null) {
            throw new Exception("Error, cannot add transaction line");
        }
        gecl.addChild(transactionLine);
    }

    public void removeTransactionLines() throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (gecl != null) {
            gecl.clearChildren();
        }
    }

    public Counterparty getCounterparty() {
        return (Counterparty)this.getChild("counterparty");
    }

    public Counterparty getOrAddCounterparty() throws Exception {
        Counterparty result = (Counterparty)this.getChild("counterparty");
        if (result == null) {
            result = (Counterparty)((GlenixElementChildList)this.childrenAndMeta.get("counterparty")).addChild();
        }
        return result;
    }

    public void removeCounterparty() {
        ((GlenixElementChildList)this.childrenAndMeta.get("counterparty")).clearChildren();
    }

    public void setCounterparty(Counterparty counterparty) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("counterparty");
        if (glenixElementChildList.getChildCount() > 0) {
            glenixElementChildList.clearChildren();
        }
        glenixElementChildList.addChild(counterparty);
    }

    public String getCounterpartyIdentifier() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyIdentifier();
    }

    public void setCounterpartyIdentifier(String value) throws Exception {
        Counterparty c = this.getOrAddCounterparty();
        if (c == null) {
            return;
        }
        c.setCounterpartyIdentifier(value);
    }

    public SimpleStringProperty getCounterpartyIdentifierProperty() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyIdentifierProperty();
    }

    public String getCounterpartyLegalName() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyLegalName();
    }

    public SimpleStringProperty getCounterpartyLegalNameProperty() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyLegalNameProperty();
    }

    public String getCounterpartyTradingName() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyTradingName();
    }

    public String getCounterpartyDescription() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyDescription();
    }

    public String getCounterpartyABN() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyABN();
    }

    public SimpleStringProperty getCounterpartyABNProperty() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyABNProperty();
    }

    public String getCounterpartySuperProductUSI() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getSuperProductUSI();
    }

    public SimpleStringProperty getCounterpartySuperProductUSIProperty() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getSuperProductUSIProperty();
    }

    public void deleteCounterpartySuperProductDetails() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return;
        }
        c.deleteSuperProductDetails();
    }

    public String getMaximumSeverityCode() {
        PEE0003Payee p = this.getTransactionPayEventEmp();
        if (p == null) {
            return null;
        }
        return p.getMaximumSeverityCode();
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        this.appendToElement(document, businessEl);
        return document;
    }

    public Provision getProvision() {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            return null;
        }
        return tl.getProvision();
    }

    public String getProvisionIdentifier() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionIdentifier();
    }

    public SimpleStringProperty getProvisionIdentifierProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionIdentifierProperty();
    }

    public boolean hasProvisionIdentifier(String provisionIdentifier) {
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getTransactionLineCount(); ++i) {
            TransactionLine tl = this.getTransactionLine(i);
            if (!provisionIdentifier.equals(tl.getProvisionIdentifier())) continue;
            return true;
        }
        return false;
    }

    public String getProvisionName() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionName();
    }

    public String getUniqueProvisionIdentifier() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(0);
            if (tl == null) {
                return null;
            }
            Provision p = tl.getProvision();
            if (p == null) {
                return null;
            }
            String provisionIdentifier = p.getProvisionIdentifier();
            if (provisionIdentifier == null) {
                return null;
            }
            for (int i = 1; i < glenixElementChildList.getChildCount(); ++i) {
                tl = (TransactionLine)glenixElementChildList.getChild(i);
                if (tl == null) {
                    return null;
                }
                p = tl.getProvision();
                if (p == null) {
                    return null;
                }
                if (provisionIdentifier.equals(p.getProvisionIdentifier())) continue;
                return null;
            }
            return provisionIdentifier;
        }
        return null;
    }

    public String getUniqueProvisionIdentifierException() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(0);
            if (tl == null) {
                return null;
            }
            Provision p = tl.getProvision();
            if (p == null) {
                return null;
            }
            boolean diffid = false;
            String provisionIdentifier = p.getProvisionIdentifier();
            if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
                return null;
            }
            for (int i = 1; i < glenixElementChildList.getChildCount(); ++i) {
                tl = (TransactionLine)glenixElementChildList.getChild(i);
                if (tl == null) {
                    return null;
                }
                p = tl.getProvision();
                if (p == null) {
                    return null;
                }
                String thisAI = p.getProvisionIdentifier();
                if (thisAI == null || thisAI.isEmpty()) {
                    return null;
                }
                if (provisionIdentifier.equals(thisAI)) continue;
                diffid = true;
            }
            if (diffid) {
                throw new Exception("Multiple provisions");
            }
            return provisionIdentifier;
        }
        return null;
    }

    public SimpleStringProperty getProvisionNameProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionNameProperty();
    }

    public String getProvisionDescription() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionDescription();
    }

    public SimpleStringProperty getProvisionDescriptionProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionDescriptionProperty();
    }

    public String getProvisionClassificationReference() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionClassificationReference();
    }

    public SimpleStringProperty getProvisionClassificationReferenceProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionClassificationReferenceProperty();
    }

    public String getProvisionActive() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionActive();
    }

    public SimpleStringProperty getProvisionActiveProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionActiveProperty();
    }

    public String getProvisionPercentage() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionPercentage();
    }

    public SimpleStringProperty getProvisionPercentageProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionPercentageProperty();
    }

    public String getProvisionGrossBASClassification() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionGrossBASClassification();
    }

    public SimpleStringProperty getProvisionGrossBASClassificationProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionGrossBASClassificationProperty();
    }

    public String getProvisionTaxBASClassification() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionTaxBASClassification();
    }

    public SimpleStringProperty getProvisionTaxBASClassificationProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionTaxBASClassificationProperty();
    }

    public String getProvisionPSType() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionPSType();
    }

    public SimpleStringProperty getProvisionPSTypeProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionPSTypeProperty();
    }

    public String getProvisionGrossPSClassification() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionGrossPSClassification();
    }

    public SimpleStringProperty getProvisionGrossPSClassificationProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionGrossPSClassificationProperty();
    }

    public String getProvisionTaxPSClassification() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionTaxPSClassification();
    }

    public SimpleStringProperty getProvisionTaxPSClassificationProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionTaxPSClassificationProperty();
    }

    public String getProvisionLeaveType() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionLeaveType();
    }

    public SimpleStringProperty getProvisionLeaveTypeProperty() {
        Provision c = this.getProvision();
        if (c == null) {
            return null;
        }
        return c.getProvisionLeaveTypeProperty();
    }

    public Account getAccount() {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            return null;
        }
        return tl.getAccount();
    }

    public String getAccountIdentifier() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountIdentifier();
    }

    public SimpleStringProperty getAccountIdentifierProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountIdentifierProperty();
    }

    public boolean hasAccountIdentifier(String accountIdentifier) {
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getTransactionLineCount(); ++i) {
            TransactionLine tl = this.getTransactionLine(i);
            if (!accountIdentifier.equals(tl.getAccountIdentifier())) continue;
            return true;
        }
        return false;
    }

    public String getAccountName() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountName();
    }

    public String getUniqueAccountIdentifier() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(0);
            if (tl == null) {
                return null;
            }
            Account p = tl.getAccount();
            if (p == null) {
                return null;
            }
            String accountIdentifier = p.getAccountIdentifier();
            if (accountIdentifier == null) {
                return null;
            }
            for (int i = 1; i < glenixElementChildList.getChildCount(); ++i) {
                tl = (TransactionLine)glenixElementChildList.getChild(i);
                if (tl == null) {
                    return null;
                }
                p = tl.getAccount();
                if (p == null) {
                    return null;
                }
                if (accountIdentifier.equals(p.getAccountIdentifier())) continue;
                return null;
            }
            return accountIdentifier;
        }
        return null;
    }

    public String getUniqueAccountIdentifierException() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(0);
            if (tl == null) {
                return null;
            }
            Account p = tl.getAccount();
            if (p == null) {
                return null;
            }
            boolean diffid = false;
            String accountIdentifier = p.getAccountIdentifier();
            if (accountIdentifier == null || accountIdentifier.isEmpty()) {
                return null;
            }
            for (int i = 1; i < glenixElementChildList.getChildCount(); ++i) {
                tl = (TransactionLine)glenixElementChildList.getChild(i);
                if (tl == null) {
                    return null;
                }
                p = tl.getAccount();
                if (p == null) {
                    return null;
                }
                String thisAI = p.getAccountIdentifier();
                if (thisAI == null || thisAI.isEmpty()) {
                    return null;
                }
                if (accountIdentifier.equals(thisAI)) continue;
                diffid = true;
            }
            if (diffid) {
                throw new Exception("Multiple accounts");
            }
            return accountIdentifier;
        }
        return null;
    }

    public SimpleStringProperty getAccountNameProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountNameProperty();
    }

    public String getAccountDescription() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountDescription();
    }

    public SimpleStringProperty getAccountDescriptionProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountDescriptionProperty();
    }

    public String getAccountClassificationReference() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountClassificationReference();
    }

    public SimpleStringProperty getAccountClassificationReferenceProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountClassificationReferenceProperty();
    }

    public String getAccountActive() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountActive();
    }

    public SimpleStringProperty getAccountActiveProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getAccountActiveProperty();
    }

    public String getAccountDefaultProvisionIdentifier() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getDefaultProvisionIdentifier();
    }

    public SimpleStringProperty getAccountDefaultProvisionIdentifierProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getDefaultProvisionIdentifierProperty();
    }

    public String getAccountRate() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getRate();
    }

    public SimpleStringProperty getAccountRateProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getRateProperty();
    }

    public String getAccountNormalRateMultiplier() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getNormalRateMultiplier();
    }

    public SimpleStringProperty getAccountNormalRateMultiplierProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getNormalRateMultiplierProperty();
    }

    public String getAccountPaymentDeductionType() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getPaymentDeductionType();
    }

    public SimpleStringProperty getAccountPaymentDeductionTypeProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getPaymentDeductionTypeProperty();
    }

    public String getAccountApplySuper() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getApplySuper();
    }

    public SimpleStringProperty getAccountApplySuperProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getApplySuperProperty();
    }

    public String getAccountApplyLeave() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getApplyLeave();
    }

    public SimpleStringProperty getAccountApplyLeaveProperty() {
        Account c = this.getAccount();
        if (c == null) {
            return null;
        }
        return c.getApplyLeaveProperty();
    }

    public Double getCreditTotalAmount() {
        Double amount = this.getTotalAmount();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return amount;
        }
        return -amount.doubleValue();
    }

    public Double getDebitTotalAmount() {
        Double amount = this.getTotalAmount();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -amount.doubleValue();
        }
        return amount;
    }

    public Double getTotalAmount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                GlenixStringElement amountGSE = tl.getAmount();
                if (amountGSE == null) continue;
                String amountString = amountGSE.getGlenixElementValue();
                try {
                    if (total == null) {
                        total = Double.valueOf(amountString);
                        continue;
                    }
                    total = total + Double.valueOf(amountString);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return total;
        }
        return null;
    }

    public Double getCreditTotalProvisionAmount() {
        Double amount = this.getTotalProvisionAmount();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return amount;
        }
        return -amount.doubleValue();
    }

    public Double getDebitTotalProvisionAmount() {
        Double amount = this.getTotalProvisionAmount();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -amount.doubleValue();
        }
        return amount;
    }

    public Double getTotalProvisionAmount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                GlenixStringElement provisionAmountGSE = tl.getProvisionAmount();
                if (provisionAmountGSE == null) continue;
                String provisionAmountString = provisionAmountGSE.getGlenixElementValue();
                try {
                    if (total == null) {
                        total = Double.valueOf(provisionAmountString);
                        continue;
                    }
                    total = total + Double.valueOf(provisionAmountString);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return total;
        }
        return null;
    }

    public Double getTotalDebits() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                GlenixStringElement amountGSE = tl.getAmount();
                if (amountGSE == null) continue;
                String amountString = amountGSE.getGlenixElementValue();
                try {
                    Double tmp = Double.valueOf(amountString);
                    if (tmp == null || !(tmp > 0.0)) continue;
                    if (total == null) {
                        total = tmp;
                        continue;
                    }
                    total = total + tmp;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (total == null || total == 0.0) {
                return total;
            }
            String transactionType = this.getTransactionType();
            if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
                return -total.doubleValue();
            }
            return total;
        }
        return null;
    }

    public Double getTotalCredits() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                GlenixStringElement amountGSE = tl.getAmount();
                if (amountGSE == null) continue;
                String amountString = amountGSE.getGlenixElementValue();
                try {
                    Double tmp = Double.valueOf(amountString);
                    if (tmp == null || !(tmp < 0.0)) continue;
                    if (total == null) {
                        total = tmp;
                        continue;
                    }
                    total = total + tmp;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (total == null || total == 0.0) {
                return total;
            }
            String transactionType = this.getTransactionType();
            if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
                return total;
            }
            return -total.doubleValue();
        }
        return null;
    }

    public Double getCreditTotalQuantity() {
        Double quantity = this.getTotalQuantity();
        if (quantity == null || quantity.equals(0.0)) {
            return quantity;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return quantity;
        }
        return -quantity.doubleValue();
    }

    public Double getDebitTotalQuantity() {
        Double quantity = this.getTotalQuantity();
        if (quantity == null || quantity.equals(0.0)) {
            return quantity;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return -quantity.doubleValue();
        }
        return quantity;
    }

    public Double getTotalQuantity() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                GlenixStringElement quantityGSE = tl.getQuantity();
                if (quantityGSE == null) continue;
                String quantityString = quantityGSE.getGlenixElementValue();
                try {
                    if (total == null) {
                        total = Double.valueOf(quantityString);
                        continue;
                    }
                    total = total + Double.valueOf(quantityString);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return total;
        }
        return null;
    }

    public Batch getBatch() {
        return (Batch)this.getChild("batch");
    }

    public String getBatchIdentifier() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchIdentifier();
    }

    public void setBatch(Batch batch) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("batch");
        if (glenixElementChildList.getChildCount() > 0) {
            glenixElementChildList.clearChildren();
        }
        glenixElementChildList.addChild(batch);
    }

    public void setBatchIdentifier(String batchIdentifier) throws Exception {
        if (batchIdentifier == null) {
            Batch existingBatch = this.getBatch();
            if (existingBatch != null) {
                GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("batch");
                glenixElementChildList.clearChildren();
            }
            return;
        }
        Batch b = (Batch)this.getOrAddChild("batch");
        if (b == null) {
            return;
        }
        b.setBatchIdentifier(batchIdentifier);
    }

    public void removeBatch() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("batch");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return;
            }
            glenixElementChildList.removeChild(0);
        }
    }

    public String getBatchComment() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchComment();
    }

    public String getBatchAuthorisedByContainer() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedByContainer();
    }

    public String getBatchAuthorisedByOwner() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedByOwner();
    }

    public String getBatchAuthorisedByViewer() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedByViewer();
    }

    public String getBatchAuthorisedTime() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedTime();
    }

    public String getBatchPeriodStart() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPeriodStart();
    }

    public LocalDate getBatchPeriodStartAsDate() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPeriodStartAsDate();
    }

    public String getBatchPeriodEnd() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPeriodEnd();
    }

    public LocalDate getBatchPeriodEndAsDate() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPeriodEndAsDate();
    }

    public String getBatchPaymentDate() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPaymentDate();
    }

    public LocalDate getBatchPaymentDateAsDate() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPaymentDateAsDate();
    }

    public String getBatchStatus() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchStatus();
    }

    public void setBatchStatus(String status) throws Exception {
        Batch b = this.getBatch();
        if (b == null) {
            return;
        }
        b.setBatchStatus(status);
    }

    public SimpleStringProperty getBatchIdentifierProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchIdentifierProperty();
    }

    public SimpleStringProperty getBatchCommentProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchCommentProperty();
    }

    public SimpleStringProperty getBatchAuthorisedByContainerProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedByContainerProperty();
    }

    public SimpleStringProperty getBatchAuthorisedByOwnerProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedByOwnerProperty();
    }

    public SimpleStringProperty getBatchAuthorisedByViewerProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedByViewerProperty();
    }

    public SimpleStringProperty getBatchAuthorisedTimeProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchAuthorisedTimeProperty();
    }

    public SimpleStringProperty getBatchPeriodStartProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPeriodStartProperty();
    }

    public SimpleStringProperty getBatchPeriodEndProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPeriodEndProperty();
    }

    public SimpleStringProperty getBatchPaymentDateProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchPaymentDateProperty();
    }

    public SimpleStringProperty getBatchStatusProperty() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getBatchStatusProperty();
    }

    public String getBatchCertAlias() {
        Batch b = this.getBatch();
        if (b == null) {
            return null;
        }
        return b.getCertAlias();
    }

    public void setBatchCertAlias(String value) throws Exception {
        Batch b = this.getBatch();
        if (b == null) {
            throw new Exception("Error, no batch found. You need to create the batch first.");
        }
        b.setCertAlias(value);
    }

    public CounterpartyPayrollDetails getCounterpartyPayrollDetails() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getCounterpartyPayrollDetails();
    }

    public String getCounterpartyStartDate() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyStartDate();
    }

    public SimpleStringProperty getCounterpartyStartDateProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyStartDateProperty();
    }

    public String getCounterpartyNormalRate() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyNormalRate();
    }

    public SimpleStringProperty getCounterpartyNormalRateProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyNormalRateProperty();
    }

    public String getCounterpartyFirstFullRosterStartDate() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstFullRosterStartDate();
    }

    public SimpleStringProperty getCounterpartyFirstFullRosterStartDateProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstFullRosterStartDateProperty();
    }

    public String getCounterpartyDaysInRoster() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyDaysInRoster();
    }

    public SimpleStringProperty getCounterpartyDaysInRosterProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyDaysInRosterProperty();
    }

    public String getCounterpartyFirstPayDay() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstPayDay();
    }

    public SimpleStringProperty getCounterpartyFirstPayDayProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstPayDayProperty();
    }

    public String getCounterpartyJobTitle() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyJobTitle();
    }

    public SimpleStringProperty getCounterpartyJobTitleProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyJobTitleProperty();
    }

    public String getCounterpartyAgreement() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAgreement();
    }

    public SimpleStringProperty getCounterpartyAgreementProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAgreementProperty();
    }

    public String getCounterpartyAnnualSalary() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAnnualSalary();
    }

    public SimpleStringProperty getCounterpartyAnnualSalaryProperty() {
        CounterpartyPayrollDetails cpd = this.getCounterpartyPayrollDetails();
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAnnualSalaryProperty();
    }

    public String getLatestSBRDocumentTFND0004Status() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getLatestSBRDocumentTFND0004Status();
    }

    public SimpleStringProperty getLatestSBRDocumentTFND0004StatusProperty() {
        Counterparty c = this.getCounterparty();
        if (c == null) {
            return null;
        }
        return c.getLatestSBRDocumentTFND0004StatusProperty();
    }

    public Document buildPEE0003EmpDocument() {
        Document doc = this.docBuilder.newDocument();
        doc.setXmlStandalone(true);
        this.buildSBRElement(doc, null);
        return doc;
    }

    public HashMap<String, Double> calculatePSTotals(GlenixTrnXBRL provisionTrnXBRL) {
        HashMap<String, Double> totals = new HashMap<String, Double>();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String taxPSClassification;
            String pi;
            Transaction provisionTransaction;
            TransactionLine tl = this.getTransactionLine(i);
            Double amount = tl.getAmountAsDouble();
            Double provisionAmount = tl.getProvisionAmountAsDouble();
            Provision p = tl.getProvision();
            if (p == null || (provisionTransaction = provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null) continue;
            String grossPSClassification = provisionTransaction.getProvisionGrossPSClassification();
            if (grossPSClassification != null) {
                Double total = totals.get(grossPSClassification);
                if (total == null) {
                    total = 0.0;
                }
                total = total + amount;
                totals.put(grossPSClassification, total);
            }
            if ((taxPSClassification = provisionTransaction.getProvisionTaxPSClassification()) == null) continue;
            Double total = totals.get(taxPSClassification);
            if (total == null) {
                total = 0.0;
            }
            total = total - provisionAmount;
            totals.put(taxPSClassification, total);
        }
        return totals;
    }

    public void assignUUIDToTransactionNumber() throws Exception {
        String transactionNumber = this.getTransactionNumber();
        if (transactionNumber == null || transactionNumber.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionNumber");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    public ActivityStatement getActivityStatement() {
        TransactionLine tl = this.getTransactionLine(0);
        if (tl == null) {
            return null;
        }
        return tl.getActivityStatement();
    }

    public String getActivityStatementNumber() {
        ActivityStatement as = this.getActivityStatement();
        if (as == null) {
            return null;
        }
        return as.getActivityStatementNumber();
    }

    public void setActivityStatementNumber(String asNumber) throws Exception {
        ActivityStatement as = this.getActivityStatement();
        if (as == null) {
            throw new Exception("Error, no activity statement cannot set as number.");
        }
        as.setActivityStatementNumber(asNumber);
    }

    public void setProvisionMasterfileCached(GlenixTrnXBRL provisionTrnXBRL) {
        this.provisionTrnXBRL = provisionTrnXBRL;
    }

    public Double getProvisionGrossBASTotalAmount(String provisionGrossBASClassification) {
        if (provisionGrossBASClassification == null || provisionGrossBASClassification.isEmpty()) {
            return null;
        }
        Double result = null;
        String transactionType = this.getTransactionType();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String grossBASClassification;
            String pi;
            Transaction provisionTransaction;
            Provision p;
            TransactionLine tl = this.getTransactionLine(i);
            Double amount = tl.getAmountAsDouble();
            if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                amount = -amount.doubleValue();
            }
            if ((p = tl.getProvision()) == null || (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null || (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) == null || !grossBASClassification.equals(provisionGrossBASClassification)) continue;
            if (result == null) {
                result = 0.0;
            }
            result = result + amount;
        }
        return result;
    }

    public Double getBASGrossPurchasesAmount() {
        Double result = null;
        String transactionType = this.getTransactionType();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String grossBASClassification;
            String pi;
            Transaction provisionTransaction;
            Provision p;
            TransactionLine tl = this.getTransactionLine(i);
            Double amount = tl.getAmountAsDouble();
            if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                amount = -amount.doubleValue();
            }
            if ((p = tl.getProvision()) == null || (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null || (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) == null || !grossBASClassification.equals("Capital_Purchases") && !grossBASClassification.equals("Non_Capital_Purchases") && !grossBASClassification.equals("Purchases_for_Input_Taxed_Sales") && !grossBASClassification.equals("Purchases_for_Input_Taxed_Sales_Capital") && !grossBASClassification.equals("GST_Free_Purchases") && !grossBASClassification.equals("GST_Free_Purchases_Capital") && !grossBASClassification.equals("Purchase_Adjustments")) continue;
            if (result == null) {
                result = 0.0;
            }
            result = result + amount;
        }
        return result;
    }

    public Double getBASGrossSalesAmount() {
        Double result = null;
        String transactionType = this.getTransactionType();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String grossBASClassification;
            String pi;
            Transaction provisionTransaction;
            Provision p;
            TransactionLine tl = this.getTransactionLine(i);
            Double amount = tl.getAmountAsDouble();
            if (!(transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
                amount = -amount.doubleValue();
            }
            if ((p = tl.getProvision()) == null || (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null || (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) == null || !grossBASClassification.equals("GST_Taxable_Sales") && !grossBASClassification.equals("Export_Sales") && !grossBASClassification.equals("Input_Taxed_Sales") && !grossBASClassification.equals("Sales_Adjustments") && !grossBASClassification.equals("GST_Free_Sales")) continue;
            if (result == null) {
                result = 0.0;
            }
            result = result + amount;
        }
        return result;
    }

    public Double getGstTaxableSales() {
        return this.getBASGrossSalesAmount();
    }

    public Double getGstTaxablePurchases() {
        return this.getBASGrossPurchasesAmount();
    }

    public Double getSalariesAndWages() {
        return this.getProvisionGrossBASTotalAmount("Salaries_and_Wages");
    }

    public Double getProvisionTaxBASTotalAmount(String provisionTaxBASClassification) {
        if (provisionTaxBASClassification == null || provisionTaxBASClassification.isEmpty()) {
            return null;
        }
        Double result = null;
        String transactionType = this.getTransactionType();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String taxBASClassification;
            String pi;
            Transaction provisionTransaction;
            Provision p;
            TransactionLine tl = this.getTransactionLine(i);
            Double provisionAmount = tl.getProvisionAmountAsDouble();
            if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                provisionAmount = -provisionAmount.doubleValue();
            }
            if ((p = tl.getProvision()) == null || (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null || (taxBASClassification = provisionTransaction.getProvisionTaxBASClassification()) == null || !taxBASClassification.equals(provisionTaxBASClassification)) continue;
            if (result == null) {
                result = 0.0;
            }
            result = result + provisionAmount;
        }
        return result;
    }

    public Double getGstPayable() {
        Double result = this.getProvisionTaxBASTotalAmount("GST_Payable");
        if (result == null) {
            return null;
        }
        return -result.doubleValue();
    }

    public Double getGstReceivable() {
        return this.getProvisionTaxBASTotalAmount("GST_Receivable");
    }

    public Double getPaygWithholdingPayable() {
        return this.getProvisionTaxBASTotalAmount("PAYG_Withholding_Payable");
    }

    public Double getProvisionGrossPSTotalAmount(String provisionGrossPSClassification) {
        if (provisionGrossPSClassification == null || provisionGrossPSClassification.isEmpty()) {
            return null;
        }
        Double result = null;
        String transactionType = this.getTransactionType();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String grossPSClassification;
            String pi;
            Transaction provisionTransaction;
            Provision p;
            TransactionLine tl = this.getTransactionLine(i);
            Double amount = tl.getAmountAsDouble();
            if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                amount = -amount.doubleValue();
            }
            if ((p = tl.getProvision()) == null || (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null || (grossPSClassification = provisionTransaction.getProvisionGrossPSClassification()) == null || !grossPSClassification.equals(provisionGrossPSClassification)) continue;
            if (result == null) {
                result = 0.0;
            }
            result = result + amount;
        }
        return result;
    }

    public Double getProvisionTaxPSTotalAmount(String provisionTaxPSClassification) {
        if (provisionTaxPSClassification == null || provisionTaxPSClassification.isEmpty()) {
            return null;
        }
        Double result = null;
        String transactionType = this.getTransactionType();
        int lineCount = this.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            String taxPSClassification;
            String pi;
            Transaction provisionTransaction;
            Provision p;
            TransactionLine tl = this.getTransactionLine(i);
            Double provisionAmount = tl.getProvisionAmountAsDouble();
            if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                provisionAmount = -provisionAmount.doubleValue();
            }
            if ((p = tl.getProvision()) == null || (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi = p.getProvisionIdentifier())) == null || (taxPSClassification = provisionTransaction.getProvisionTaxPSClassification()) == null || !taxPSClassification.equals(provisionTaxPSClassification)) continue;
            if (result == null) {
                result = 0.0;
            }
            result = result + provisionAmount;
        }
        return result;
    }

    public TransactionTransactionLine buildTransactionTranscationLine(int line) {
        if (line < this.getTransactionLineCount()) {
            return new TransactionTransactionLine(line);
        }
        return null;
    }

    public boolean usesAccountIdentifier(String accountIdentifier) {
        if (accountIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionLine t = (TransactionLine)glenixElementChildList.getChild(i);
            String tai = t.getAccountIdentifier();
            if (tai == null || !tai.equals(accountIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean usesHomeOfficeIdentifier(String homeOfficeIdentifier) {
        if (homeOfficeIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionLine t = (TransactionLine)glenixElementChildList.getChild(i);
            String tai = t.getHomeOfficeIdentifier();
            if (tai == null || !tai.equals(homeOfficeIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean usesFuelTaxCreditIdentifier(String fuelTaxCreditIdentifier) {
        if (fuelTaxCreditIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionLine t = (TransactionLine)glenixElementChildList.getChild(i);
            String tai = t.getFuelTaxCreditIdentifier();
            if (tai == null || !tai.equals(fuelTaxCreditIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean usesImportDataIdentifier(String importDataIdentifier) {
        if (importDataIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionLine t = (TransactionLine)glenixElementChildList.getChild(i);
            String tai = t.getImportDataIdentifier();
            if (tai == null || !tai.equals(importDataIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean usesProvisionIdentifier(String provisionIdentifier) {
        if (provisionIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionLine t = (TransactionLine)glenixElementChildList.getChild(i);
            String tai = t.getProvisionIdentifier();
            if (tai == null || !tai.equals(provisionIdentifier)) continue;
            return true;
        }
        return false;
    }

    public String getDocumentID() {
        PEE0003Payee p = this.getTransactionPayEventEmp();
        if (p == null) {
            return null;
        }
        return p.getDocumentID();
    }

    public void setDocumentID(String value) throws Exception {
        PEE0003Payee p = this.getTransactionPayEventEmp();
        if (p == null) {
            throw new Exception("Error, there is no Employee Pay Event, cannot set document ID");
        }
        p.setDocumentID(value);
    }

    public void loadFasV2ProvisionList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("taxMaster")) {
            TransactionLine tl = (TransactionLine)this.getOrAddChild("transactionLine");
            tl.loadFasV2ProvisionList(doc, element);
        }
    }

    public void loadFasV2AccountList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("account")) {
            TransactionLine tl = (TransactionLine)this.getOrAddChild("transactionLine");
            tl.loadFasV2AccountList(doc, element);
        }
    }

    public void loadFasV2AccountListMeasurable(Document doc, Element element, Business business) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("measurableMaster")) {
            TransactionLine tl = (TransactionLine)this.getOrAddChild("transactionLine");
            tl.loadFasV2AccountListMeasurable(doc, element, business);
        }
    }

    public void loadFasV2CounterpartyList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("identifierReference")) {
            Counterparty c = (Counterparty)this.getOrAddChild("counterparty");
            c.loadFasV2CounterpartyList(doc, element);
        }
    }

    public void loadFasV2ActivityStatement(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("SBRDocumentAS")) {
            TransactionLine tl = (TransactionLine)this.getOrAddChild("transactionLine");
            tl.loadFasV2ActivityStatement(doc, element);
        }
    }

    public void loadFasV2Transactions(Document doc, Element element, boolean has_general_journal_type) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("entryHeader")) {
            NodeList nodeList = element.getChildNodes();
            boolean ispayslip = false;
            boolean hasbatch = false;
            String postingDate = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("entryDetail")) {
                    TransactionLine transactionLine = null;
                    boolean hasacct = false;
                    boolean hasmeas = false;
                    boolean hastaxes = false;
                    boolean haslinenumber = false;
                    NodeList nodeList2 = el.getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Node node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1) continue;
                        Element el2 = (Element)node2;
                        if (el2.getLocalName().equals("lineNumber")) {
                            String lineNumber = el2.getTextContent();
                            if (lineNumber == null || lineNumber.isEmpty()) continue;
                            transactionLine = this.getTransactionLineByLineNumber(el2.getTextContent());
                            haslinenumber = true;
                            continue;
                        }
                        if (el2.getLocalName().equals("account")) {
                            hasacct = true;
                            continue;
                        }
                        if (el2.getLocalName().equals("measurable")) {
                            hasmeas = true;
                            continue;
                        }
                        if (!el2.getLocalName().equals("taxes")) continue;
                        hastaxes = true;
                    }
                    if (!haslinenumber && !hasacct && !hasmeas && !hastaxes) continue;
                    if (transactionLine == null) {
                        transactionLine = this.addBlankTransactionLine();
                    }
                    transactionLine.loadFasV2Transactions(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("entryNumber")) {
                    gse = (GlenixStringElement)this.getOrAddChild("transactionNumber");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("AIEntryNumber")) {
                    gse = (GlenixStringElement)this.getOrAddChild("AITransactionNumber");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("entryReconciliationReference")) {
                    gse = (GlenixStringElement)this.getOrAddChild("transactionReconciliationNumber");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("sourceJournalID")) {
                    gse = (GlenixStringElement)this.getOrAddChild("transactionType");
                    String sjid = el.getTextContent();
                    if (sjid != null) {
                        if (sjid.equals("sj")) {
                            gse.setGlenixElementValue("sales_invoice");
                        } else if (sjid.equals("cr")) {
                            gse.setGlenixElementValue("cash_received");
                        } else if (sjid.equals("pj")) {
                            gse.setGlenixElementValue("purchase_invoice");
                        } else if (sjid.equals("cd")) {
                            gse.setGlenixElementValue("cash_payment");
                        } else if (sjid.equals("pl")) {
                            gse.setGlenixElementValue("pay_slip");
                            ispayslip = true;
                        } else if (sjid.equals("gj")) {
                            if (has_general_journal_type) {
                                gse.setGlenixElementValue("general_journal");
                            } else {
                                gse.setGlenixElementValue("cash_payment");
                            }
                        } else if (sjid.equals("ot") && has_general_journal_type) {
                            gse.setGlenixElementValue("reconciliation");
                        }
                    }
                    gse = (GlenixStringElement)this.getOrAddChild("transactionStatus");
                    gse.setGlenixElementValue("posted");
                    continue;
                }
                if (el.getLocalName().equals("postingDate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("transactionDate");
                    postingDate = el.getTextContent();
                    gse.setGlenixElementValue(postingDate);
                    continue;
                }
                if (el.getLocalName().equals("entryComment")) {
                    gse = (GlenixStringElement)this.getOrAddChild("transactionComment");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("identifierReference")) {
                    Counterparty c = (Counterparty)this.getOrAddChild("counterparty");
                    c.loadFasV2Transactions(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("batch")) {
                    Batch b = (Batch)this.getOrAddChild("batch");
                    b.loadFasV2Transactions(doc, el);
                    hasbatch = true;
                    continue;
                }
                if (el.getLocalName().equals("entryPaySlipDetail")) {
                    TransactionPaySlipDetail ps = (TransactionPaySlipDetail)this.getOrAddChild("transactionPaySlipDetail");
                    ps.loadFasV2Transactions(doc, el);
                    continue;
                }
                if (!el.getLocalName().equals("entryTaxDetails")) continue;
                TransactionProvisionDetails pd = (TransactionProvisionDetails)this.getOrAddChild("transactionProvisionDetails");
                pd.loadFasV2Transactions(doc, el);
            }
            if (ispayslip && !hasbatch) {
                Batch b = (Batch)this.getOrAddChild("batch");
                b.setBatchIdentifier("payslip_date_" + postingDate);
            }
        }
    }

    public void loadFasV2Batches(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("batch")) {
            Batch b = (Batch)this.getOrAddChild("batch");
            b.loadFasV2Batches(doc, element);
        }
    }

    public void loadFasV2AddPaySlipBatches(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("entryHeader")) {
            boolean ispayslip = false;
            boolean hasbatch = false;
            String postingDate = null;
            String postingStatus = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("sourceJournalID")) {
                    String sjid = el.getTextContent();
                    if (sjid == null || !sjid.equals("pl")) continue;
                    ispayslip = true;
                    continue;
                }
                if (el.getLocalName().equals("postingDate")) {
                    postingDate = el.getTextContent();
                    continue;
                }
                if (el.getLocalName().equals("postingStatus")) {
                    postingStatus = el.getTextContent();
                    continue;
                }
                if (!el.getLocalName().equals("batch")) continue;
                hasbatch = true;
            }
            if (ispayslip && !hasbatch && postingStatus != null && postingStatus.equals("posted") && postingDate != null && !postingDate.isEmpty()) {
                Batch b = (Batch)this.getOrAddChild("batch");
                b.loadFasV2AddPaySlipBatches(postingDate);
            }
        }
    }

    public String getTransactionReconciliationNumber() {
        return this.getChildValue("transactionReconciliationNumber");
    }

    public void setTransactionReconciliationNumber(String value) throws Exception {
        this.setChildValue("transactionReconciliationNumber", value);
    }

    public String getTransactionReconciliationMaxDate() {
        return this.getChildValue("transactionReconciliationMaxDate");
    }

    public LocalDate getTransactionReconciliationMaxDateAsDate() {
        String val = this.getChildValue("transactionReconciliationMaxDate");
        if (val == null || val.isEmpty()) {
            return null;
        }
        return LocalDate.parse(val, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public String getTransactionReconciliationAmount() {
        return this.getChildValue("transactionReconciliationAmount");
    }

    public String getTransactionReconciliationDetails() {
        String recDet = this.getTransactionReconciliationNumber();
        LocalDate ld = this.getTransactionReconciliationMaxDateAsDate();
        if (ld != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ")";
        }
        return recDet;
    }

    private String formatTwoDp(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.formatTwoDp.format(amount);
    }

    public String getTransactionReconciliationDetailsAndAmount() {
        String recDet = this.getTransactionReconciliationNumber();
        LocalDate ld = this.getTransactionReconciliationMaxDateAsDate();
        Double amt = this.getTransactionReconciliationAmountAsDouble();
        if (ld != null && amt != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ", " + this.formatTwoDp(amt) + ")";
        }
        return recDet;
    }

    public String getTransactionReconciliationDetailsAndCreditAmount() {
        String recDet = this.getTransactionReconciliationNumber();
        LocalDate ld = this.getTransactionReconciliationMaxDateAsDate();
        Double amt = this.getTransactionReconciliationAmountAsDouble();
        if (ld != null && amt != null) {
            recDet = recDet + " (" + this.outputDateFormatter.format(ld) + ", " + this.formatTwoDp(-amt.doubleValue()) + ")";
        }
        return recDet;
    }

    public Double getTransactionReconciliationAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("transactionReconciliationAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public Double getTransactionCreditReconciliationAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("transactionReconciliationAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return -Double.parseDouble(val);
    }

    public String getDocumentNumber() {
        return this.getChildValue("documentNumber");
    }

    public String getDocumentDate() {
        return this.getChildValue("documentDate");
    }

    public String getDueDate() {
        return this.getChildValue("dueDate");
    }

    public HomeOffice getHomeOffice() {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            return null;
        }
        return tl.getHomeOffice();
    }

    public HomeOffice getOrAddHomeOffice() throws Exception {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            tl = this.addBlankTransactionLine();
        }
        if (tl == null) {
            return null;
        }
        return tl.getOrAddHomeOffice();
    }

    public String getHomeOfficeIdentifier() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeIdentifier();
    }

    public String getHomeOfficeFullAddress() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getFullAddress();
    }

    public String getHomeOfficeStartDate() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeStartDate();
    }

    public String getHomeOfficeEndDate() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeEndDate();
    }

    public String getHomeOfficeWeeksUnused() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeWeeksUnused();
    }

    public String getHomeOfficeFloorArea() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeFloorArea();
    }

    public String getHomeOfficeHomeTotalArea() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeHomeTotalArea();
    }

    public String getHomeOfficeComment() {
        HomeOffice ho = this.getHomeOffice();
        if (ho == null) {
            return null;
        }
        return ho.getHomeOfficeComment();
    }

    public FuelTaxCredit getFuelTaxCredit() {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            return null;
        }
        return tl.getFuelTaxCredit();
    }

    public String getFuelTaxCreditIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditIdentifier();
    }

    public String getFuelTaxCreditComment() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditComment();
    }

    public String getFuelTaxCreditAccountIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditAccountIdentifier();
    }

    public String getFTCProvisionIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFTCProvisionIdentifier();
    }

    public String getFTCOverclaimedProvisionIdentifier() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFTCOverclaimedProvisionIdentifier();
    }

    public String getFuelTaxCreditUsageType() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditUsageType();
    }

    public String getFuelTaxCreditFuelType() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditFuelType();
    }

    public String getFuelTaxCreditOverrideRate() {
        FuelTaxCredit ho = this.getFuelTaxCredit();
        if (ho == null) {
            return null;
        }
        return ho.getFuelTaxCreditOverrideRate();
    }

    public ImportData getFirstImportData() {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            return null;
        }
        return tl.getImportData();
    }

    public ImportData getOrAddFirstImportData() throws Exception {
        TransactionLine tl = this.getFirstTransactionLine();
        if (tl == null) {
            tl = this.addBlankTransactionLine();
        }
        return tl.getOrAddImportData();
    }

    public String getFirstImportDataIdentifier() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataIdentifier();
    }

    public void setFirstImportDataIdentifier(String value) throws Exception {
        if (value == null) {
            TransactionLine tl = this.getFirstTransactionLine();
            if (tl == null) {
                return;
            }
            tl.setImportDataIdentifier(value);
            return;
        }
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataIdentifier(value);
        }
    }

    public String getFirstImportDataFileName() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataFileName();
    }

    public void setFirstImportDataFileName(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataFileName(value);
        }
    }

    public String getFirstImportDataTransactionReference() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataTransactionReference();
    }

    public void setFirstImportDataTransactionReference(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataTransactionReference(value);
        }
    }

    public String getFirstImportDataTransactionType() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataTransactionType();
    }

    public void setFirstImportDataTransactionType(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataTransactionType(value);
        }
    }

    public String getFirstImportDataDate() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataDate();
    }

    public LocalDate getFirstImportDataDateAsDate() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        String date = ho.getImportDataDate();
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFirstImportDataDate(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataDate(value);
        }
    }

    public String getFirstImportDataCounterparty() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataCounterparty();
    }

    public void setFirstImportDataCounterparty(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataCounterparty(value);
        }
    }

    public String getFirstImportDataComment() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataComment();
    }

    public void setFirstImportDataComment(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataComment(value);
        }
    }

    public String getFirstImportDataAmount() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataAmount();
    }

    public Double getCreditTotalImportDataAmount() {
        Double amount = this.getTotalImportDataAmount();
        if (amount == null || amount.equals(0.0)) {
            return amount;
        }
        String transactionType = this.getTransactionType();
        if (transactionType != null && (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            return amount;
        }
        return -amount.doubleValue();
    }

    public Double getTotalImportDataAmount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return 0.0;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                Double amount = tl.getImportDataAmountAsDouble();
                if (amount == null) continue;
                total = total == null ? amount : Double.valueOf(total + amount);
            }
            return total;
        }
        return null;
    }

    public void setFirstImportDataAmount(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataAmount(value);
        }
    }

    public Double getTotalImportDataQuantity() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return 0.0;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                Double qty = tl.getImportDataQuantityAsDouble();
                if (qty == null) continue;
                total = total == null ? qty : Double.valueOf(total + qty);
            }
            return total;
        }
        return null;
    }

    public String getFirstImportDataQuantity() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataQuantity();
    }

    public Double getFirstImportDataQuantityAsDouble() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataQuantityAsDouble();
    }

    public void setFirstImportDataQuantity(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataQuantity(value);
        }
    }

    public Double getTotalImportDataProvisionAmount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return 0.0;
            }
            Double total = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
                Double amount = tl.getImportDataProvisionAmountAsDouble();
                if (amount == null) continue;
                total = total == null ? amount : Double.valueOf(total + amount);
            }
            return total;
        }
        return null;
    }

    public Double getFirstImportDataProvisionAmountAsDouble() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataProvisionAmountAsDouble();
    }

    public void setFirstImportDataProvisionAmount(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataProvisionAmount(value);
        }
    }

    public String getFirstImportDataAccount() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataAccount();
    }

    public void setFirstImportDataAccount(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataAccount(value);
        }
    }

    public String getUniqueImportDataAccount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(0);
            if (tl == null) {
                return null;
            }
            String ida = tl.getImportDataAccount();
            if (ida == null || ida.isEmpty()) {
                return null;
            }
            boolean diffid = false;
            for (int i = 1; i < glenixElementChildList.getChildCount(); ++i) {
                tl = (TransactionLine)glenixElementChildList.getChild(i);
                if (tl == null) {
                    return null;
                }
                String thisIda = tl.getImportDataAccount();
                if (thisIda == null || thisIda.isEmpty()) {
                    return null;
                }
                if (ida.equals(thisIda)) continue;
                diffid = true;
            }
            if (diffid) {
                return "Multiple accounts";
            }
            return ida;
        }
        return null;
    }

    public String getFirstImportDataProvision() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataProvision();
    }

    public void setFirstImportDataProvision(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataProvision(value);
        }
    }

    public String getUniqueImportDataProvision() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(0);
            if (tl == null) {
                return null;
            }
            String ida = tl.getImportDataProvision();
            if (ida == null || ida.isEmpty()) {
                return null;
            }
            boolean diffid = false;
            for (int i = 1; i < glenixElementChildList.getChildCount(); ++i) {
                tl = (TransactionLine)glenixElementChildList.getChild(i);
                if (tl == null) {
                    return null;
                }
                String thisIda = tl.getImportDataProvision();
                if (thisIda == null || thisIda.isEmpty()) {
                    return null;
                }
                if (ida.equals(thisIda)) continue;
                diffid = true;
            }
            if (diffid) {
                return "Multiple provisions";
            }
            return ida;
        }
        return null;
    }

    public String getFirstImportDataBankAccount() {
        ImportData ho = this.getFirstImportData();
        if (ho == null) {
            return null;
        }
        return ho.getImportDataBankAccount();
    }

    public void setFirstImportDataBankAccount(String value) throws Exception {
        ImportData ho = this.getOrAddFirstImportData();
        if (ho != null) {
            ho.setImportDataBankAccount(value);
        }
    }

    public void deleteImportDataTransactionLines(String importDataIdentifier) throws Exception {
        if (importDataIdentifier == null || importDataIdentifier.isEmpty()) {
            throw new Exception("Error, cannot delete import data transaction line specified import data identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete import data transaction line as cannot get transaction list");
        }
        ArrayList<TransactionLine> al = new ArrayList<TransactionLine>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionLine tl = (TransactionLine)glenixElementChildList.getChild(i);
            String tai = tl.getImportDataIdentifier();
            if (tai == null || !tai.equals(importDataIdentifier)) continue;
            al.add(tl);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public void removeMasterFileInformation() {
        Batch bat;
        Counterparty c = this.getCounterparty();
        if (c != null) {
            c.removeMasterFileInformation();
        }
        if ((bat = this.getBatch()) != null) {
            bat.removeMasterFileInformation();
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transactionLine");
        for (GlenixElement ge : glenixElementChildList.getList()) {
            ((TransactionLine)ge).removeMasterFileInformation();
        }
    }

    public class TransactionTransactionLine {
        int line;

        public TransactionTransactionLine(int line) {
            this.line = line;
        }

        public int getLineNumberAsInt() {
            return this.line;
        }

        public String getCounterpartyIdentifier() {
            return Transaction.this.getCounterpartyIdentifier();
        }

        public void setCounterpartyIdentifier(String value) throws Exception {
            Transaction.this.setCounterpartyIdentifier(value);
        }

        public String getImportDataCounterparty() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataCounterparty();
        }

        public String getProvisionIdentifier() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            Provision p = tl.getProvision();
            if (p == null) {
                return null;
            }
            return p.getProvisionIdentifier();
        }

        public void setProvisionIdentifier(String value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            Provision p = tl.getOrAddProvision();
            if (p == null) {
                return;
            }
            p.setProvisionIdentifier(value);
        }

        public void removeProvision() throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.removeProvision();
        }

        public String getImportDataProvision() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataProvision();
        }

        public Provision getProvision() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvision();
        }

        public String getAccountIdentifier() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            Account a = tl.getAccount();
            if (a == null) {
                return null;
            }
            return a.getAccountIdentifier();
        }

        public void setAccountIdentifier(String value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                System.out.println("TL is null");
                return;
            }
            Account a = tl.getOrAddAccount();
            if (a == null) {
                System.out.println("TL acc is null");
                return;
            }
            a.setAccountIdentifier(value);
        }

        public void removeAccount() throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.removeAccount();
        }

        public String getImportDataAccount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataAccount();
        }

        public Account getAccount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getAccount();
        }

        public LocalDate getTransactionDateAsDate() {
            return Transaction.this.getTransactionDateAsDate();
        }

        public void setTransactionDate(String value) throws Exception {
            Transaction.this.setTransactionDate(value);
        }

        public LocalDate getImportDataDateAsDate() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataDateAsDate();
        }

        public String getTransactionType() {
            return Transaction.this.getTransactionType();
        }

        public void setTransactionType(String value) throws Exception {
            Transaction.this.setTransactionType(value);
        }

        public String getActivityStatementNumber() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getActivityStatementNumber();
        }

        public SimpleStringProperty getActivityStatementNumberProperty() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getActivityStatementNumberProperty();
        }

        public String getTransactionStatus() {
            return Transaction.this.getTransactionStatus();
        }

        public String getTransactionNumber() {
            return Transaction.this.getTransactionNumber();
        }

        public String getLineNumber() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getLineNumber();
        }

        public String getTransactionComment() {
            return Transaction.this.getTransactionComment();
        }

        public String getImportDataComment() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataComment();
        }

        public Transaction getTransaction() {
            return Transaction.this;
        }

        public String getTransactionCommentLineComment() {
            String tc = Transaction.this.getTransactionComment();
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return tc;
            }
            String tlc = tl.getLineCommentString();
            if (tc == null || tc.isEmpty()) {
                return tlc;
            }
            if (tlc == null || tlc.isEmpty()) {
                return tc;
            }
            return tc + " - " + tlc;
        }

        public void setLineComment(String value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.setLineComment(value);
        }

        public Double getAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getAmountAsDouble();
        }

        public void setAmount(Double value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.setAmount(value);
        }

        public Double getDebitAmount() {
            Double result = this.getAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return -result.doubleValue();
            }
            return result;
        }

        public Double getCreditAmount() {
            Double result = this.getAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return result;
            }
            return -result.doubleValue();
        }

        public Double getImportDataAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataAmountAsDouble();
        }

        public Double getCreditImportDataAmount() {
            Double result = this.getImportDataAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return result;
            }
            return -result.doubleValue();
        }

        public Double getProvisionAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionAmountAsDouble();
        }

        public String getProvisionAmountString() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionAmountString();
        }

        public void setProvisionAmount(Double value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.setProvisionAmount(value);
        }

        public Double getDebitProvisionAmount() {
            Double result = this.getProvisionAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return -result.doubleValue();
            }
            return result;
        }

        public Double getCreditProvisionAmount() {
            Double result = this.getProvisionAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return result;
            }
            return -result.doubleValue();
        }

        public Double getImportDataProvisionAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataProvisionAmountAsDouble();
        }

        public Double getCreditImportDataProvisionAmount() {
            Double result = this.getImportDataProvisionAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return result;
            }
            return -result.doubleValue();
        }

        public Double getQuantity() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getQuantityAsDouble();
        }

        public void setQuantity(Double value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.setQuantity(value);
        }

        public Double getDebitQuantity() {
            Double result = this.getQuantity();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return -result.doubleValue();
            }
            return result;
        }

        public Double getCreditQuantity() {
            Double result = this.getQuantity();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return result;
            }
            return -result.doubleValue();
        }

        public Double getImportDataQuantity() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataQuantityAsDouble();
        }

        public Double getCreditImportDataQuantity() {
            Double result = this.getImportDataQuantity();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return result;
            }
            return -result.doubleValue();
        }

        public Double getNetAmount() {
            Double amount = this.getAmount();
            Double provisionAmount = this.getProvisionAmount();
            if (amount == null && provisionAmount == null) {
                return null;
            }
            if (provisionAmount == null) {
                return amount;
            }
            if (amount == null) {
                return -provisionAmount.doubleValue();
            }
            return amount - provisionAmount;
        }

        public Double getDebitNetAmount() {
            Double result = this.getNetAmount();
            if (result == null || result == 0.0) {
                return result;
            }
            String tt = Transaction.this.getTransactionType();
            if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                return -result.doubleValue();
            }
            return result;
        }

        public void setActivityStatementNumber(String asNumber) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return;
            }
            tl.setActivityStatementNumber(asNumber);
        }

        public ImportData getImportData() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportData();
        }

        public String getImportDataIdentifier() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataIdentifier();
        }

        public void setImportDataIdentifier(String value) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                throw new Exception("Transaction line is null cannot set import data identifier");
            }
            tl.setImportDataIdentifier(value);
        }

        public void deleteImportData() throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                throw new Exception("Transaction line is null cannot delete import data");
            }
            tl.deleteImportData();
        }

        public void copyImportData(ImportData importData) throws Exception {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                throw new Exception("Transaction line is null cannot copy import data");
            }
            tl.copyImportData(importData);
        }

        public String getImportDataDate() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getImportDataDate();
        }

        public String getFirstImportDataTransactionType() {
            return Transaction.this.getFirstImportDataTransactionType();
        }

        public Double getTotalImportDataAmount() {
            return Transaction.this.getTotalImportDataAmount();
        }

        public String getBatchIdentifier() {
            return Transaction.this.getBatchIdentifier();
        }

        public String getReconciliationNumber() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getReconciliationNumber();
        }

        public Integer getReconciliationNumberAsInt() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getReconciliationNumberAsInt();
        }

        public Double getReconciliationAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getReconciliationAmountAsDouble();
        }

        public String getReconciliationDetailsAndAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getReconciliationDetailsAndAmount();
        }

        public String getReconciliationMaxDate() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getReconciliationMaxDate();
        }

        public LocalDate getReconciliationMaxDateAsDate() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getReconciliationMaxDateAsDate();
        }

        public String getProvisionReconciliationNumber() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionReconciliationNumber();
        }

        public Integer getProvisionReconciliationNumberAsInt() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionReconciliationNumberAsInt();
        }

        public Double getProvisionReconciliationAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionReconciliationAmountAsDouble();
        }

        public String getProvisionReconciliationDetailsAndAmount() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionReconciliationDetailsAndAmount();
        }

        public String getProvisionReconciliationMaxDate() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionReconciliationMaxDate();
        }

        public LocalDate getProvisionReconciliationMaxDateAsDate() {
            TransactionLine tl = Transaction.this.getTransactionLine(this.line);
            if (tl == null) {
                return null;
            }
            return tl.getProvisionReconciliationMaxDateAsDate();
        }

        public int compareTo(TransactionTransactionLine rr2) {
            Transaction t2;
            Transaction t1;
            String rr1date = this.getReconciliationMaxDate();
            String rr2date = rr2.getReconciliationMaxDate();
            if (rr1date == null || rr1date.isEmpty()) {
                if (rr2date != null && !rr2date.isEmpty()) {
                    return -1;
                }
            } else {
                if (rr2date == null || rr2date.isEmpty()) {
                    return 1;
                }
                int result = rr1date.compareTo(rr2date);
                if (result != 0) {
                    return result;
                }
            }
            Integer rr1Int = this.getReconciliationNumberAsInt();
            Integer rr2Int = rr2.getReconciliationNumberAsInt();
            if (rr1Int == null) {
                if (rr2Int != null) {
                    return -1;
                }
            } else {
                if (rr2Int == null) {
                    return 1;
                }
                int result = rr1Int.compareTo(rr2Int);
                if (result != 0) {
                    return result;
                }
            }
            if ((t1 = this.getTransaction()) == (t2 = rr2.getTransaction())) {
                int tl1line = this.getLineNumberAsInt();
                int tl2line = rr2.getLineNumberAsInt();
                return tl1line - tl2line;
            }
            String t1date = t1.getTransactionDate();
            String t2date = t2.getTransactionDate();
            if (t1date == null || t1date.isEmpty()) {
                if (t2date != null && !t2date.isEmpty()) {
                    return -1;
                }
            } else {
                if (t2date == null || t2date.isEmpty()) {
                    return 1;
                }
                int result = t1date.compareTo(t2date);
                if (result != 0) {
                    return result;
                }
            }
            String t1comment = t1.getTransactionComment();
            String t2comment = t2.getTransactionComment();
            if (t1comment == null || t1comment.isEmpty()) {
                if (t2comment != null && !t2comment.isEmpty()) {
                    return -1;
                }
            } else {
                if (t2comment == null || t2comment.isEmpty()) {
                    return 1;
                }
                int result = t1comment.compareTo(t2comment);
                if (result != 0) {
                    return result;
                }
            }
            return this.toString().compareTo(rr2.toString());
        }
    }
}

