/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.util.HashMap;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TFND0004AddressDetailsBusiness
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private HashMap<String, String> countries = null;

    public TFND0004AddressDetailsBusiness(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext) throws Exception {
        this.name = name;
        this.namespace = namespace;
        this.sbrName = sbrName;
        this.sbrNamespace = sbrNamespace;
        this.sbrContext = sbrContext;
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("Line1T", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Line1T", "http://www.sbr.gov.au/ato/tfnd", "Line1T", sbrContext, 1, true));
        this.childrenAndMeta.put("Line2T", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Line2T", "http://www.sbr.gov.au/ato/tfnd", "Line2T", sbrContext, 1, true));
        this.childrenAndMeta.put("LocalityNameT", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "LocalityNameT", "http://www.sbr.gov.au/ato/tfnd", "LocalityNameT", sbrContext, 1, true));
        this.childrenAndMeta.put("PostcodeT", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "PostcodeT", "http://www.sbr.gov.au/ato/tfnd", "PostcodeT", sbrContext, 1, true));
        this.childrenAndMeta.put("StateOrTerritoryC", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "StateOrTerritoryC", "http://www.sbr.gov.au/ato/tfnd", "StateOrTerritoryC", sbrContext, 1, true));
        this.childrenAndMeta.put("CountryC", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "CountryC", "http://www.sbr.gov.au/ato/tfnd", "CountryC", sbrContext, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public String getLine1T() {
        return this.getChildValue("Line1T");
    }

    public SimpleStringProperty getLine1TProperty() {
        return this.getChildProperty("Line1T");
    }

    public String getLine2T() {
        return this.getChildValue("Line2T");
    }

    public SimpleStringProperty getLine2TProperty() {
        return this.getChildProperty("Line2T");
    }

    public String getLocalityNameT() {
        return this.getChildValue("LocalityNameT");
    }

    public SimpleStringProperty getLocalityNameTProperty() {
        return this.getChildProperty("LocalityNameT");
    }

    public String getPostcodeT() {
        return this.getChildValue("PostcodeT");
    }

    public SimpleStringProperty getPostcodeTProperty() {
        return this.getChildProperty("PostcodeT");
    }

    public String getStateOrTerritoryC() {
        return this.getChildValue("StateOrTerritoryC");
    }

    public SimpleStringProperty getStateOrTerritoryCProperty() {
        return this.getChildProperty("StateOrTerritoryC");
    }

    public String getCountryC() {
        return this.getChildValue("CountryC");
    }

    public SimpleStringProperty getCountryCProperty() {
        return this.getChildProperty("CountryC");
    }

    public void loadFasV2CounterpartyList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("identifierTFNDPayeeAddressDetails")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("AddressDetails.Line1.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Line1T");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("AddressDetails.Line2.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Line2T");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("AddressDetails.LocalityName.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("LocalityNameT");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("AddressDetails.StateOrTerritory.Code")) {
                    gse = (GlenixStringElement)this.getOrAddChild("StateOrTerritoryC");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("AddressDetails.Postcode.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("PostcodeT");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (!el.getLocalName().equals("AddressDetails.Country.Code")) continue;
                gse = (GlenixStringElement)this.getOrAddChild("CountryC");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public String getFullAddress() {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        String tmp = this.getLine1T();
        if (tmp != null && !tmp.isEmpty()) {
            sb.append(tmp);
            prefix = "\n";
        }
        if ((tmp = this.getLine2T()) != null && !tmp.isEmpty()) {
            sb.append(prefix);
            sb.append(tmp);
            prefix = "\n";
        }
        if ((tmp = this.getLocalityNameT()) != null && !tmp.isEmpty()) {
            sb.append(prefix);
            sb.append(tmp);
            prefix = " ";
        }
        if ((tmp = this.getStateOrTerritoryC()) != null && !tmp.isEmpty()) {
            sb.append(prefix);
            sb.append(tmp);
            prefix = " ";
        }
        if ((tmp = this.getPostcodeT()) != null && !tmp.isEmpty()) {
            sb.append(prefix);
            sb.append(tmp);
            prefix = "\n";
        } else if (!prefix.isEmpty()) {
            prefix = "\n";
        }
        tmp = this.getCountryC();
        if (tmp != null && !tmp.isEmpty()) {
            sb.append(prefix);
            sb.append(this.getCountryName(tmp));
        }
        return sb.toString();
    }

    private void initialiseCountries() {
        if (this.countries != null) {
            return;
        }
        this.countries = new HashMap();
        this.countries.put("au", "AUSTRALIA");
        this.countries.put("af", "AFGHANISTAN");
        this.countries.put("ax", "ALAND ISLANDS");
        this.countries.put("al", "ALBANIA");
        this.countries.put("dz", "ALGERIA");
        this.countries.put("as", "AMERICAN SAMOA");
        this.countries.put("ad", "ANDORRA");
        this.countries.put("ao", "ANGOLA");
        this.countries.put("ai", "ANGUILLA");
        this.countries.put("aq", "ANTARCTICA");
        this.countries.put("ag", "ANTIGUA AND BARBUDA");
        this.countries.put("ar", "ARGENTINA");
        this.countries.put("am", "ARMENIA");
        this.countries.put("aw", "ARUBA");
        this.countries.put("au", "AUSTRALIA");
        this.countries.put("at", "AUSTRIA");
        this.countries.put("az", "AZERBAIJAN");
        this.countries.put("bs", "BAHAMAS");
        this.countries.put("bh", "BAHRAIN");
        this.countries.put("bd", "BANGLADESH");
        this.countries.put("bb", "BARBADOS");
        this.countries.put("by", "BELARUS");
        this.countries.put("be", "BELGIUM");
        this.countries.put("bz", "BELIZE");
        this.countries.put("bj", "BENIN");
        this.countries.put("bm", "BERMUDA");
        this.countries.put("bt", "BHUTAN");
        this.countries.put("bo", "BOLIVIA");
        this.countries.put("bq", "BONAIRE,ST EUSTATIUS AND SABA ISLANDS");
        this.countries.put("ba", "BOSNIA AND HERZEGOVINA");
        this.countries.put("bw", "BOTSWANA");
        this.countries.put("bv", "BOUVET ISLAND");
        this.countries.put("br", "BRAZIL");
        this.countries.put("io", "BRITISH INDIAN OCEAN TERRITORY");
        this.countries.put("vg", "BRITISH VIRGIN ISLANDS");
        this.countries.put("bn", "BRUNEI DARUSSALAM");
        this.countries.put("bg", "BULGARIA");
        this.countries.put("bf", "BURKINA FASO");
        this.countries.put("bi", "BURUNDI");
        this.countries.put("kh", "CAMBODIA");
        this.countries.put("cm", "CAMEROON");
        this.countries.put("ca", "CANADA");
        this.countries.put("cv", "CAPE VERDE");
        this.countries.put("ky", "CAYMAN ISLANDS");
        this.countries.put("cf", "CENTRAL AFRICAN REPUBLIC");
        this.countries.put("td", "CHAD");
        this.countries.put("cl", "CHILE");
        this.countries.put("cn", "CHINA");
        this.countries.put("cx", "CHRISTMAS ISLAND");
        this.countries.put("cc", "COCOS (KEELING) ISLANDS");
        this.countries.put("co", "COLOMBIA");
        this.countries.put("km", "COMOROS");
        this.countries.put("cd", "CONGO, PEOPLE'S REPUBLIC OF");
        this.countries.put("cg", "CONGO, DEMOCRATIC REPUBLIC OF (WAS ZAIRE");
        this.countries.put("ck", "COOK ISLANDS");
        this.countries.put("cr", "COSTA RICA");
        this.countries.put("ci", "COTE D'IVOIRE (IVORY COAST)");
        this.countries.put("hr", "CROATIA (HRVATSKA)");
        this.countries.put("cu", "CUBA");
        this.countries.put("cw", "CURACAO");
        this.countries.put("cy", "CYPRUS");
        this.countries.put("cz", "CZECH REPUBLIC");
        this.countries.put("dk", "DENMARK");
        this.countries.put("dj", "DJIBOUTI");
        this.countries.put("dm", "DOMINICA");
        this.countries.put("do", "DOMINICAN REPUBLIC");
        this.countries.put("tl", "EAST TIMOR (TIMOR LESTE)");
        this.countries.put("ec", "ECUADOR");
        this.countries.put("eg", "EGYPT");
        this.countries.put("sv", "EL SALVADOR");
        this.countries.put("gq", "EQUATORIAL GUINEA");
        this.countries.put("er", "ERITREA");
        this.countries.put("ee", "ESTONIA");
        this.countries.put("et", "ETHIOPIA");
        this.countries.put("fk", "FALKLAND ISLANDS (MALVINAS)");
        this.countries.put("fo", "FAROE ISLANDS");
        this.countries.put("fj", "FIJI");
        this.countries.put("fi", "FINLAND");
        this.countries.put("fr", "FRANCE");
        this.countries.put("gf", "FRENCH GUIANA");
        this.countries.put("pf", "FRENCH POLYNESIA");
        this.countries.put("tf", "FRENCH SOUTHERN TERRITORIES");
        this.countries.put("ga", "GABON");
        this.countries.put("gm", "GAMBIA");
        this.countries.put("ge", "GEORGIA");
        this.countries.put("de", "GERMANY");
        this.countries.put("gh", "GHANA");
        this.countries.put("gi", "GIBRALTAR");
        this.countries.put("gr", "GREECE");
        this.countries.put("gl", "GREENLAND");
        this.countries.put("gd", "GRENADA");
        this.countries.put("gp", "GUADELOUPE");
        this.countries.put("gu", "GUAM");
        this.countries.put("gt", "GUATEMALA");
        this.countries.put("gg", "GUERNSEY");
        this.countries.put("gn", "GUINEA");
        this.countries.put("gw", "GUINEA-BISSAU");
        this.countries.put("gy", "GUYANA");
        this.countries.put("ht", "HAITI");
        this.countries.put("hm", "HEARD AND MCDONALD ISLANDS");
        this.countries.put("va", "HOLY SEE (VATICAN CITY STATE)");
        this.countries.put("hn", "HONDURAS");
        this.countries.put("hk", "HONG KONG");
        this.countries.put("hu", "HUNGARY");
        this.countries.put("is", "ICELAND");
        this.countries.put("in", "INDIA");
        this.countries.put("id", "INDONESIA");
        this.countries.put("ir", "IRAN");
        this.countries.put("iq", "IRAQ");
        this.countries.put("ie", "IRELAND");
        this.countries.put("im", "ISLE OF MAN, THE");
        this.countries.put("il", "ISRAEL");
        this.countries.put("it", "ITALY");
        this.countries.put("jm", "JAMAICA");
        this.countries.put("jp", "JAPAN");
        this.countries.put("je", "JERSEY");
        this.countries.put("jo", "JORDAN");
        this.countries.put("kz", "KAZAKHSTAN");
        this.countries.put("ke", "KENYA");
        this.countries.put("ki", "KIRIBATI");
        this.countries.put("kp", "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF (");
        this.countries.put("kr", "KOREA, REPUBLIC OF (SOUTH KOREA)");
        this.countries.put("kw", "KUWAIT");
        this.countries.put("kg", "KYRGYZSTAN");
        this.countries.put("la", "LAOS");
        this.countries.put("lv", "LATVIA");
        this.countries.put("lb", "LEBANON");
        this.countries.put("ls", "LESOTHO");
        this.countries.put("lr", "LIBERIA");
        this.countries.put("ly", "LIBYA");
        this.countries.put("li", "LIECHTENSTEIN");
        this.countries.put("lt", "LITHUANIA");
        this.countries.put("lu", "LUXEMBOURG");
        this.countries.put("mo", "MACAU");
        this.countries.put("mk", "MACEDONIA, THE FORMER YUGOSLAV REPUBLIC ");
        this.countries.put("mg", "MADAGASCAR");
        this.countries.put("mw", "MALAWI");
        this.countries.put("my", "MALAYSIA");
        this.countries.put("mv", "MALDIVES");
        this.countries.put("ml", "MALI");
        this.countries.put("mt", "MALTA");
        this.countries.put("mh", "MARSHALL ISLANDS");
        this.countries.put("mq", "MARTINIQUE");
        this.countries.put("mr", "MAURITANIA");
        this.countries.put("mu", "MAURITIUS");
        this.countries.put("yt", "MAYOTTE");
        this.countries.put("mx", "MEXICO");
        this.countries.put("fm", "MICRONESIA, FEDERATED STATES OF");
        this.countries.put("md", "MOLDOVA");
        this.countries.put("mc", "MONACO");
        this.countries.put("mn", "MONGOLIA");
        this.countries.put("me", "MONTENEGRO");
        this.countries.put("ms", "MONTSERRAT");
        this.countries.put("ma", "MOROCCO");
        this.countries.put("mz", "MOZAMBIQUE");
        this.countries.put("mm", "MYANMAR (WAS BURMA)");
        this.countries.put("na", "NAMIBIA");
        this.countries.put("nr", "NAURU");
        this.countries.put("np", "NEPAL");
        this.countries.put("an", "NETHERLANDS ANTILLES");
        this.countries.put("nl", "NETHERLANDS");
        this.countries.put("nc", "NEW CALEDONIA");
        this.countries.put("nz", "NEW ZEALAND");
        this.countries.put("ni", "NICARAGUA");
        this.countries.put("ne", "NIGER");
        this.countries.put("ng", "NIGERIA");
        this.countries.put("nu", "NIUE");
        this.countries.put("nf", "NORFOLK ISLAND");
        this.countries.put("mp", "NORTHERN MARIANA ISLANDS");
        this.countries.put("no", "NORWAY");
        this.countries.put("om", "OMAN");
        this.countries.put("pk", "PAKISTAN");
        this.countries.put("pw", "PALAU");
        this.countries.put("ps", "PALESTINIAN TERRITORY, OCCUPIED");
        this.countries.put("pa", "PANAMA");
        this.countries.put("pg", "PAPUA NEW GUINEA");
        this.countries.put("py", "PARAGUAY");
        this.countries.put("pe", "PERU");
        this.countries.put("ph", "PHILIPPINES");
        this.countries.put("pn", "PITCAIRN ISLAND");
        this.countries.put("pl", "POLAND");
        this.countries.put("pt", "PORTUGAL");
        this.countries.put("pr", "PUERTO RICO");
        this.countries.put("qa", "QATAR");
        this.countries.put("re", "REUNION");
        this.countries.put("ro", "ROMANIA");
        this.countries.put("ru", "RUSSIAN FEDERATION");
        this.countries.put("rw", "RWANDA");
        this.countries.put("bl", "SAINT BARTHELEMY");
        this.countries.put("sh", "SAINT HELENA");
        this.countries.put("kn", "SAINT KITTS AND NEVIS");
        this.countries.put("lc", "SAINT LUCIA");
        this.countries.put("sx", "SAINT MARTIN (DUTCH PART)");
        this.countries.put("mf", "SAINT MARTIN (FRENCH PART)");
        this.countries.put("pm", "SAINT PIERRE AND MIQUELON");
        this.countries.put("vc", "SAINT VINCENT AND THE GRENADINES");
        this.countries.put("ws", "SAMOA");
        this.countries.put("sm", "SAN MARINO");
        this.countries.put("st", "SAO TOME AND PRINCIPE");
        this.countries.put("sa", "SAUDI ARABIA");
        this.countries.put("sn", "SENEGAL");
        this.countries.put("rs", "SERBIA");
        this.countries.put("sc", "SEYCHELLES");
        this.countries.put("sl", "SIERRA LEONE");
        this.countries.put("sg", "SINGAPORE");
        this.countries.put("sk", "SLOVAKIA (SLOVAK REPUBLIC)");
        this.countries.put("si", "SLOVENIA");
        this.countries.put("sb", "SOLOMON ISLANDS");
        this.countries.put("so", "SOMALIA");
        this.countries.put("za", "SOUTH AFRICA");
        this.countries.put("ss", "SOUTH SUDAN");
        this.countries.put("es", "SPAIN");
        this.countries.put("lk", "SRI LANKA");
        this.countries.put("gs", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISL");
        this.countries.put("sd", "SUDAN");
        this.countries.put("sr", "SURINAME");
        this.countries.put("sj", "SVALBARD AND JAN MAYEN ISLANDS");
        this.countries.put("sz", "SWAZILAND");
        this.countries.put("se", "SWEDEN");
        this.countries.put("ch", "SWITZERLAND");
        this.countries.put("sy", "SYRIA");
        this.countries.put("tw", "TAIWAN");
        this.countries.put("tj", "TAJIKISTAN");
        this.countries.put("tz", "TANZANIA");
        this.countries.put("th", "THAILAND");
        this.countries.put("tg", "TOGO");
        this.countries.put("tk", "TOKELAU");
        this.countries.put("to", "TONGA");
        this.countries.put("tt", "TRINIDAD AND TOBAGO");
        this.countries.put("tn", "TUNISIA");
        this.countries.put("tr", "TURKEY");
        this.countries.put("tm", "TURKMENISTAN");
        this.countries.put("tc", "TURKS AND CAICOS ISLANDS");
        this.countries.put("tv", "TUVALU");
        this.countries.put("ug", "UGANDA");
        this.countries.put("ua", "UKRAINE");
        this.countries.put("ae", "UNITED ARAB EMIRATES");
        this.countries.put("gb", "UNITED KINGDOM");
        this.countries.put("us", "UNITED STATES");
        this.countries.put("um", "UNITED STATES MINOR OUTLYING ISLANDS");
        this.countries.put("vi", "UNITED STATES VIRGIN ISLANDS");
        this.countries.put("uy", "URUGUAY");
        this.countries.put("uz", "UZBEKISTAN");
        this.countries.put("vu", "VANUATU");
        this.countries.put("ve", "VENEZUELA");
        this.countries.put("vn", "VIETNAM");
        this.countries.put("wf", "WALLIS AND FUTUNA ISLANDS");
        this.countries.put("eh", "WESTERN SAHARA");
        this.countries.put("ye", "YEMEN");
        this.countries.put("yu", "YUGOSLAVIA");
        this.countries.put("zm", "ZAMBIA");
        this.countries.put("zw", "ZIMBABWE");
    }

    public String getCountryName(String code) {
        if (this.countries == null) {
            this.initialiseCountries();
        }
        return this.countries.get(code);
    }

    @Override
    protected String convertName(String name) {
        if (name != null && !name.isEmpty() && name.equals("AddressDetailsBusiness")) {
            return this.name;
        }
        return name;
    }
}

