/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.EventItem;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.TFND0004BusinessEventMessage;
import au.com.glenix.trn.TFND0004Declaration;
import au.com.glenix.trn.TFND0004INT;
import au.com.glenix.trn.TFND0004OverallEventMessage;
import au.com.glenix.trn.TFND0004Payee;
import au.com.glenix.trn.TFND0004RP;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SBRDocumentTFND0004
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter prettyDateTimeFormatter = null;

    public SBRDocumentTFND0004() throws Exception {
        this.name = "SBRDocumentTFND0004";
        this.namespace = "http://www.glenix.com.au/";
        this.sbrName = "TFND";
        this.sbrNamespace = "http://www.sbr.gov.au/ato/tfnd";
        this.sbrContext = "RP";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("tfnd0004Identifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "tfnd0004Identifier", null, null, null, 1, true));
        this.childrenAndMeta.put("TFND0004OverallEventMessage", new GlenixElementChildList(TFND0004OverallEventMessage.class, "http://www.glenix.com.au/", "TFND0004OverallEventMessage", null, null, null, 1, false));
        this.childrenAndMeta.put("TFND0004BusinessEventMessage", new GlenixElementChildList(TFND0004BusinessEventMessage.class, "http://www.glenix.com.au/", "TFND0004BusinessEventMessage", null, null, null, 1, false));
        this.childrenAndMeta.put("SBRDocumentStatus", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRDocumentStatus", null, null, null, 1, true));
        this.childrenAndMeta.put("SBRDocumentDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRDocumentDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("tfndMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "tfndMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("certAlias", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "certAlias", null, null, null, 1, true));
        this.childrenAndMeta.put("SBRStartDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRStartDate", null, null, null, 1, true));
        this.childrenAndMeta.put("SBREndDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBREndDate", null, null, null, 1, true));
        this.childrenAndMeta.put("TFND0004INT", new GlenixElementChildList(TFND0004INT.class, "http://www.glenix.com.au/", "TFND0004INT", "http://www.sbr.gov.au/ato/tfnd", "INT", "INT", 1, false));
        this.childrenAndMeta.put("TFND0004RP", new GlenixElementChildList(TFND0004RP.class, "http://www.glenix.com.au/", "TFND0004RP", "http://www.sbr.gov.au/ato/tfnd", "RP", "RP", 1, false));
        this.childrenAndMeta.put("TFND0004Payee", new GlenixElementChildList(TFND0004Payee.class, "http://www.glenix.com.au/", "TFND0004Payee", "http://www.sbr.gov.au/ato/tfnd", "Payee", "RP", 1, false));
        this.childrenAndMeta.put("Lodgment.Receipt.Datetime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Lodgment.Receipt.Datetime", null, null, null, 1, true));
        this.prettyDateTimeFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm");
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getTFND0004Identifier() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("tfnd0004Identifier");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getPrettySBRDocumentDateTime() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentDateTime");
        if (gse == null) {
            return null;
        }
        String val = gse.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            return null;
        }
        LocalDateTime lt = LocalDateTime.parse(val, this.dateTimeFormatter);
        if (lt == null) {
            return null;
        }
        return lt.format(this.prettyDateTimeFormatter);
    }

    public String getSBRDocumentDateTimeString() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentDateTime");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setSBRDocumentDateTime() throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentDateTime");
        if (gse != null) {
            String timestamp = this.generateTimestamp();
            gse.setGlenixElementValue(timestamp);
        }
    }

    public String getLodgmentReceiptDatetime() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Lodgment.Receipt.Datetime");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setLodgmentReceiptDatetime(String timestamp) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("Lodgment.Receipt.Datetime");
        if (gse != null) {
            gse.setGlenixElementValue(timestamp);
        }
    }

    public void removeEventMessages() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("TFND0004OverallEventItems");
        if (glenixElementChildList != null) {
            glenixElementChildList.clearChildren();
        }
        if ((glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("TFND0004BusinessEventItems")) != null) {
            glenixElementChildList.clearChildren();
        }
    }

    public String getTFNDMessageIdentifier() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("tfndMessageIdentifier");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void generateTFNDMessageIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("tfndMessageIdentifier");
        String uuidString = this.generateMessageIdentifier();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    public String getCertAlias() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("certAlias");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setCertAlias(String value) {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("certAlias");
        if (gse == null) {
            return;
        }
        gse.setGlenixElementValue(value);
    }

    public String getBusinessMaximumSeverityCode() {
        EventItems ei = (EventItems)this.getChild("TFND0004BusinessEventMessage");
        if (ei == null) {
            return null;
        }
        return ei.getMaximumSeverityCode();
    }

    public int getBusinessEventItemCount() {
        EventItems ei = (EventItems)this.getChild("TFND0004BusinessEventMessage");
        if (ei == null) {
            return 0;
        }
        return ei.getEventItemCount();
    }

    public EventItem getBusinessEventItem(int index) {
        EventItems ei = (EventItems)this.getChild("TFND0004BusinessEventMessage");
        if (ei == null) {
            return null;
        }
        return ei.getEventItem(index);
    }

    public String getBusinessEventItemErrorCode(int index) {
        EventItems eis = (EventItems)this.getChild("TFND0004BusinessEventMessage");
        if (eis == null) {
            return null;
        }
        EventItem ei = eis.getEventItem(index);
        if (ei == null) {
            return null;
        }
        return ei.getErrorCode();
    }

    public EventItems getOverallEventItems() {
        return (EventItems)this.getChild("TFND0004OverallEventMessage");
    }

    public EventItems getBusinessEventItems() {
        return (EventItems)this.getChild("TFND0004BusinessEventMessage");
    }

    public TFND0004RP getTFND0004RP() {
        return (TFND0004RP)this.getChild("TFND0004RP");
    }

    public TFND0004INT getTFND0004INT() {
        return (TFND0004INT)this.getChild("TFND0004INT");
    }

    public TFND0004Payee getTFND0004Payee() {
        return (TFND0004Payee)this.getChild("TFND0004Payee");
    }

    public String getINTAustralianBusinessNumberId() {
        TFND0004INT tfndInt = this.getTFND0004INT();
        if (tfndInt == null) {
            return null;
        }
        return tfndInt.getAustralianBusinessNumberId();
    }

    public String getSBRDocumentStatus() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentStatus");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public SimpleStringProperty getSBRDocumentStatusProperty() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentStatus");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementProperty();
    }

    public void setSBRDocumentStatus(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentStatus");
        if (gse == null) {
            return;
        }
        gse.setGlenixElementValue(value);
    }

    public String getTaxAgentNumberId() {
        TFND0004INT tfndInt = this.getTFND0004INT();
        if (tfndInt == null) {
            return null;
        }
        return tfndInt.getTaxAgentNumberId();
    }

    public String getAgentAustralianBusinessNumberId() {
        TFND0004INT tfndInt = this.getTFND0004INT();
        if (tfndInt == null) {
            return null;
        }
        return tfndInt.getAustralianBusinessNumberId();
    }

    public TFND0004Declaration getIntDeclaration() {
        TFND0004INT tfndInt = this.getTFND0004INT();
        if (tfndInt == null) {
            return null;
        }
        return tfndInt.getDeclaration();
    }

    public String getAustralianBusinessNumberId() {
        TFND0004RP tfndRp = this.getTFND0004RP();
        if (tfndRp == null) {
            return null;
        }
        return tfndRp.getAustralianBusinessNumberId();
    }

    public String getWithholdingPayerNumberId() {
        TFND0004RP tfndRp = this.getTFND0004RP();
        if (tfndRp == null) {
            return null;
        }
        return tfndRp.getWithholdingPayerNumberId();
    }

    public String getOrganisationDetailsOrganisationBranchC() {
        TFND0004RP tfndRp = this.getTFND0004RP();
        if (tfndRp == null) {
            return null;
        }
        return tfndRp.getOrganisationDetailsOrganisationBranchC();
    }

    public String getOrganisationNameDetailsOrganisationalNameT() {
        TFND0004RP tfndRp = this.getTFND0004RP();
        if (tfndRp == null) {
            return null;
        }
        return tfndRp.getOrganisationNameDetailsOrganisationalNameT();
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element counterpartyEl = document.createElementNS("http://www.glenix.com.au/", "gx:counterparty");
        transactionEl.appendChild(counterpartyEl);
        this.appendToElement(document, counterpartyEl);
        return document;
    }

    public Document buildDocument(String counterpartyIdentifier) throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element counterpartyEl = document.createElementNS("http://www.glenix.com.au/", "gx:counterparty");
        transactionEl.appendChild(counterpartyEl);
        Element counterpartyIdentifierEl = document.createElementNS("http://www.glenix.com.au/", "gx:counterpartyIdentifier");
        counterpartyIdentifierEl.setTextContent(counterpartyIdentifier);
        counterpartyEl.appendChild(counterpartyIdentifierEl);
        this.appendToElement(document, counterpartyEl);
        return document;
    }

    private void assignUUIDToTFND0004Identifier() throws Exception {
        String tfnd0004Identifier = this.getTFND0004Identifier();
        if (tfnd0004Identifier == null || tfnd0004Identifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("tfnd0004Identifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToTFND0004Identifier();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToTFND0004Identifier();
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getTFND0004Identifier();
    }

    public Document buildTFND0004Document() {
        Document doc = this.docBuilder.newDocument();
        doc.setXmlStandalone(true);
        this.buildSBRElement(doc, null);
        return doc;
    }

    public void loadSBROverallEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("TFND0004OverallEventMessage", new GlenixElementChildList(TFND0004OverallEventMessage.class, "http://www.glenix.com.au/", "TFND0004OverallEventMessage", null, null, null, 1, false));
        EventItems overallEventItems = (EventItems)this.getOrAddChild("TFND0004OverallEventMessage");
        overallEventItems.loadSBRDocumentRoot(doc, root);
    }

    public void loadSBRBusinessEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("TFND0004BusinessEventMessage", new GlenixElementChildList(TFND0004BusinessEventMessage.class, "http://www.glenix.com.au/", "TFND0004BusinessEventMessage", null, null, null, 1, false));
        EventItems businessEventItems = (EventItems)this.getOrAddChild("TFND0004BusinessEventMessage");
        businessEventItems.loadSBRDocumentRoot(doc, root);
    }

    public String getFamilyNameT() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getFamilyNameT();
    }

    public SimpleStringProperty getFamilyNameTProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getFamilyNameTProperty();
    }

    public String getGivenNameT() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getGivenNameT();
    }

    public SimpleStringProperty getGivenNameTProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getGivenNameTProperty();
    }

    public String getOtherGivenNameT() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getOtherGivenNameT();
    }

    public SimpleStringProperty getOtherGivenNameTProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getOtherGivenNameTProperty();
    }

    public String getLine1T() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getLine1T();
    }

    public SimpleStringProperty getLine1TProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getLine1TProperty();
    }

    public String getLine2T() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getLine2T();
    }

    public SimpleStringProperty getLine2TProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getLine2TProperty();
    }

    public String getLocalityNameT() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getLocalityNameT();
    }

    public SimpleStringProperty getLocalityNameTProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getLocalityNameTProperty();
    }

    public String getPostcodeT() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getPostcodeT();
    }

    public SimpleStringProperty getPostcodeTProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getPostcodeTProperty();
    }

    public String getStateOrTerritoryC() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getStateOrTerritoryC();
    }

    public SimpleStringProperty getStateOrTerritoryCProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getStateOrTerritoryCProperty();
    }

    public String getCountryC() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getCountryC();
    }

    public SimpleStringProperty getCountryCProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getCountryCProperty();
    }

    public String getTerminationC() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getTerminationC();
    }

    public SimpleStringProperty getTerminationCProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getTerminationCProperty();
    }

    public String getResidencyTaxPurposesPersonStatusC() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getResidencyTaxPurposesPersonStatusC();
    }

    public SimpleStringProperty getResidencyTaxPurposesPersonStatusCProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getResidencyTaxPurposesPersonStatusCProperty();
    }

    public String getPaymentBasisC() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getPaymentBasisC();
    }

    public SimpleStringProperty getPaymentBasisCProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getPaymentBasisCProperty();
    }

    public String getTaxOffsetClaimTaxFreeThresholdI() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getTaxOffsetClaimTaxFreeThresholdI();
    }

    public SimpleStringProperty getTaxOffsetClaimTaxFreeThresholdIProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getTaxOffsetClaimTaxFreeThresholdIProperty();
    }

    public String getIncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getIncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI();
    }

    public SimpleStringProperty getIncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentIProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getIncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentIProperty();
    }

    public String getStudentLoanStudentFinancialSupplementSchemeI() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getStudentLoanStudentFinancialSupplementSchemeI();
    }

    public SimpleStringProperty getStudentLoanStudentFinancialSupplementSchemeIProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getStudentLoanStudentFinancialSupplementSchemeIProperty();
    }

    public String getTaxFileNumberId() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getTaxFileNumberId();
    }

    public SimpleStringProperty getTaxFileNumberIdProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getTaxFileNumberIdProperty();
    }

    public String getIdentificationExemptionDetailsTFNExemptionTypeC() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getIdentificationExemptionDetailsTFNExemptionTypeC();
    }

    public SimpleStringProperty getIdentificationExemptionDetailsTFNExemptionTypeCProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getIdentificationExemptionDetailsTFNExemptionTypeCProperty();
    }

    public String getEmploymentPayrollNumberId() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getEmploymentPayrollNumberId();
    }

    public SimpleStringProperty getEmploymentPayrollNumberIdProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getEmploymentPayrollNumberIdProperty();
    }

    public String getClaimOrVaryTaxOffset() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getClaimOrVaryTaxOffset();
    }

    public SimpleStringProperty getClaimOrVaryTaxOffsetProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getClaimOrVaryTaxOffsetProperty();
    }

    public String getEstimatedTotalTaxOffsetAmount() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getEstimatedTotalTaxOffsetAmount();
    }

    public SimpleStringProperty getEstimatedTotalTaxOffsetAmountProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getEstimatedTotalTaxOffsetAmountProperty();
    }

    public String getSeniorsAndPensionersTaxOffset() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getSeniorsAndPensionersTaxOffset();
    }

    public SimpleStringProperty getSeniorsAndPensionersTaxOffsetProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getSeniorsAndPensionersTaxOffsetProperty();
    }

    public String getSeniorsAndPensionersTaxOffsetType() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getSeniorsAndPensionersTaxOffsetType();
    }

    public SimpleStringProperty getSeniorsAndPensionersTaxOffsetTypeProperty() {
        TFND0004Payee payee = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (payee == null) {
            return null;
        }
        return payee.getSeniorsAndPensionersTaxOffsetTypeProperty();
    }

    public String getPayeeBirthM() {
        TFND0004Payee pdd = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (pdd == null) {
            return null;
        }
        return pdd.getBirthM();
    }

    public String getPayeeBirthY() {
        TFND0004Payee pdd = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (pdd == null) {
            return null;
        }
        return pdd.getBirthY();
    }

    public String getPayeeBirthDate() {
        TFND0004Payee pdd = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (pdd == null) {
            return null;
        }
        return pdd.getBirthDate();
    }

    public SimpleStringProperty getPayeeBirthDateProperty() {
        TFND0004Payee pdd = (TFND0004Payee)this.getChild("TFND0004Payee");
        if (pdd == null) {
            return null;
        }
        return pdd.getBirthDateProperty();
    }

    public void loadFasV2CounterpartyList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("identifierTFNDeclaration")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("identifierTFNDeclarationNumber")) continue;
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("tfnd0004Identifier");
                gse.setGlenixElementValue(el.getTextContent());
                gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentStatus");
                gse.setGlenixElementValue("lodge_complete");
            }
            TFND0004Payee payee = (TFND0004Payee)this.getOrAddChild("TFND0004Payee");
            payee.loadFasV2CounterpartyList(doc, element);
            return;
        }
    }
}

