/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.SBRContext;
import java.util.HashMap;

public class SBRContexts {
    private HashMap<String, SBRContext> contexts = new HashMap();

    public SBRContext addContext(String contextId) {
        SBRContext result = new SBRContext(contextId);
        this.contexts.put(contextId, result);
        return result;
    }

    public void setContextDimension(String contextId, String dimensionName, String dimensionValue) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            c = new SBRContext(contextId);
            this.contexts.put(contextId, c);
        }
        c.setDimension(dimensionName, dimensionValue);
    }

    public String getContextDimension(String contextId, String dimensionName) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            return null;
        }
        return c.getDimension(dimensionName);
    }

    public void setContextStartDate(String contextId, String startDate) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            c = new SBRContext(contextId);
            this.contexts.put(contextId, c);
        }
        c.setStartDate(startDate);
    }

    public void setContextEndDate(String contextId, String endDate) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            c = new SBRContext(contextId);
            this.contexts.put(contextId, c);
        }
        c.setEndDate(endDate);
    }

    public String getContextStartDate(String contextId) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            return null;
        }
        return c.getStartDate();
    }

    public String getContextEndDate(String contextId) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            return null;
        }
        return c.getEndDate();
    }

    public void setIdentifierScheme(String contextId, String identifierScheme) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            c = new SBRContext(contextId);
            this.contexts.put(contextId, c);
        }
        c.setIdentifierScheme(identifierScheme);
    }

    public void setIdentifier(String contextId, String identifier) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            c = new SBRContext(contextId);
            this.contexts.put(contextId, c);
        }
        c.setIdentifier(identifier);
    }

    public String getIdentifierScheme(String contextId) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            return null;
        }
        return c.getIdentifierScheme();
    }

    public String getIdentifier(String contextId) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            return null;
        }
        return c.getIdentifier();
    }

    public String getGlenixSBRContextRef(String contextId) {
        SBRContext c = this.contexts.get(contextId);
        if (c == null) {
            return null;
        }
        return c.getGlenixSBRContextRef();
    }

    private SBRContext getContextByGlenixRef(String glenixContextId) {
        if (glenixContextId == null) {
            return null;
        }
        for (SBRContext sbrContext : this.contexts.values()) {
            if (!glenixContextId.equals(sbrContext.getGlenixSBRContextRef())) continue;
            return sbrContext;
        }
        return null;
    }

    public String getGlenixContextDimension(String gContextId, String dimensionName) {
        SBRContext c = this.getContextByGlenixRef(gContextId);
        if (c == null) {
            return null;
        }
        return c.getDimension(dimensionName);
    }

    public String getGlenixContextStartDate(String gContextId) {
        SBRContext c = this.getContextByGlenixRef(gContextId);
        if (c == null) {
            return null;
        }
        return c.getStartDate();
    }

    public String getGlenixContextEndDate(String gContextId) {
        SBRContext c = this.getContextByGlenixRef(gContextId);
        if (c == null) {
            return null;
        }
        return c.getEndDate();
    }

    public String getGlenixIdentifierScheme(String gContextId) {
        SBRContext c = this.getContextByGlenixRef(gContextId);
        if (c == null) {
            return null;
        }
        return c.getIdentifierScheme();
    }

    public String getGlenixIdentifier(String gContextId) {
        SBRContext c = this.getContextByGlenixRef(gContextId);
        if (c == null) {
            return null;
        }
        return c.getIdentifier();
    }
}

