/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Provision
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public Provision() throws Exception {
        this.name = "provision";
        this.namespace = "http://www.glenix.com.au/";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("provisionIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionName", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionDescription", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionDescription", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionClassificationReference", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionClassificationReference", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionActive", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionActive", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionPercentage", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionPercentage", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionGrossBASClassification", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionGrossBASClassification", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionTaxBASClassification", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionTaxBASClassification", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionPSType", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionPSType", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionGrossPSClassification", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionGrossPSClassification", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionTaxPSClassification", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionTaxPSClassification", null, null, null, 1, true));
        this.childrenAndMeta.put("provisionLeaveType", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "provisionLeaveType", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public String getProvisionIdentifier() {
        return this.getChildValue("provisionIdentifier");
    }

    public SimpleStringProperty getProvisionIdentifierProperty() {
        return this.getChildProperty("provisionIdentifier");
    }

    public String getProvisionName() {
        return this.getChildValue("provisionName");
    }

    public SimpleStringProperty getProvisionNameProperty() {
        return this.getChildProperty("provisionName");
    }

    public void setProvisionName(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionName");
        gse.setGlenixElementValue(value);
    }

    public String getProvisionDescription() {
        return this.getChildValue("provisionDescription");
    }

    public SimpleStringProperty getProvisionDescriptionProperty() {
        return this.getChildProperty("provisionDescription");
    }

    public String getProvisionClassificationReference() {
        return this.getChildValue("provisionClassificationReference");
    }

    public SimpleStringProperty getProvisionClassificationReferenceProperty() {
        return this.getChildProperty("provisionClassificationReference");
    }

    public void setProvisionClassificationReference(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionClassificationReference");
        gse.setGlenixElementValue(value);
    }

    public String getProvisionActive() {
        return this.getChildValue("provisionActive");
    }

    public SimpleStringProperty getProvisionActiveProperty() {
        return this.getChildProperty("provisionActive");
    }

    public String getProvisionPercentage() {
        return this.getChildValue("provisionPercentage");
    }

    public Double getProvisionPercentageAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("provisionPercentage");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public SimpleStringProperty getProvisionPercentageProperty() {
        return this.getChildProperty("provisionPercentage");
    }

    public String getProvisionGrossBASClassification() {
        return this.getChildValue("provisionGrossBASClassification");
    }

    public SimpleStringProperty getProvisionGrossBASClassificationProperty() {
        return this.getChildProperty("provisionGrossBASClassification");
    }

    public void setProvisionGrossBASClassification(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionGrossBASClassification");
        gse.setGlenixElementValue(value);
    }

    public String getProvisionTaxBASClassification() {
        return this.getChildValue("provisionTaxBASClassification");
    }

    public SimpleStringProperty getProvisionTaxBASClassificationProperty() {
        return this.getChildProperty("provisionTaxBASClassification");
    }

    public String getProvisionPSType() {
        return this.getChildValue("provisionPSType");
    }

    public SimpleStringProperty getProvisionPSTypeProperty() {
        return this.getChildProperty("provisionPSType");
    }

    public String getProvisionGrossPSClassification() {
        return this.getChildValue("provisionGrossPSClassification");
    }

    public SimpleStringProperty getProvisionGrossPSClassificationProperty() {
        return this.getChildProperty("provisionGrossPSClassification");
    }

    public String getProvisionTaxPSClassification() {
        return this.getChildValue("provisionTaxPSClassification");
    }

    public SimpleStringProperty getProvisionTaxPSClassificationProperty() {
        return this.getChildProperty("provisionTaxPSClassification");
    }

    public String getProvisionLeaveType() {
        return this.getChildValue("provisionLeaveType");
    }

    public SimpleStringProperty getProvisionLeaveTypeProperty() {
        return this.getChildProperty("provisionLeaveType");
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = document.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        this.appendToElement(document, transactionLineEl);
        return document;
    }

    public void assignUUIDToProvisionIdentifier() throws Exception {
        String provisionIdentifier = this.getProvisionIdentifier();
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("provisionIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getProvisionIdentifier();
    }

    public void setProvisionIdentifier(String identifier) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionIdentifier");
        gse.setGlenixElementValue(identifier);
    }

    public void loadFasV2ProvisionList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("taxMaster")) {
            this.setProvisionClassificationReference("liability");
            String taxCode = null;
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                GlenixStringElement gse;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                Element el2 = (Element)node2;
                if (el2.getLocalName().equals("taxCode")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionIdentifier");
                    taxCode = el2.getTextContent();
                    gse.setGlenixElementValue(taxCode);
                    gse = (GlenixStringElement)this.getOrAddChild("provisionActive");
                    gse.setGlenixElementValue("true");
                    continue;
                }
                if (el2.getLocalName().equals("taxDescription")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionName");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("taxPercentageRate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionPercentage");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("taxGrossAmountBASElement")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionGrossBASClassification");
                    String classification = el2.getTextContent();
                    gse.setGlenixElementValue(classification);
                    if (classification == null || !classification.equals("Non_Capital_Purchases") && !classification.equals("Capital_Purchases") && !classification.equals("Purchases_for_Input_Taxed_Sales") && !classification.equals("Purchases_for_Input_Taxed_Sales_Capital") && !classification.equals("GST_Free_Purchases") && !classification.equals("GST_Free_Purchases_Capital") && !classification.equals("Purchase_Adjustments")) continue;
                    this.setProvisionClassificationReference("asset");
                    continue;
                }
                if (el2.getLocalName().equals("taxTaxAmountBASElement")) {
                    GlenixStringElement gseGross;
                    gse = (GlenixStringElement)this.getOrAddChild("provisionTaxBASClassification");
                    gse.setGlenixElementValue(el2.getTextContent());
                    if (el2.getTextContent() == null || el2.getTextContent().isEmpty() || (gseGross = (GlenixStringElement)this.getOrAddChild("provisionGrossBASClassification")).getGlenixElementValue() != null && !gseGross.getGlenixElementValue().isEmpty() && !gseGross.getGlenixElementValue().equals("NA")) continue;
                    String classification = el2.getTextContent();
                    gseGross.setGlenixElementValue(classification);
                    if (classification == null || !classification.equals("GST_Received_from_ATO") && !classification.equals("GST_Receivable") && !classification.equals("Fuel_Tax_Overclaimed_Credits") && !classification.equals("Fuel_Tax_Claimable_Credits") && !classification.equals("Fuel_Tax_Credits_Refunded_from_ATO") && !classification.equals("GST_Deferred_Liability_On_Import_Duty")) continue;
                    this.setProvisionClassificationReference("asset");
                    continue;
                }
                if (el2.getLocalName().equals("taxPaymentSummaryType")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionPSType");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("taxGrossAmountPSElement")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionGrossPSClassification");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("taxTaxAmountPSElement")) {
                    gse = (GlenixStringElement)this.getOrAddChild("provisionTaxPSClassification");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (!el2.getLocalName().equals("taxLeaveType")) continue;
                gse = (GlenixStringElement)this.getOrAddChild("provisionLeaveType");
                gse.setGlenixElementValue(el2.getTextContent());
            }
            if (taxCode != null && taxCode.equals("xglsup")) {
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionPercentage");
                gse.setGlenixElementValue("100");
                gse = (GlenixStringElement)this.getOrAddChild("provisionGrossBASClassification");
                gse.setGlenixElementValue("NA");
                gse = (GlenixStringElement)this.getOrAddChild("provisionTaxBASClassification");
                gse.setGlenixElementValue("NA");
                gse = (GlenixStringElement)this.getOrAddChild("provisionPSType");
                gse.setGlenixElementValue("NA");
                gse = (GlenixStringElement)this.getOrAddChild("provisionGrossPSClassification");
                gse.setGlenixElementValue("NA");
                gse = (GlenixStringElement)this.getOrAddChild("provisionTaxPSClassification");
                gse.setGlenixElementValue("Superannuation_SGC_Contributions");
                gse = (GlenixStringElement)this.getOrAddChild("provisionPSType");
                gse.setGlenixElementValue("Individual_Non_Business");
            } else if (taxCode != null && taxCode.equals("ISPAYG")) {
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionPercentage");
                gse.setGlenixElementValue("100");
                gse = (GlenixStringElement)this.getOrAddChild("provisionGrossBASClassification");
                gse.setGlenixElementValue("PAYG_Withholding_Payable");
                gse = (GlenixStringElement)this.getOrAddChild("provisionPSType");
                gse.setGlenixElementValue("Individual_Non_Business");
                gse = (GlenixStringElement)this.getOrAddChild("provisionGrossPSClassification");
                gse.setGlenixElementValue("NA");
                gse = (GlenixStringElement)this.getOrAddChild("provisionTaxPSClassification");
                gse.setGlenixElementValue("PAYG_Individual_Non_Business");
            }
        }
    }

    public void loadFasV2Transactions(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("taxMaster")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("taxCode")) continue;
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("provisionIdentifier");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("provisionIdentifier")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }
}

