/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixAmountElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.ITPAYGWithholdingDetails;
import au.com.glenix.trn.SBRContexts;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PAYGWObligation
extends GlenixAbstractBranchElement {
    public PAYGWObligation(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext) throws Exception {
        this.namespace = namespace;
        this.name = name;
        this.sbrNamespace = sbrNamespace;
        this.sbrName = sbrName;
        this.sbrContext = sbrContext;
        this.childrenAndMeta.put("SBRStartDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRStartDate", null, null, "RP_PAYGW", 1, true));
        this.childrenAndMeta.put("SBREndDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBREndDate", null, null, "RP_PAYGW", 1, true));
        this.childrenAndMeta.put("Remuneration.WagesAndSalaries.PlusPaymentsOther.Amount", new GlenixElementChildList(GlenixAmountElement.class, "http://www.glenix.com.au/", "Remuneration.WagesAndSalaries.PlusPaymentsOther.Amount", "http://sbr.gov.au/icls/lr/lrla/lrla.02.00.data", "Remuneration.WagesAndSalaries.PlusPaymentsOther.Amount", "RP_PAYGW", 1, true));
        this.childrenAndMeta.put("IncomeTax.PayAsYouGoWithholding.Total.Amount", new GlenixElementChildList(GlenixAmountElement.class, "http://www.glenix.com.au/", "IncomeTax.PayAsYouGoWithholding.Total.Amount", "http://sbr.gov.au/icls/rvc/rvctc/rvctc2.02.00.data", "IncomeTax.PayAsYouGoWithholding.Total.Amount", "RP_PAYGW", 1, true));
        GlenixElementChildList gecl = new GlenixElementChildList(ITPAYGWithholdingDetails.class, "http://www.glenix.com.au/", "DNOABNITPAYGWithholdingDetails", "http://sbr.gov.au/rprt/ato/as/as.0001.private.02.00.module", "ITPAYGWithholdingDetails", "RP_PAYGW", 1, false);
        this.childrenAndMeta.put("DNOABNITPAYGWithholdingDetails", gecl);
        gecl = new GlenixElementChildList(ITPAYGWithholdingDetails.class, "http://www.glenix.com.au/", "W2ITPAYGWithholdingDetails", "http://sbr.gov.au/rprt/ato/as/as.0001.private.02.00.module", "ITPAYGWithholdingDetails", "RP_PAYGW", 1, false);
        this.childrenAndMeta.put("W2ITPAYGWithholdingDetails", gecl);
        gecl = new GlenixElementChildList(ITPAYGWithholdingDetails.class, "http://www.glenix.com.au/", "W3ITPAYGWithholdingDetails", "http://sbr.gov.au/rprt/ato/as/as.0001.private.02.00.module", "ITPAYGWithholdingDetails", "RP_PAYGW", 1, false);
        this.childrenAndMeta.put("W3ITPAYGWithholdingDetails", gecl);
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public boolean loadSBRDocumentElement(Document doc, Element element, SBRContexts contexts, boolean lodgeOK) throws Exception {
        boolean subresult = false;
        for (GlenixElementChildList cl : this.childrenAndMeta.values()) {
            GlenixElement ge = this.getOrAddChild(cl);
            subresult = ge.loadSBRDocumentElement(doc, element, contexts, lodgeOK);
            if (!subresult) continue;
            return true;
        }
        return false;
    }

    public void setContextFields(SBRContexts contexts) throws Exception {
        GlenixStringElement gse;
        String endDateStr;
        GlenixStringElement gse2;
        String startDateStr = contexts.getGlenixContextStartDate("RP_PAYGW");
        if (startDateStr != null && (gse2 = (GlenixStringElement)this.getOrAddChild("SBRStartDate")) != null) {
            gse2.setGlenixElementValue(startDateStr);
        }
        if ((endDateStr = contexts.getGlenixContextEndDate("RP_PAYGW")) != null && (gse = (GlenixStringElement)this.getOrAddChild("SBREndDate")) != null) {
            gse.setGlenixElementValue(endDateStr);
        }
    }

    public String getStartDate() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRStartDate");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public String getEndDate() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBREndDate");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public LocalDate getStartDateAsDate() {
        String date = this.getStartDate();
        if (date == null) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LocalDate getEndDateAsDate() {
        String date = this.getEndDate();
        if (date == null) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ITPAYGWithholdingDetails getDNOABNITPAYGWithholdingDetails() {
        return (ITPAYGWithholdingDetails)this.getChild("DNOABNITPAYGWithholdingDetails");
    }

    public ITPAYGWithholdingDetails getW2ITPAYGWithholdingDetails() {
        return (ITPAYGWithholdingDetails)this.getChild("W2ITPAYGWithholdingDetails");
    }

    public ITPAYGWithholdingDetails getW3ITPAYGWithholdingDetails() {
        return (ITPAYGWithholdingDetails)this.getChild("W3ITPAYGWithholdingDetails");
    }

    public ITPAYGWithholdingDetails getOrAddDNOABNITPAYGWithholdingDetails() throws Exception {
        return (ITPAYGWithholdingDetails)this.getOrAddChild("DNOABNITPAYGWithholdingDetails");
    }

    public ITPAYGWithholdingDetails getOrAddW2ITPAYGWithholdingDetails() throws Exception {
        return (ITPAYGWithholdingDetails)this.getOrAddChild("W2ITPAYGWithholdingDetails");
    }

    public ITPAYGWithholdingDetails getOrAddW3ITPAYGWithholdingDetails() throws Exception {
        return (ITPAYGWithholdingDetails)this.getOrAddChild("W3ITPAYGWithholdingDetails");
    }

    public String getRemunerationWagesAndSalariesPlusPaymentsOtherAmount() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Remuneration.WagesAndSalaries.PlusPaymentsOther.Amount");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setRemunerationWagesAndSalariesPlusPaymentsOtherAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("Remuneration.WagesAndSalaries.PlusPaymentsOther.Amount");
        if (gse != null) {
            gse.setGlenixElementValue(value);
        }
    }

    public String getIncomeTaxPayAsYouGoWithholdingTotalAmount() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("IncomeTax.PayAsYouGoWithholding.Total.Amount");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setIncomeTaxPayAsYouGoWithholdingTotalAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("IncomeTax.PayAsYouGoWithholding.Total.Amount");
        if (gse != null) {
            gse.setGlenixElementValue(value);
        }
    }

    public String getDNOABNITPAYGWithholdingDetailsAmount() {
        ITPAYGWithholdingDetails gse = (ITPAYGWithholdingDetails)this.getChild("DNOABNITPAYGWithholdingDetails");
        if (gse == null) {
            return null;
        }
        return gse.getPAYGWTaxWithheldAmount();
    }

    public void setDNOABNITPAYGWithholdingDetailsAmount(String value) throws Exception {
        ITPAYGWithholdingDetails gse = (ITPAYGWithholdingDetails)this.getOrAddChild("DNOABNITPAYGWithholdingDetails");
        if (gse != null) {
            gse.setPAYGWTaxWithheldAmount(value);
        }
    }

    public String getW2ITPAYGWithholdingDetailsAmount() {
        ITPAYGWithholdingDetails gse = (ITPAYGWithholdingDetails)this.getChild("W2ITPAYGWithholdingDetails");
        if (gse == null) {
            return null;
        }
        return gse.getPAYGWTaxWithheldAmount();
    }

    public void setW2ITPAYGWithholdingDetailsAmount(String value) throws Exception {
        ITPAYGWithholdingDetails gse = (ITPAYGWithholdingDetails)this.getOrAddChild("W2ITPAYGWithholdingDetails");
        if (gse != null) {
            gse.setPAYGWTaxWithheldAmount(value);
        }
    }

    public String getW3ITPAYGWithholdingDetailsAmount() {
        ITPAYGWithholdingDetails gse = (ITPAYGWithholdingDetails)this.getChild("W3ITPAYGWithholdingDetails");
        if (gse == null) {
            return null;
        }
        return gse.getPAYGWTaxWithheldAmount();
    }

    public void setW3ITPAYGWithholdingDetailsAmount(String value) throws Exception {
        ITPAYGWithholdingDetails gse = (ITPAYGWithholdingDetails)this.getOrAddChild("W3ITPAYGWithholdingDetails");
        if (gse != null) {
            gse.setPAYGWTaxWithheldAmount(value);
        }
    }
}

