/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportData
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public ImportData() throws Exception {
        this.name = "importData";
        this.namespace = "http://www.glenix.com.au/";
        this.sbrName = null;
        this.sbrNamespace = null;
        this.sbrContext = null;
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("importDataIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataFileName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataFileName", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataTransactionReference", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataTransactionReference", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataTransactionType", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataTransactionType", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataDate", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataCounterparty", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataCounterparty", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataCounterpartyIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataCounterpartyIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataComment", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataComment", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataQuantity", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataQuantity", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataProvisionAmount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataProvisionAmount", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataAccount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataAccount", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataAccountIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataAccountIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataProvision", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataProvision", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataProvisionIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataProvisionIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("importDataBankAccount", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "importDataBankAccount", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public String getImportDataIdentifier() {
        return this.getChildValue("importDataIdentifier");
    }

    public void setImportDataIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataFileName() {
        return this.getChildValue("importDataFileName");
    }

    public void setImportDataFileName(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataFileName");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataTransactionReference() {
        return this.getChildValue("importDataTransactionReference");
    }

    public void setImportDataTransactionReference(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataTransactionReference");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataTransactionType() {
        return this.getChildValue("importDataTransactionType");
    }

    public void setImportDataTransactionType(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataTransactionType");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataDate() {
        return this.getChildValue("importDataDate");
    }

    public LocalDate getImportDataDateAsDate() {
        String date = this.getChildValue("importDataDate");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setImportDataDate(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataDate");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataCounterparty() {
        return this.getChildValue("importDataCounterparty");
    }

    public void setImportDataCounterparty(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataCounterparty");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataCounterpartyIdentifier() {
        return this.getChildValue("importDataCounterpartyIdentifier");
    }

    public void setImportDataCounterpartyIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataCounterpartyIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataComment() {
        return this.getChildValue("importDataComment");
    }

    public void setImportDataComment(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataComment");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataAmount() {
        return this.getChildValue("importDataAmount");
    }

    public Double getImportDataAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("importDataAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public void setImportDataAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataAmount");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataQuantity() {
        return this.getChildValue("importDataQuantity");
    }

    public Double getImportDataQuantityAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("importDataQuantity");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public void setImportDataQuantity(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataQuantity");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataProvisionAmount() {
        return this.getChildValue("importDataProvisionAmount");
    }

    public Double getImportDataProvisionAmountAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("importDataProvisionAmount");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public void setImportDataProvisionAmount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataProvisionAmount");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataAccount() {
        return this.getChildValue("importDataAccount");
    }

    public void setImportDataAccount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataAccount");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataAccountIdentifier() {
        return this.getChildValue("importDataAccountIdentifier");
    }

    public void setImportDataAccountIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataAccountIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataProvision() {
        return this.getChildValue("importDataProvision");
    }

    public void setImportDataProvision(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataProvision");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataProvisionIdentifier() {
        return this.getChildValue("importDataProvisionIdentifier");
    }

    public void setImportDataProvisionIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataProvisionIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getImportDataBankAccount() {
        return this.getChildValue("importDataBankAccount");
    }

    public void setImportDataBankAccount(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("importDataBankAccount");
        gse.setGlenixElementValue(value);
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = document.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        this.appendToElement(document, transactionLineEl);
        return document;
    }

    public void assignUUIDToImportDataIdentifier() throws Exception {
        String importDataIdentifier = this.getImportDataIdentifier();
        if (importDataIdentifier == null || importDataIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("importDataIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToImportDataIdentifier();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToImportDataIdentifier();
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getImportDataIdentifier();
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("importDataIdentifier")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }
}

