/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HomeOffice
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public HomeOffice() throws Exception {
        this.name = "homeOffice";
        this.namespace = "http://www.glenix.com.au/";
        this.sbrName = null;
        this.sbrNamespace = null;
        this.sbrContext = null;
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("homeOfficeIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeAddress", new GlenixElementChildList(TFND0004AddressDetailsBusiness.class, "http://www.glenix.com.au/", "homeOfficeAddress", null, null, null, 1, false));
        this.childrenAndMeta.put("homeOfficeStartDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeStartDate", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeEndDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeEndDate", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeWeeksUnused", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeWeeksUnused", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeFloorArea", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeFloorArea", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeHomeTotalArea", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeHomeTotalArea", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeHoursUsagePerWeek", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeHoursUsagePerWeek", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeTotalHoursUsage", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeTotalHoursUsage", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeTransactionNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeTransactionNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("homeOfficeComment", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "homeOfficeComment", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public TFND0004AddressDetailsBusiness getAddressDetails() {
        return (TFND0004AddressDetailsBusiness)this.getChild("homeOfficeAddress");
    }

    public String getFullAddress() {
        TFND0004AddressDetailsBusiness a = this.getAddressDetails();
        if (a == null) {
            return null;
        }
        return a.getFullAddress();
    }

    public String getHomeOfficeIdentifier() {
        return this.getChildValue("homeOfficeIdentifier");
    }

    public void setHomeOfficeIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("homeOfficeIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getHomeOfficeStartDate() {
        return this.getChildValue("homeOfficeStartDate");
    }

    public String getHomeOfficeEndDate() {
        return this.getChildValue("homeOfficeEndDate");
    }

    public String getHomeOfficeWeeksUnused() {
        return this.getChildValue("homeOfficeWeeksUnused");
    }

    public String getHomeOfficeFloorArea() {
        return this.getChildValue("homeOfficeFloorArea");
    }

    public String getHomeOfficeTransactionNumber() {
        return this.getChildValue("homeOfficeTransactionNumber");
    }

    public void setHomeOfficeTransactionNumber(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("homeOfficeTransactionNumber");
        gse.setGlenixElementValue(value);
    }

    public Double getHomeOfficeFloorAreaAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("homeOfficeFloorArea");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public String getHomeOfficeHomeTotalArea() {
        return this.getChildValue("homeOfficeHomeTotalArea");
    }

    public Double getHomeOfficeHomeTotalAreaAsDouble() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("homeOfficeHomeTotalArea");
        if (gse == null) {
            return 0.0;
        }
        String val = gse.getGlenixElementValue();
        if (val == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    public String getHomeOfficeComment() {
        return this.getChildValue("homeOfficeComment");
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = document.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        this.appendToElement(document, transactionLineEl);
        return document;
    }

    public void assignUUIDToHomeOfficeIdentifier() throws Exception {
        String homeOfficeIdentifier = this.getHomeOfficeIdentifier();
        if (homeOfficeIdentifier == null || homeOfficeIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("homeOfficeIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getHomeOfficeIdentifier();
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("homeOfficeIdentifier")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }
}

