/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.ActivityStatementList;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.BusinessIssue;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.DocumentLayout;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.LastUpdateIdentifier;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlenixTrnXBRL
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private static HashMap<String, String> namespacetoprefix = null;

    public GlenixTrnXBRL() throws Exception {
        this.name = "glenix";
        this.namespace = "http://www.glenix.com.au/";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("business", new GlenixElementChildList(Business.class, "http://www.glenix.com.au/", "business", null, null, null, -1, false));
    }

    public Business getBusiness() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("business");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (Business)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public ArrayList<Business> getBusinessArrayList() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("business");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.children;
        }
        return null;
    }

    public int getEmployeeCount() {
        Business b = this.getBusiness();
        if (b == null) {
            return 0;
        }
        return b.getEmployeeCount();
    }

    public void initBusiness() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("business");
        glenixElementChildList.addChild();
    }

    public BusinessMasterFile getBusinessMasterFile() {
        Business business = this.getBusiness();
        if (business != null) {
            return business.getBusinessMasterFile();
        }
        return null;
    }

    public DocumentLayout getDocumentLayout() {
        Business business = this.getBusiness();
        if (business != null) {
            return business.getDocumentLayout();
        }
        return null;
    }

    public ArrayList<Transaction> getTransactionArrayList() {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getTransactionArrayList();
    }

    public ArrayList<Transaction> getTransactionArrayListByBatch(String batchIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getTransactionArrayListByBatch(batchIdentifier);
    }

    public ArrayList<Transaction> getTransactionArrayListByCounterparty(String counterpartyIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getTransactionArrayListByCounterparty(counterpartyIdentifier);
    }

    public ActivityStatementList getActivityStatementList() {
        Business business = this.getBusiness();
        if (business != null) {
            return business.getActivityStatementList();
        }
        return null;
    }

    public void initActivityStatementList() throws Exception {
        Business business;
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
        if ((business = this.getBusiness()) != null) {
            business.initActivityStatementList();
        }
    }

    public ActivityStatement getActivityStatement() {
        Business business = this.getBusiness();
        if (business != null) {
            return business.getActivityStatement();
        }
        return null;
    }

    public void initActivityStatement() throws Exception {
        Business business;
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
        if ((business = this.getBusiness()) != null) {
            business.initActivityStatement();
        }
    }

    public void initCounterpartyList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initProvisionList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initAccountList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initHomeOfficeList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initFuelTaxCreditList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initImportDataList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initBusinessIssueList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public void initBusinessMessageList() throws Exception {
        if (this.getBusiness() == null) {
            this.initBusiness();
        }
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        this.appendToElement(document, null);
        return document;
    }

    public Document buildSignableDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element rootel = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        rootel.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(rootel);
        for (String key : this.childrenAndMeta.keySet()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(key);
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                GlenixElement ge = glenixElementChildList.getChild(i);
                ge.appendToElement(document, rootel);
            }
        }
        return document;
    }

    @Override
    public void appendToElement(Document document, Element element) throws Exception {
        if (document == null) {
            throw new Exception("Error, append to element but document provided is null. GlenixTrnXBRL is top level.");
        }
        if (element != null) {
            throw new Exception("Error, element should be null as this is a top level element");
        }
        String namespacePrefix = GlenixElement.getNamespacePrefix(this.namespace);
        element = namespacePrefix != null && !namespacePrefix.isEmpty() ? document.createElementNS(this.namespace, namespacePrefix + ":" + this.name) : document.createElementNS(this.namespace, this.name);
        if (this.namespace != null && this.namespace.equals("http://www.glenix.com.au/")) {
            if (namespacePrefix != null && !namespacePrefix.isEmpty()) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespacePrefix, "http://www.glenix.com.au/");
            } else {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.glenix.com.au/");
            }
        }
        document.appendChild(element);
        for (String key : this.childrenAndMeta.keySet()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(key);
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                GlenixElement ge = glenixElementChildList.getChild(i);
                ge.appendToElement(document, element);
            }
        }
    }

    public Transaction addBlankTransaction() throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        return business.addBlankTransaction();
    }

    public void addTransaction(Transaction transaction) throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        business.addTransaction(transaction);
    }

    public void addTransactions(Set<Transaction> transactions) throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        business.addTransactions(transactions);
    }

    public void addTransactionsNew(Set<Transaction> transactions) throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        business.addTransactionsNew(transactions);
    }

    public Set<Transaction> getTransactionsNew(Set<Transaction> transactions) throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        return business.getTransactionsNew(transactions);
    }

    public BusinessIssue addBlankBusinessIssue() throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        return business.addBlankBusinessIssue();
    }

    public Batch addBlankBatch() throws Exception {
        Business business = this.getBusiness();
        if (business == null) {
            this.initBusiness();
            business = this.getBusiness();
        }
        return business.addBlankBatch();
    }

    public Transaction getCounterpartyTransaction(String counterpartyIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getCounterpartyTransaction(counterpartyIdentifier);
    }

    public Transaction getCounterpartyTransaction(Counterparty counterparty) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getCounterpartyTransaction(counterparty);
    }

    public Transaction getAccountTransaction(String accountIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getAccountTransaction(accountIdentifier);
    }

    public Transaction getAccountTransaction(Account account) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getAccountTransaction(account);
    }

    public Transaction getHomeOfficeTransaction(String homeOfficeIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getHomeOfficeTransaction(homeOfficeIdentifier);
    }

    public Transaction getHomeOfficeTransaction(HomeOffice homeOffice) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getHomeOfficeTransaction(homeOffice);
    }

    public Transaction getFuelTaxCreditTransaction(String fuelTaxCreditIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getFuelTaxCreditTransaction(fuelTaxCreditIdentifier);
    }

    public Transaction getFuelTaxCreditTransaction(FuelTaxCredit fuelTaxCredit) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getFuelTaxCreditTransaction(fuelTaxCredit);
    }

    public Transaction getImportDataTransaction(String importDataIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getImportDataTransaction(importDataIdentifier);
    }

    public Transaction getProvisionTransaction(String provisionIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getProvisionTransaction(provisionIdentifier);
    }

    public Transaction getProvisionTransaction(Provision provision) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getProvisionTransaction(provision);
    }

    public Provision getProvisionTransactionProvision(Provision provision) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getProvisionTransactionProvision(provision);
    }

    public Transaction getBatchTransaction(String batchIdentifier) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getBatchTransaction(batchIdentifier);
    }

    public Transaction getBatchTransaction(Batch batch) {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getBatchTransaction(batch);
    }

    public void deleteBatch(String batchIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete batch transaction specified, business is null");
        }
        b.deleteBatchTransaction(batchIdentifier);
    }

    public boolean usesBatchIdentifier(String batchIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesBatchIdentifier(batchIdentifier);
    }

    public void deleteAccount(String accountIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete account transaction specified, business is null");
        }
        b.deleteAccountTransaction(accountIdentifier);
    }

    public void deleteHomeOffice(String homeOfficeIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete home office transaction specified, business is null");
        }
        b.deleteHomeOfficeTransaction(homeOfficeIdentifier);
    }

    public void deleteFuelTaxCredit(String fuelTaxCreditIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete fuel tax credit transaction specified, business is null");
        }
        b.deleteFuelTaxCreditTransaction(fuelTaxCreditIdentifier);
    }

    public void deleteImportData(String importDataIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete import data transaction specified, business is null");
        }
        b.deleteImportDataTransaction(importDataIdentifier);
    }

    public void deleteTransactions(Set transactions) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete transactions specified, business is null");
        }
        b.deleteTransactions(transactions);
    }

    public boolean usesAccountIdentifier(String accountIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesAccountIdentifier(accountIdentifier);
    }

    public boolean usesHomeOfficeIdentifier(String homeOfficeIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesHomeOfficeIdentifier(homeOfficeIdentifier);
    }

    public boolean usesFuelTaxCreditIdentifier(String fuelTaxCreditIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesFuelTaxCreditIdentifier(fuelTaxCreditIdentifier);
    }

    public boolean usesImportDataIdentifier(String importDataIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesImportDataIdentifier(importDataIdentifier);
    }

    public void deleteProvision(String provisionIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete provision transaction specified, business is null");
        }
        b.deleteProvisionTransaction(provisionIdentifier);
    }

    public boolean usesProvisionIdentifier(String provisionIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesProvisionIdentifier(provisionIdentifier);
    }

    public void deleteCounterparty(String counterpartyIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            throw new Exception("Error, cannot delete counterparty transaction specified, business is null");
        }
        b.deleteCounterpartyTransaction(counterpartyIdentifier);
    }

    public boolean usesCounterpartyIdentifier(String counterpartyIdentifier) throws Exception {
        Business b = this.getBusiness();
        if (b == null) {
            return false;
        }
        return b.usesCounterpartyIdentifier(counterpartyIdentifier);
    }

    public static String getNamespacePrefix(String namespace) {
        if (namespacetoprefix == null) {
            namespacetoprefix = new HashMap();
            namespacetoprefix.put("http://www.xbrl.org/2003/instance", "xbrli");
            namespacetoprefix.put("http://www.xbrl.org/2003/linkbase", "link");
            namespacetoprefix.put("http://www.w3.org/1999/xlink", "xlink");
            namespacetoprefix.put("http://xbrl.org/2006/xbrldi", "xbrldi");
            namespacetoprefix.put("http://www.xbrl.org/2003/iso4217", "iso4217");
            namespacetoprefix.put("http://xbrl.org/2005/xbrldt", "xbrldt");
            namespacetoprefix.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            namespacetoprefix.put("http://sbr.gov.au/rprt/ato/as/as.0001.private.02.00.module", "as.0001.prv");
            namespacetoprefix.put("http://sbr.gov.au/rprt/ato/as/as.0001.list.request.02.00.report", "as.0001");
            namespacetoprefix.put("http://sbr.gov.au/dims/LiabEstMethod.02.00.dims", "h03.02.00");
            namespacetoprefix.put("http://sbr.gov.au/dims/RprtPyType.02.00.dims", "h04.02.00");
            namespacetoprefix.put("http://sbr.gov.au/dims/TaxOblgtn.02.00.dims", "h05.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/py/pyde/pyde.02.00.data", "pyde.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/py/pyid/pyid.02.00.data", "pyid.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "pyin.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/rvc/rvctc/rvctc1.02.00.data", "rvctc1.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/rvc/rvctc/rvctc2.02.00.data", "rvctc2.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/rvc/rvctc/rvctc3.02.00.data", "rvctc3.02.00");
            namespacetoprefix.put("http://sbr.gov.au/fdtn/sbr.01.02.tech", "tech.01.02");
            namespacetoprefix.put("http://sbr.gov.au/rprt/ato/as/as.0001.prelodge.request.02.00.report", "as.0001");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.organisationname1.02.00.module", "orgname1.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/baf/bafpr/bafpr2.02.00.data", "bafpr2.02.00");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.taxrate1.02.00.module", "taxrate.02.00");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.electroniccontactelectronicmail1.02.00.module", "email1.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/lr/lrla/lrla.02.00.data", "lrla.02.00");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.addressdetails1.02.00.module", "address1.02.00");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.electroniccontacttelephone1.02.00.module", "phone1.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/baf/bafot/bafot.02.00.data", "bafot.02.00");
            namespacetoprefix.put("http://sbr.gov.au/icls/baf/bafpr/bafpr1.02.00.data", "bafpr1.02.00");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.declaration1.02.00.module", "declaration.02.00");
            namespacetoprefix.put("http://sbr.gov.au/comnmdle/comnmdle.directcredit1.02.00.module", "directcredit1.02.00");
        }
        return namespacetoprefix.get(namespace);
    }

    public void loadFasV2ProvisionList(Document doc) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2ProvisionList(doc, el);
            }
        }
    }

    public void loadFasV2AccountList(Document doc) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2AccountList(doc, el);
            }
        }
    }

    public void loadFasV2AccountListMeasurable(Document doc) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2AccountListMeasurable(doc, el);
            }
        }
    }

    public void loadFasV2CounterypartyList(Document doc) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2CounterpartyList(doc, el);
            }
        }
    }

    public void loadFasV2ActivityStatementList(Document doc, String ledgerStartDateStr, String ledgerEndDateStr) throws Exception {
        throw new Exception("Error, AS import not implemented");
    }

    public void loadFasV2ActivityStatement(Document doc, String asNumber) throws Exception {
        throw new Exception("Error, AS import not implemented");
    }

    public void loadFasV2Transactions(Document doc, String ledgerStartDateStr, String ledgerEndDateStr, boolean has_general_journal_type) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2Transactions(doc, el, ledgerStartDateStr, ledgerEndDateStr, has_general_journal_type);
            }
        }
    }

    public void loadFasV2Batches(Document doc, String ledgerStartDateStr, String ledgerEndDateStr) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2Batches(doc, el, ledgerStartDateStr, ledgerEndDateStr);
            }
        }
    }

    public void loadFasV2AddPaySlipBatches(Document doc, String ledgerStartDateStr, String ledgerEndDateStr) throws Exception {
        Element root;
        Business b = this.getBusiness();
        if (b == null) {
            this.initBusiness();
            b = this.getBusiness();
        }
        if (b != null && (root = doc.getDocumentElement()) != null) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountingEntries")) continue;
                b.loadFasV2AddPaySlipBatches(doc, el, ledgerStartDateStr, ledgerEndDateStr);
            }
        }
    }

    public LastUpdateIdentifier getLastUpdateIdentifier() {
        Business b = this.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getLastUpdateIdentifier();
    }

    public int getBusinessMasterFileUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getBusinessMasterFileUpdateIdentifier();
    }

    public int getAccountUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getAccountUpdateIdentifier();
    }

    public int getProvisionUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getProvisionUpdateIdentifier();
    }

    public int getCounterpartyUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getCounterpartyUpdateIdentifier();
    }

    public int getDivisionUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getDivisionUpdateIdentifier();
    }

    public int getJobUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getJobUpdateIdentifier();
    }

    public int getHomeOfficeUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getHomeOfficeUpdateIdentifier();
    }

    public int getFuelTaxCreditUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getFuelTaxCreditUpdateIdentifier();
    }

    public int getTransactionUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTransactionUpdateIdentifier();
    }

    public int getTaxReturnUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTaxReturnUpdateIdentifier();
    }

    public int getActivityStatementUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getActivityStatementUpdateIdentifier();
    }

    public int getReconciliationUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getReconciliationUpdateIdentifier();
    }

    public int getBusinessMasterFilePreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getBusinessMasterFilePreviousUpdateIdentifier();
    }

    public int getAccountPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getAccountPreviousUpdateIdentifier();
    }

    public int getProvisionPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getProvisionPreviousUpdateIdentifier();
    }

    public int getCounterpartyPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getCounterpartyPreviousUpdateIdentifier();
    }

    public int getDivisionPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getDivisionPreviousUpdateIdentifier();
    }

    public int getJobPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getJobPreviousUpdateIdentifier();
    }

    public int getHomeOfficePreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getHomeOfficePreviousUpdateIdentifier();
    }

    public int getFuelTaxCreditPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getFuelTaxCreditPreviousUpdateIdentifier();
    }

    public int getTransactionPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTransactionPreviousUpdateIdentifier();
    }

    public int getTaxReturnPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTaxReturnPreviousUpdateIdentifier();
    }

    public int getActivityStatementPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getActivityStatementPreviousUpdateIdentifier();
    }

    public int getReconciliationPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getReconciliationPreviousUpdateIdentifier();
    }
}

