/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.SBRContexts;
import java.util.List;
import java.util.Set;
import javafx.beans.property.SimpleStringProperty;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixStringElement
extends GlenixAbstractElement {
    protected SimpleStringProperty value = new SimpleStringProperty();
    protected String isEditable = null;
    protected String isVisible = null;

    public GlenixStringElement(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext) {
        this.namespace = namespace;
        this.name = name;
        this.sbrNamespace = sbrNamespace;
        this.sbrName = sbrName;
        this.sbrContext = sbrContext;
    }

    public GlenixStringElement(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext, String value) {
        this.namespace = namespace;
        this.name = name;
        this.sbrNamespace = sbrNamespace;
        this.sbrName = sbrName;
        this.sbrContext = sbrContext;
        this.value.setValue(value);
    }

    public void setGlenixElementIsEditable(String isEditable) throws Exception {
        if (isEditable == null) {
            this.isEditable = null;
        } else if (isEditable.equals("false")) {
            this.isEditable = "false";
        } else if (isEditable.equals("true")) {
            this.isEditable = "true";
        } else {
            throw new Exception("Error, invalid value for attribute isEditable, " + isEditable);
        }
    }

    public String getIsEditable() {
        return this.isEditable;
    }

    public void setGlenixElementIsVisible(String isVisible) throws Exception {
        if (isVisible == null) {
            this.isVisible = null;
        } else if (isVisible.equals("false")) {
            this.isVisible = "false";
        } else if (isVisible.equals("true")) {
            this.isVisible = "true";
        } else {
            throw new Exception("Error, invalid value for attribute isVisible, " + isVisible);
        }
    }

    public String getIsVisible() {
        return this.isVisible;
    }

    public void setGlenixElementValue(String value) {
        if (value != null && value.isEmpty()) {
            value = null;
        }
        this.value.setValue(value);
    }

    public void setGlenixElementValue(SimpleStringProperty value) {
        if (value == null) {
            this.setGlenixElementValue((String)null);
            return;
        }
        this.setGlenixElementValue(value.getValue());
    }

    @Override
    public String getGlenixElementValue() {
        return this.value.getValue();
    }

    public SimpleStringProperty getGlenixElementProperty() {
        return this.value;
    }

    @Override
    public String getGlenixElementKeyValue() {
        return this.getGlenixElementValue();
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(this.getGlenixElementNamespace()) && element.getLocalName() != null && element.getLocalName().equals(this.getGlenixElementName())) {
            String isVisible;
            if (element instanceof CharacterData) {
                this.setGlenixElementValue(((CharacterData)((Object)element)).getData());
            } else {
                this.setGlenixElementValue(element.getTextContent());
            }
            String isEditable = element.getAttributeNS("http://www.glenix.com.au/", "isEditable");
            if (isEditable != null && !isEditable.isEmpty()) {
                this.setGlenixElementIsEditable(isEditable);
            }
            if ((isVisible = element.getAttributeNS("http://www.glenix.com.au/", "isVisible")) != null && !isVisible.isEmpty()) {
                this.setGlenixElementIsVisible(isVisible);
            }
            return;
        }
        throw new Exception("Error, trying to load incorrect document element into " + this.getGlenixElementNamespace() + ":" + this.getGlenixElementName() + " trying to load " + element.getNamespaceURI() + ":" + element.getLocalName());
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        this.loadDocumentElement(doc, element);
    }

    @Override
    public void appendToElement(Document document, Element element) throws Exception {
        if (document == null || element == null) {
            throw new Exception("GlenixStringElement error, append to element but document or element provided is null");
        }
        Element child = null;
        if ("http://www.glenix.com.au/".equals(this.namespace)) {
            child = document.createElementNS(this.namespace, "gx:" + this.name);
            child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        } else {
            child = document.createElementNS(this.namespace, this.name);
        }
        child.setTextContent(this.value.getValue());
        if (this.isEditable != null) {
            child.setAttributeNS("http://www.glenix.com.au/", "gx:isEditable", this.isEditable);
        }
        if (this.isVisible != null) {
            child.setAttributeNS("http://www.glenix.com.au/", "gx:isVisible", this.isVisible);
        }
        element.appendChild(child);
    }

    @Override
    public void appendToElement(Document document) throws Exception {
        if (document == null) {
            throw new Exception("GlenixStringElement error, append to element but document provided is null");
        }
        Element child = document.createElementNS(this.namespace, this.name);
        child.setTextContent(this.value.getValue());
        if (this.isEditable != null) {
            child.setAttributeNS("http://www.glenix.com.au/", "gx:isEditable", this.isEditable);
        }
        if (this.isVisible != null) {
            child.setAttributeNS("http://www.glenix.com.au/", "gx:isVisible", this.isVisible);
        }
        document.appendChild(child);
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getGlenixElementValue();
    }

    @Override
    public Set<String> getChildElementNameSet() {
        return null;
    }

    @Override
    public List<GlenixElement> getChildElementSet(String elementName) {
        return null;
    }

    @Override
    public boolean loadSBRDocumentElement(Document doc, Element element, SBRContexts contexts, boolean lodgeOK) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(this.getSBRNamespace()) && element.getLocalName() != null && element.getLocalName().equals(this.getSBRName())) {
            String contextId = element.getAttribute("contextRef");
            if (contextId == null) {
                throw new Exception("Error, " + this.getGlenixElementName() + " cannot process SBR element " + element.getLocalName() + " as it has no contextRef");
            }
            String glenixSBRContext = contexts.getGlenixSBRContextRef(contextId);
            if (glenixSBRContext == null) {
                throw new Exception("Error, " + this.getGlenixElementName() + " cannot process SBR element " + element.getLocalName() + " as it has no understood contextRef for " + contextId);
            }
            if (glenixSBRContext.equals(this.getSBRContext())) {
                String isVisible;
                this.setGlenixElementValue(element.getTextContent());
                String isEditable = element.getAttributeNS("http://sbr.gov.au/fdtn/sbr.02.00.tech", "isEditable");
                if (isEditable != null && !isEditable.isEmpty()) {
                    this.setGlenixElementIsEditable(isEditable);
                }
                if ((isVisible = element.getAttributeNS("http://sbr.gov.au/fdtn/sbr.02.00.tech", "isVisible")) != null && !isVisible.isEmpty()) {
                    this.setGlenixElementIsVisible(isVisible);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getChildIsLeaf(String childName) {
        return true;
    }

    @Override
    public String getSBRUnitRef() {
        return null;
    }

    @Override
    public String getSBRDecimals() {
        return null;
    }

    @Override
    public boolean buildSBRElement(Document doc, Element element) {
        String value;
        String name = this.getSBRName();
        String namespace = this.getSBRNamespace();
        String nsp = "tns";
        Element nextElement = element;
        if (name != null && (value = this.getGlenixElementValue()) != null && !value.isEmpty()) {
            Element child = nsp != null ? doc.createElementNS(namespace, nsp + ":" + name) : doc.createElementNS(namespace, name);
            child.setTextContent(value);
            nextElement = child;
            if (element == null) {
                doc.appendChild(child);
            } else {
                element.appendChild(child);
            }
            return true;
        }
        return false;
    }

    @Override
    public void buildActivityStatementElement(Document doc, Element element, boolean childIsLeaf) {
        String name = this.getSBRName();
        String namespace = this.getSBRNamespace();
        String nsp = GlenixTrnXBRL.getNamespacePrefix(namespace);
        String context = this.getSBRContext();
        String unit = this.getSBRUnitRef();
        String decimals = this.getSBRDecimals();
        Element nextElement = element;
        if (name != null) {
            Element child = nsp != null ? doc.createElementNS(namespace, nsp + ":" + name) : doc.createElementNS(namespace, name);
            if (childIsLeaf) {
                String value = this.getGlenixElementValue();
                if (context != null && !context.isEmpty()) {
                    child.setAttribute("contextRef", context);
                }
                if (value != null && !value.isEmpty() && decimals != null && !decimals.isEmpty()) {
                    child.setAttribute("decimals", decimals);
                }
                if (unit != null && !unit.isEmpty()) {
                    child.setAttribute("unitRef", unit);
                }
                if (value == null || value.isEmpty()) {
                    child.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
                } else {
                    child.setTextContent(value);
                }
            }
            nextElement = child;
            element.appendChild(child);
        }
    }
}

