/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixPureElement;
import au.com.glenix.trn.GlenixTrnXBRL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixFractionElement
extends GlenixPureElement {
    public GlenixFractionElement(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext) {
        super(namespace, name, sbrNamespace, sbrName, sbrContext);
    }

    public GlenixFractionElement(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext, String value) {
        super(namespace, name, sbrNamespace, sbrName, sbrContext, value);
    }

    @Override
    public boolean buildSBRElement(Document doc, Element element) {
        String value;
        String name = this.getSBRName();
        String namespace = this.getSBRNamespace();
        String nsp = "tns";
        if (name != null && (value = this.getGlenixElementValue()) != null && !value.isEmpty()) {
            Element child = nsp != null ? doc.createElementNS(namespace, nsp + ":" + name) : doc.createElementNS(namespace, name);
            Element numerator = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:numerator");
            numerator.setTextContent(value);
            child.appendChild(numerator);
            Element denominator = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:denominator");
            denominator.setTextContent("1");
            child.appendChild(denominator);
            if (element == null) {
                doc.appendChild(child);
            } else {
                element.appendChild(child);
            }
            return true;
        }
        return false;
    }

    @Override
    public void buildActivityStatementElement(Document doc, Element element, boolean childIsLeaf) {
        String name = this.getSBRName();
        String namespace = this.getSBRNamespace();
        String nsp = GlenixTrnXBRL.getNamespacePrefix(namespace);
        String context = this.getSBRContext();
        String unit = this.getSBRUnitRef();
        String decimals = this.getSBRDecimals();
        Element nextElement = element;
        if (name != null) {
            Element child = nsp != null ? doc.createElementNS(namespace, nsp + ":" + name) : doc.createElementNS(namespace, name);
            if (childIsLeaf) {
                String value = this.getGlenixElementValue();
                if (context != null && !context.isEmpty()) {
                    child.setAttribute("contextRef", context);
                }
                if (value != null && !value.isEmpty() && decimals != null && !decimals.isEmpty()) {
                    child.setAttribute("decimals", decimals);
                }
                if (unit != null && !unit.isEmpty()) {
                    child.setAttribute("unitRef", unit);
                }
                if (value == null || value.isEmpty()) {
                    child.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
                } else {
                    Element numerator = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:numerator");
                    numerator.setTextContent(value);
                    child.appendChild(numerator);
                    Element denominator = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:denominator");
                    denominator.setTextContent("1");
                    child.appendChild(denominator);
                }
            }
            nextElement = child;
            element.appendChild(child);
        }
    }
}

