/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixElement;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class GlenixElementChildList {
    protected String namespace = null;
    protected String name = null;
    protected String sbrNamespace = null;
    protected String sbrName = null;
    protected String sbrContext = null;
    protected Class theclass;
    protected String className = null;
    protected int maxChildren = -1;
    protected boolean childIsLeaf = false;
    ArrayList children = new ArrayList();

    public GlenixElementChildList(Class theclass, String namespace, String name, String sbrNamespace, String sbrName, String sbrContext, int maxChildren, boolean childIsLeaf) {
        this.namespace = namespace;
        this.name = name;
        this.sbrNamespace = sbrNamespace;
        this.sbrName = sbrName;
        this.sbrContext = sbrContext;
        this.theclass = theclass;
        this.maxChildren = maxChildren;
        this.childIsLeaf = childIsLeaf;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSBRName() {
        return this.sbrName;
    }

    public String getSBRNamespace() {
        return this.sbrNamespace;
    }

    public String getSBRContext() {
        return this.sbrContext;
    }

    public void setGlenixElementNamespace(String value) {
        this.namespace = value;
    }

    public void setGlenixElementName(String value) {
        this.name = value;
    }

    public void setSBRNamespace(String value) {
        this.sbrNamespace = value;
    }

    public void setSBRName(String value) {
        this.sbrName = value;
    }

    public void setSBRContext(String value) {
        this.sbrContext = value;
    }

    public void setMaxChildren(int value) {
        this.maxChildren = value;
    }

    public void setChildIsLeaf(boolean value) {
        this.childIsLeaf = value;
    }

    public void setTheClassName(String className) {
        try {
            Class<?> aclass = Class.forName(className);
            if (aclass != null) {
                this.theclass = aclass;
                this.className = className;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getTheClassName() {
        return this.className;
    }

    public Class getTheClass() {
        return this.theclass;
    }

    public String getGlenixElementName() {
        return this.getName();
    }

    public String getGlenixElementNamespace() {
        return this.getName();
    }

    public GlenixElement addChild() throws Exception {
        if (this.maxChildren == this.children.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        Constructor constructor = null;
        GlenixElement child = null;
        try {
            constructor = this.getTheClass().getConstructor(String.class, String.class, String.class, String.class, String.class);
            child = (GlenixElement)constructor.newInstance(this.namespace, this.name, this.sbrNamespace, this.sbrName, this.sbrContext);
        }
        catch (NoSuchMethodException nsme) {
            constructor = this.getTheClass().getConstructor(new Class[0]);
            child = (GlenixElement)constructor.newInstance(new Object[0]);
        }
        this.children.add(child);
        return child;
    }

    public void addChild(GlenixElement child) throws Exception {
        if (this.maxChildren == this.children.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        if (!this.getTheClass().isInstance(child)) {
            throw new Exception("Error, trying to add a child of the incorrect class. Name = " + this.name + " class = " + child.getClass() + " should be " + this.theclass);
        }
        this.children.add(child);
    }

    public void addChildAll(Set childs) throws Exception {
        if (this.maxChildren == this.children.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        if (this.maxChildren >= 0 && this.maxChildren <= this.children.size() + childs.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        for (Object o : childs) {
            if (this.getTheClass().isInstance(o)) continue;
            throw new Exception("Error, trying to add a child of the incorrect class. Name = " + this.name + " class = " + o.getClass() + " should be " + this.theclass);
        }
        this.children.addAll(childs);
    }

    public void addChildNew(Set childs) throws Exception {
        if (this.maxChildren == this.children.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        if (this.maxChildren >= 0 && this.maxChildren <= this.children.size() + childs.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        HashSet newChilds = new HashSet();
        for (Object ge : childs) {
            if (childs.contains(ge)) continue;
            newChilds.add(ge);
        }
        for (Object o : newChilds) {
            if (this.getTheClass().isInstance(o)) continue;
            throw new Exception("Error, trying to add a child of the incorrect class. Name = " + this.name + " class = " + o.getClass() + " should be " + this.theclass);
        }
        this.children.addAll(newChilds);
    }

    public Set getChildNew(Set childs) throws Exception {
        HashSet newChilds = new HashSet();
        if (childs != null) {
            for (Object ge : childs) {
                if (this.children.contains(ge)) continue;
                newChilds.add(ge);
            }
        }
        return newChilds;
    }

    public GlenixElement addChild(String value) throws Exception {
        if (this.maxChildren == this.children.size()) {
            throw new Exception("Error trying to exceed max children. Max is " + this.maxChildren + ". Name = " + this.name);
        }
        Constructor constructor = null;
        GlenixElement child = null;
        try {
            constructor = this.getTheClass().getConstructor(String.class, String.class, String.class, String.class, String.class, String.class);
            child = (GlenixElement)constructor.newInstance(this.namespace, this.name, this.sbrNamespace, this.sbrName, this.sbrContext, value);
        }
        catch (NoSuchMethodException nsme) {
            constructor = this.getTheClass().getConstructor(String.class);
            child = (GlenixElement)constructor.newInstance(value);
        }
        this.children.add(child);
        return child;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public GlenixElement removeChild(int index) {
        return (GlenixElement)this.children.remove(index);
    }

    public void removeChild(GlenixElement glenixElement) {
        this.children.remove(glenixElement);
    }

    public void removeChildCollection(Collection<? extends GlenixElement> removeCollection) {
        this.children.removeAll(removeCollection);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public GlenixElement getChild(int index) {
        if (index >= this.getChildCount()) {
            return null;
        }
        return (GlenixElement)this.children.get(index);
    }

    public boolean getChildIsLeaf() {
        return this.childIsLeaf;
    }

    public ObservableList<GlenixElement> getObservableList() {
        ObservableList observableList = FXCollections.observableArrayList((Collection)this.children);
        return FXCollections.unmodifiableObservableList((ObservableList)observableList);
    }

    public List<GlenixElement> getList() {
        return Collections.unmodifiableList(this.children);
    }

    public ArrayList getArrayListNoType() {
        return this.children;
    }
}

