/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.SBRContexts;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GlenixAbstractBranchElement
extends GlenixAbstractElement {
    LinkedHashMap<String, GlenixElementChildList> childrenAndMeta = new LinkedHashMap();

    public void addChildElement(Document doc, Element childElement) throws Exception {
        String localName = childElement.getLocalName();
        if (localName == null) {
            throw new Exception("Error: " + this.getGlenixElementName() + " attempt to add element, with null local name.");
        }
        GlenixElementChildList glenixElementChildList = this.childrenAndMeta.get(this.convertName(localName));
        if (glenixElementChildList == null) {
            throw new Exception("Corrupted file trying to load " + localName + " into " + this.getGlenixElementName());
        }
        String namespace = glenixElementChildList.getNamespace();
        if (namespace == null && childElement.getNamespaceURI() != null) {
            throw new Exception("Error: " + this.getGlenixElementName() + " attempt to add element, " + localName + ", with namespace but was expecting no namespace");
        }
        if (namespace != null && !namespace.equals(childElement.getNamespaceURI())) {
            throw new Exception("Error: " + this.getGlenixElementName() + " attempt to add element, " + localName + ", with incorrect namespace, " + childElement.getNamespaceURI());
        }
        if (glenixElementChildList == null) {
            throw new Exception("Error: " + this.getGlenixElementName() + " is invalid child for " + localName);
        }
        GlenixElement child = glenixElementChildList.addChild();
        child.loadDocumentElement(doc, childElement);
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(this.getGlenixElementNamespace()) && element.getLocalName() != null && (element.getLocalName().equals(this.getGlenixElementName()) || this.convertName(element.getLocalName()).equals(this.getGlenixElementName()))) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixElement ge;
                Element el;
                GlenixElementChildList gecl;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (gecl = this.childrenAndMeta.get(this.convertName((el = (Element)node).getLocalName()))) == null) continue;
                boolean loaded = false;
                int maxC = gecl.getMaxChildren();
                if (maxC == 1 && (ge = gecl.getChild(0)) != null) {
                    ge.loadDocumentElement(doc, el);
                    loaded = true;
                }
                if (loaded) continue;
                this.addChildElement(doc, el);
            }
            return;
        }
        throw new Exception("Error: attempt to load " + element.getLocalName() + " into " + this.getGlenixElementName());
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(this.getGlenixElementNamespace()) && element.getLocalName() != null && (element.getLocalName().equals(this.getGlenixElementName()) || this.convertName(element.getLocalName()).equals(this.getGlenixElementName()))) {
            for (String key : this.childrenAndMeta.keySet()) {
                GlenixElementChildList gecl = this.childrenAndMeta.get(key);
                int maxC = gecl.getMaxChildren();
                if (maxC != -1 && maxC <= 1) continue;
                gecl.clearChildren();
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixElement ge;
                Element el;
                GlenixElementChildList gecl;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (gecl = this.childrenAndMeta.get(this.convertName((el = (Element)node).getLocalName()))) == null) continue;
                boolean loaded = false;
                int maxC = gecl.getMaxChildren();
                if (maxC == 1 && (ge = gecl.getChild(0)) != null) {
                    ge.loadDocumentElementOverwrite(doc, el);
                    loaded = true;
                }
                if (loaded) continue;
                this.addChildElement(doc, el);
            }
            return;
        }
        throw new Exception("Error: attempt to load " + element.getLocalName() + " into " + this.getGlenixElementName());
    }

    @Override
    public void appendToElement(Document document, Element element) throws Exception {
        if (document == null || element == null) {
            throw new Exception("Error, append to element but document or element provided is null");
        }
        Element child = null;
        child = "http://www.glenix.com.au/".equals(this.namespace) ? document.createElementNS(this.namespace, "gx:" + this.name) : document.createElementNS(this.namespace, this.name);
        element.appendChild(child);
        for (String key : this.childrenAndMeta.keySet()) {
            GlenixElementChildList glenixElementChildList = this.childrenAndMeta.get(key);
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                GlenixElement ge = glenixElementChildList.getChild(i);
                ge.appendToElement(document, child);
            }
        }
    }

    @Override
    public void appendToElement(Document document) throws Exception {
        if (document == null) {
            throw new Exception("Error, append to element but document provided is null");
        }
        Element child = null;
        if ("http://www.glenix.com.au/".equals(this.namespace)) {
            child = document.createElementNS(this.namespace, "gx:" + this.name);
            child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        } else {
            child = document.createElementNS(this.namespace, this.name);
        }
        document.appendChild(child);
        for (String key : this.childrenAndMeta.keySet()) {
            GlenixElementChildList glenixElementChildList = this.childrenAndMeta.get(key);
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                GlenixElement ge = glenixElementChildList.getChild(i);
                ge.appendToElement(document, child);
            }
        }
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getGlenixElementName() + "_" + this.toString();
    }

    @Override
    public String getGlenixElementKeyValue() {
        return this.getGlenixElementKeyId();
    }

    @Override
    public Set<String> getChildElementNameSet() {
        return this.childrenAndMeta.keySet();
    }

    @Override
    public List<GlenixElement> getChildElementSet(String elementName) {
        GlenixElementChildList gecl = this.childrenAndMeta.get(elementName);
        if (gecl == null) {
            return null;
        }
        return gecl.getList();
    }

    @Override
    public String getGlenixElementValue() {
        return null;
    }

    protected GlenixElement getOrAddChild(String childName) throws Exception {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return glenixElementChildList.addChild();
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    protected GlenixElement getOrAddChild(GlenixElementChildList glenixElementChildList) throws Exception {
        if (glenixElementChildList == null) {
            return null;
        }
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return glenixElementChildList.addChild();
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    @Override
    public boolean loadSBRDocumentElement(Document doc, Element element, SBRContexts contexts, boolean lodgeOK) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(this.getSBRNamespace()) && element.getLocalName() != null && element.getLocalName().equals(this.getSBRName())) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixElementChildList cl;
                GlenixElement ge;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element_child = (Element)node;
                boolean subresult = false;
                Iterator<GlenixElementChildList> iterator = this.childrenAndMeta.values().iterator();
                while (iterator.hasNext() && !(subresult = (ge = this.getOrAddChild(cl = iterator.next())).loadSBRDocumentElement(doc, element_child, contexts, lodgeOK))) {
                }
                if (subresult) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean getChildIsLeaf(String childName) {
        if (childName == null) {
            return true;
        }
        GlenixElementChildList gecl = this.childrenAndMeta.get(childName);
        if (gecl == null) {
            return true;
        }
        return gecl.getChildIsLeaf();
    }

    @Override
    public String getSBRUnitRef() {
        return null;
    }

    @Override
    public String getSBRDecimals() {
        return null;
    }

    public void removeChildElementCollection(String elementName, Collection<GlenixElement> removeCollection) {
        GlenixElementChildList gecl = this.childrenAndMeta.get(elementName);
        if (gecl == null) {
            return;
        }
        gecl.removeChildCollection(removeCollection);
    }

    protected boolean buildSBRElementChildElementSet(Document doc, Element nextElement, String childName) {
        boolean result = false;
        List<GlenixElement> childGEs = this.getChildElementSet(childName);
        for (GlenixElement ge_child : childGEs) {
            boolean subresult = ge_child.buildSBRElement(doc, nextElement);
            if (!subresult) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean buildSBRElement(Document doc, Element element) {
        String name = this.getSBRName();
        String namespace = this.getSBRNamespace();
        String nsp = "tns";
        Element nextElement = element;
        if (name != null) {
            Element child = nsp != null ? doc.createElementNS(namespace, nsp + ":" + name) : doc.createElementNS(namespace, name);
            nextElement = child;
            if (element == null) {
                doc.appendChild(child);
                child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", namespace);
            } else {
                element.appendChild(child);
            }
        }
        boolean result = false;
        Set<String> childNames = this.getChildElementNameSet();
        if (childNames != null) {
            for (String childName : childNames) {
                boolean subresult = this.buildSBRElementChildElementSet(doc, nextElement, childName);
                if (!subresult) continue;
                result = true;
            }
        }
        if (!result && name != null) {
            if (element == null) {
                doc.removeChild(nextElement);
            } else {
                element.removeChild(nextElement);
            }
        }
        return result;
    }

    protected String generateTimestamp() {
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return isoFormat.format(date);
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    @Override
    public void buildActivityStatementElement(Document doc, Element element, boolean childIsLeaf) {
        Set<String> childNames;
        String name = this.getSBRName();
        String namespace = this.getSBRNamespace();
        String nsp = GlenixTrnXBRL.getNamespacePrefix(namespace);
        String context = this.getSBRContext();
        String unit = this.getSBRUnitRef();
        String decimals = this.getSBRDecimals();
        Element nextElement = element;
        if (name != null) {
            Element child = nsp != null ? doc.createElementNS(namespace, nsp + ":" + name) : doc.createElementNS(namespace, name);
            if (childIsLeaf) {
                String value = this.getGlenixElementValue();
                if (context != null && !context.isEmpty()) {
                    child.setAttribute("contextRef", context);
                }
                if (value != null && !value.isEmpty() && decimals != null && !decimals.isEmpty()) {
                    child.setAttribute("decimals", decimals);
                }
                if (unit != null && !unit.isEmpty()) {
                    child.setAttribute("unitRef", unit);
                }
                if (value == null || value.isEmpty()) {
                    child.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
                } else {
                    child.setTextContent(value);
                }
            }
            nextElement = child;
            element.appendChild(child);
        }
        if (!childIsLeaf && (childNames = this.getChildElementNameSet()) != null) {
            for (String childName : childNames) {
                List<GlenixElement> childGEs = this.getChildElementSet(childName);
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, nextElement, this.getChildIsLeaf(childName));
                }
            }
        }
    }

    @Override
    public void setSBRContext(String value) {
        super.setSBRContext(value);
        for (GlenixElementChildList cl : this.childrenAndMeta.values()) {
            for (GlenixElement ge : cl.getList()) {
                ge.setSBRContext(value);
            }
        }
    }

    protected String convertName(String name) {
        return name;
    }
}

