/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.SBRContexts;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventItem
extends GlenixAbstractBranchElement {
    public EventItem(String namespace, String name, String sbrNamespace, String sbrName, String sbrContext) {
        this.namespace = namespace;
        this.name = name;
        this.sbrNamespace = sbrNamespace;
        this.sbrName = sbrName;
        this.sbrContext = sbrContext;
        this.childrenAndMeta.put("EventItemNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "EventItemNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("Error.Code", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Error.Code", null, null, null, 1, true));
        this.childrenAndMeta.put("Severity.Code", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Severity.Code", null, null, null, 1, true));
        this.childrenAndMeta.put("Short.Description", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Short.Description", null, null, null, 1, true));
        this.childrenAndMeta.put("Detailed.Description", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Detailed.Description", null, null, null, 1, true));
        this.childrenAndMeta.put("Locations", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Locations", null, null, null, 1, true));
        this.childrenAndMeta.put("Parameters", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Parameters", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public boolean loadSBRDocumentElement(Document doc, Element element, SBRContexts sbrContexts, boolean lodgeOK) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://sbr.gov.au/comn/event.02.data") && element.getLocalName() != null && element.getLocalName().equals("EventItem")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node Paramater_child;
                int k;
                String text;
                String identifier;
                String csv;
                String prefix;
                GlenixStringElement ge;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element_child = (Element)node;
                if ("http://sbr.gov.au/comn/event.02.data".equals(element_child.getNamespaceURI()) && "Error.Code".equals(element_child.getLocalName())) {
                    ge = (GlenixStringElement)this.getOrAddChild("Error.Code");
                    ge.setGlenixElementValue(element_child.getTextContent());
                    continue;
                }
                if ("http://sbr.gov.au/comn/event.02.data".equals(element_child.getNamespaceURI()) && "Severity.Code".equals(element_child.getLocalName())) {
                    ge = (GlenixStringElement)this.getOrAddChild("Severity.Code");
                    ge.setGlenixElementValue(element_child.getTextContent());
                    continue;
                }
                if ("http://sbr.gov.au/comn/event.02.data".equals(element_child.getNamespaceURI()) && "Short.Description".equals(element_child.getLocalName())) {
                    ge = (GlenixStringElement)this.getOrAddChild("Short.Description");
                    ge.setGlenixElementValue(element_child.getTextContent());
                    continue;
                }
                if ("http://sbr.gov.au/comn/event.02.data".equals(element_child.getNamespaceURI()) && "Detailed.Description".equals(element_child.getLocalName())) {
                    ge = (GlenixStringElement)this.getOrAddChild("Detailed.Description");
                    NodeList nl = element_child.getChildNodes();
                    String nlndata = null;
                    for (int j = 0; j < nl.getLength(); ++j) {
                        Node nln = nl.item(j);
                        if (nln.getNodeType() != 4 || (nlndata = ((CharacterData)nln).getData()) == null) continue;
                        ge.setGlenixElementValue(nlndata);
                        break;
                    }
                    if (nlndata != null) continue;
                    String value = element_child.getTextContent();
                    if ((value = value.trim()).startsWith("<![CDATA[")) {
                        value = value.substring(9);
                        int endi = value.indexOf("]]>");
                        value = value.substring(0, endi);
                    }
                    ge.setGlenixElementValue(value);
                    continue;
                }
                if ("http://sbr.gov.au/comn/event.02.data".equals(element_child.getNamespaceURI()) && "Locations".equals(element_child.getLocalName())) {
                    NodeList Locations_childList = element_child.getChildNodes();
                    prefix = "";
                    csv = "";
                    for (int j = 0; j < Locations_childList.getLength(); ++j) {
                        Element Locations_childElement;
                        Node Paramaters_child = Locations_childList.item(j);
                        if (Paramaters_child.getNodeType() != 1 || !"http://sbr.gov.au/comn/event.02.data".equals((Locations_childElement = (Element)Paramaters_child).getNamespaceURI()) || !"Location".equals(Locations_childElement.getLocalName())) continue;
                        identifier = null;
                        text = null;
                        NodeList Location_childList = Locations_childElement.getChildNodes();
                        for (k = 0; k < Location_childList.getLength(); ++k) {
                            Paramater_child = Location_childList.item(k);
                            if (Paramater_child.getNodeType() != 1) continue;
                            Element Location_childElement = (Element)Paramater_child;
                            if ("http://sbr.gov.au/comn/event.02.data".equals(Location_childElement.getNamespaceURI()) && "Location.Instance.Identifier".equals(Location_childElement.getLocalName())) {
                                identifier = Location_childElement.getTextContent();
                                continue;
                            }
                            if (!"http://sbr.gov.au/comn/event.02.data".equals(Location_childElement.getNamespaceURI()) || !"Location.Path.Text".equals(Location_childElement.getLocalName())) continue;
                            text = Location_childElement.getTextContent();
                        }
                        if (identifier != null && text != null) {
                            csv = csv + prefix + identifier + "=" + text;
                            prefix = ",";
                            continue;
                        }
                        if (identifier == null) continue;
                        csv = csv + prefix + identifier;
                        prefix = ",";
                    }
                    if (csv.equals("")) continue;
                    GlenixStringElement ge2 = (GlenixStringElement)this.getOrAddChild("Locations");
                    ge2.setGlenixElementValue(csv);
                    continue;
                }
                if (!"http://sbr.gov.au/comn/event.02.data".equals(element_child.getNamespaceURI()) || !"Parameters".equals(element_child.getLocalName())) continue;
                NodeList Parameters_childList = element_child.getChildNodes();
                prefix = "";
                csv = "";
                for (int j = 0; j < Parameters_childList.getLength(); ++j) {
                    Element Parameters_childElement;
                    Node Parameters_child = Parameters_childList.item(j);
                    if (Parameters_child.getNodeType() != 1 || !"http://sbr.gov.au/comn/event.02.data".equals((Parameters_childElement = (Element)Parameters_child).getNamespaceURI()) || !"Parameter".equals(Parameters_childElement.getLocalName())) continue;
                    identifier = null;
                    text = null;
                    NodeList Parameter_childList = Parameters_childElement.getChildNodes();
                    for (k = 0; k < Parameter_childList.getLength(); ++k) {
                        Paramater_child = Parameter_childList.item(k);
                        if (Paramater_child.getNodeType() != 1) continue;
                        Element Parameter_childElement = (Element)Paramater_child;
                        if ("http://sbr.gov.au/comn/event.02.data".equals(Parameter_childElement.getNamespaceURI()) && "Parameter.Identifier".equals(Parameter_childElement.getLocalName())) {
                            identifier = Parameter_childElement.getTextContent();
                            continue;
                        }
                        if (!"http://sbr.gov.au/comn/event.02.data".equals(Parameter_childElement.getNamespaceURI()) || !"Parameter.Text".equals(Parameter_childElement.getLocalName())) continue;
                        text = Parameter_childElement.getTextContent();
                    }
                    if (identifier == null || text == null) continue;
                    csv = csv + prefix + identifier + "=" + text;
                    prefix = ",";
                }
                if (csv.equals("")) continue;
                GlenixStringElement ge3 = (GlenixStringElement)this.getOrAddChild("Parameters");
                ge3.setGlenixElementValue(csv);
            }
        }
        return true;
    }

    public String getSeverityCode() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Severity.Code");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public String getErrorCode() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Error.Code");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public String getShortDescription() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Short.Description");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public String getDetailedDescription() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Detailed.Description");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    private String insertParameters(String templateString) {
        String[] parts;
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Parameters");
        if (gse == null) {
            return templateString;
        }
        String params = gse.getGlenixElementValue();
        if (params == null || params.isEmpty()) {
            return templateString;
        }
        for (String part : parts = params.split(",")) {
            String[] partpart = part.split("=");
            if (partpart.length != 2) continue;
            templateString = templateString.replace("{" + partpart[0] + "}", partpart[1]);
        }
        return templateString;
    }

    public String getParsedShortDescription() {
        return this.insertParameters(this.getShortDescription());
    }

    public String getParsedDetailedDescription() {
        return this.insertParameters(this.getDetailedDescription());
    }

    public String getParsedLongestDescription() {
        String desc = this.getDetailedDescription();
        if (desc == null || desc.isEmpty()) {
            desc = this.getShortDescription();
        }
        return this.insertParameters(desc);
    }

    public String getParsedLongestDescriptionCode() {
        String desc = this.getDetailedDescription();
        if (desc == null || desc.isEmpty()) {
            desc = this.getShortDescription();
        }
        String result = this.insertParameters(desc);
        String code = this.getErrorCode();
        if (code != null && !code.isEmpty()) {
            return result + " (code: " + code + ")";
        }
        return result;
    }

    public String getParsedLongestDescriptionCodeLocation() {
        String desc = this.getDetailedDescription();
        if (desc == null || desc.isEmpty()) {
            desc = this.getShortDescription();
        }
        String result = this.insertParameters(desc);
        String code = this.getErrorCode();
        String location = this.getLocations();
        if (code != null && !code.isEmpty()) {
            if (location != null && !location.isEmpty()) {
                return result + " (code: " + code + ", location: " + location + ")";
            }
            return result + " (code: " + code + ")";
        }
        if (location != null && !location.isEmpty()) {
            return result + " (location: " + location + ")";
        }
        return result;
    }

    public String getCodeLocation() {
        String code = this.getErrorCode();
        String location = this.getLocations();
        if (code != null && !code.isEmpty()) {
            if (location != null && !location.isEmpty()) {
                return "(code: " + code + ", location: " + location + ")";
            }
            return "(code: " + code + ")";
        }
        if (location != null && !location.isEmpty()) {
            return "(location: " + location + ")";
        }
        return null;
    }

    public String getLocations() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Locations");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    @Override
    protected String convertName(String name) {
        if (name != null && !name.isEmpty() && name.equals("EventItem")) {
            return this.name;
        }
        return name;
    }
}

