/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.Address;
import au.com.glenix.trn.CounterpartyPayrollDetails;
import au.com.glenix.trn.CounterpartySuperDetails;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.trn.SuperProductDetails;
import java.util.ArrayList;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Counterparty
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public Counterparty() throws Exception {
        this.name = "counterparty";
        this.namespace = "http://www.glenix.com.au/";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("counterpartyIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyExternalIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyExternalIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyLegalName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyLegalName", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyTradingName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyTradingName", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyDescription", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyDescription", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyABN", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyABN", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyABNBranch", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyABNBranch", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyTFN", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyTFN", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyDateOfBirth", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyDateOfBirth", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyContactName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyContactName", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyEmailAddress", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyEmailAddress", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyTelephone", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyTelephone", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyAddress", new GlenixElementChildList(Address.class, "http://www.glenix.com.au/", "counterpartyAddress", null, null, null, 1, false));
        this.childrenAndMeta.put("counterpartyOtherDetails", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyOtherDetails", null, null, null, 1, true));
        this.childrenAndMeta.put("counterpartyPaymentReference", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "counterpartyPaymentReference", null, null, null, 1, true));
        this.childrenAndMeta.put("SBRDocumentTFND0004", new GlenixElementChildList(SBRDocumentTFND0004.class, "http://www.glenix.com.au/", "SBRDocumentTFND0004", null, null, null, -1, false));
        this.childrenAndMeta.put("counterpartyPayrollDetails", new GlenixElementChildList(CounterpartyPayrollDetails.class, "http://www.glenix.com.au/", "counterpartyPayrollDetails", null, null, null, 1, false));
        this.childrenAndMeta.put("counterpartySuperDetails", new GlenixElementChildList(CounterpartySuperDetails.class, "http://www.glenix.com.au/", "counterpartySuperDetails", null, null, null, 1, false));
        this.childrenAndMeta.put("superProductDetails", new GlenixElementChildList(SuperProductDetails.class, "http://www.glenix.com.au/", "superProductDetails", null, null, null, 1, false));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public String getCounterpartyIdentifier() {
        return this.getChildValue("counterpartyIdentifier");
    }

    public void setCounterpartyIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("counterpartyIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getCounterpartyLegalName() {
        return this.getChildValue("counterpartyLegalName");
    }

    public String getCounterpartyTradingName() {
        return this.getChildValue("counterpartyTradingName");
    }

    public String getCounterpartyDescription() {
        return this.getChildValue("counterpartyDescription");
    }

    public String getCounterpartyABN() {
        return this.getChildValue("counterpartyABN");
    }

    public String getCounterpartyPaymentReference() {
        return this.getChildValue("counterpartyPaymentReference");
    }

    public SimpleStringProperty getCounterpartyIdentifierProperty() {
        return this.getChildProperty("counterpartyIdentifier");
    }

    public SimpleStringProperty getCounterpartyLegalNameProperty() {
        return this.getChildProperty("counterpartyLegalName");
    }

    public SimpleStringProperty getCounterpartyTradingNameProperty() {
        return this.getChildProperty("counterpartyTradingName");
    }

    public SimpleStringProperty getCounterpartyDescriptionProperty() {
        return this.getChildProperty("counterpartyDescription");
    }

    public SimpleStringProperty getCounterpartyABNProperty() {
        return this.getChildProperty("counterpartyABN");
    }

    public SimpleStringProperty getCounterpartyPaymentReferenceProperty() {
        return this.getChildProperty("counterpartyPaymentReference");
    }

    public String getCounterpartyEmailAddress() {
        return this.getChildValue("counterpartyEmailAddress");
    }

    public SimpleStringProperty getCounterpartyEmailAddressProperty() {
        return this.getChildProperty("counterpartyEmailAddress");
    }

    public String getCounterpartyTelephone() {
        return this.getChildValue("counterpartyTelephone");
    }

    public SimpleStringProperty getCounterpartyTelephoneProperty() {
        return this.getChildProperty("counterpartyTelephone");
    }

    public Address getCounterpartyAddress() {
        return (Address)this.getChild("counterpartyAddress");
    }

    public CounterpartySuperDetails getCounterpartySuperDetails() {
        return (CounterpartySuperDetails)this.getChild("counterpartySuperDetails");
    }

    public String getCounterpartyMemberNumber() {
        CounterpartySuperDetails csd = (CounterpartySuperDetails)this.getChild("counterpartySuperDetails");
        if (csd == null) {
            return null;
        }
        return csd.getCounterpartyMemberNumber();
    }

    public SimpleStringProperty getCounterpartyMemberNumberProperty() {
        CounterpartySuperDetails csd = (CounterpartySuperDetails)this.getChild("counterpartySuperDetails");
        if (csd == null) {
            return null;
        }
        return csd.getCounterpartyMemberNumberProperty();
    }

    public String getSuperProductCounterparty() {
        CounterpartySuperDetails csd = (CounterpartySuperDetails)this.getChild("counterpartySuperDetails");
        if (csd == null) {
            return null;
        }
        return csd.getSuperProductCounterparty();
    }

    public SimpleStringProperty getSuperProductCounterpartyProperty() {
        CounterpartySuperDetails csd = (CounterpartySuperDetails)this.getChild("counterpartySuperDetails");
        if (csd == null) {
            return null;
        }
        return csd.getSuperProductCounterpartyProperty();
    }

    public CounterpartyPayrollDetails getCounterpartyPayrollDetails() {
        return (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
    }

    public String getCounterpartyStartDate() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyStartDate();
    }

    public SimpleStringProperty getCounterpartyStartDateProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyStartDateProperty();
    }

    public String getCounterpartyEndDate() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyEndDate();
    }

    public SimpleStringProperty getCounterpartyEndDateProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyEndDateProperty();
    }

    public String getCounterpartyNormalRate() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyNormalRate();
    }

    public SimpleStringProperty getCounterpartyNormalRateProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyNormalRateProperty();
    }

    public String getCounterpartyFirstFullRosterStartDate() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstFullRosterStartDate();
    }

    public SimpleStringProperty getCounterpartyFirstFullRosterStartDateProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstFullRosterStartDateProperty();
    }

    public String getCounterpartyDaysInRoster() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyDaysInRoster();
    }

    public SimpleStringProperty getCounterpartyDaysInRosterProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyDaysInRosterProperty();
    }

    public String getCounterpartyFirstPayDay() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstPayDay();
    }

    public SimpleStringProperty getCounterpartyFirstPayDayProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyFirstPayDayProperty();
    }

    public String getCounterpartyJobTitle() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyJobTitle();
    }

    public SimpleStringProperty getCounterpartyJobTitleProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyJobTitleProperty();
    }

    public String getCounterpartyAgreement() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAgreement();
    }

    public SimpleStringProperty getCounterpartyAgreementProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAgreementProperty();
    }

    public String getCounterpartyAnnualSalary() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAnnualSalary();
    }

    public SimpleStringProperty getCounterpartyAnnualSalaryProperty() {
        CounterpartyPayrollDetails cpd = (CounterpartyPayrollDetails)this.getChild("counterpartyPayrollDetails");
        if (cpd == null) {
            return null;
        }
        return cpd.getCounterpartyAnnualSalaryProperty();
    }

    public SBRDocumentTFND0004 addNewSBRDocumentTFND0004() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("SBRDocumentTFND0004");
        if (glenixElementChildList != null) {
            return (SBRDocumentTFND0004)glenixElementChildList.addChild();
        }
        return null;
    }

    public ArrayList<SBRDocumentTFND0004> getSBRDocumentTFND0004List() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("SBRDocumentTFND0004");
        if (glenixElementChildList != null) {
            return glenixElementChildList.children;
        }
        return null;
    }

    public SBRDocumentTFND0004 getSBRDocumentTFND0004(String identifier) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("SBRDocumentTFND0004");
        if (glenixElementChildList != null) {
            for (GlenixElement ge : glenixElementChildList.getList()) {
                if (!identifier.equals(((SBRDocumentTFND0004)ge).getTFND0004Identifier())) continue;
                return (SBRDocumentTFND0004)ge;
            }
        }
        return null;
    }

    public SuperProductDetails getSuperProductDetails() {
        return (SuperProductDetails)this.getChild("superProductDetails");
    }

    public String getSuperProductUSI() {
        SuperProductDetails spd = this.getSuperProductDetails();
        if (spd == null) {
            return null;
        }
        return spd.getSuperProductUSI();
    }

    public SimpleStringProperty getSuperProductUSIProperty() {
        SuperProductDetails spd = this.getSuperProductDetails();
        if (spd == null) {
            return null;
        }
        return spd.getSuperProductUSIProperty();
    }

    public void deleteSuperProductDetails() {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("superProductDetails");
        if (gecl.getChildCount() > 0) {
            gecl.removeChild(0);
        }
    }

    public void deletePayrollDetails() throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("SBRDocumentTFND0004");
        if (gecl.getChildCount() > 0) {
            throw new Exception("Error, cannot delete payroll details as employee has a TFN declaration");
        }
        gecl = (GlenixElementChildList)this.childrenAndMeta.get("counterpartySuperDetails");
        if (gecl.getChildCount() > 0) {
            throw new Exception("Error, cannot delete payroll details as employee has superannuation details");
        }
        gecl = (GlenixElementChildList)this.childrenAndMeta.get("counterpartyPayrollDetails");
        if (gecl.getChildCount() > 0) {
            gecl.removeChild(0);
        }
    }

    public SBRDocumentTFND0004 getLatestSBRDocumentTFND0004() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("SBRDocumentTFND0004");
        if (glenixElementChildList != null) {
            SBRDocumentTFND0004 latest = null;
            String latestTimeStr = null;
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                SBRDocumentTFND0004 thisTFND = (SBRDocumentTFND0004)glenixElementChildList.getChild(i);
                if (latest == null) {
                    latest = thisTFND;
                    latestTimeStr = thisTFND.getSBRDocumentDateTimeString();
                    continue;
                }
                String thisTimeStr = thisTFND.getSBRDocumentDateTimeString();
                if (thisTimeStr != null && (latestTimeStr == null || latestTimeStr.compareTo(thisTimeStr) >= 0)) continue;
                latestTimeStr = thisTimeStr;
                latest = thisTFND;
            }
            return latest;
        }
        return null;
    }

    public String getLatestSBRDocumentTFND0004Status() {
        SBRDocumentTFND0004 tfnd = this.getLatestSBRDocumentTFND0004();
        if (tfnd == null) {
            return null;
        }
        return tfnd.getSBRDocumentStatus();
    }

    public SimpleStringProperty getLatestSBRDocumentTFND0004StatusProperty() {
        SBRDocumentTFND0004 tfnd = this.getLatestSBRDocumentTFND0004();
        if (tfnd == null) {
            return null;
        }
        return tfnd.getSBRDocumentStatusProperty();
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        this.appendToElement(document, transactionEl);
        return document;
    }

    public void assignUUIDToCounterpartyIdentifier() throws Exception {
        String counterpartyIdentifier = this.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("counterpartyIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getCounterpartyIdentifier();
    }

    public void loadFasV2CounterpartyList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("identifierReference")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Element el2;
                Node node2;
                int j;
                NodeList nodeList2;
                GlenixStringElement gse2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("identifierCode")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("counterpartyIdentifier");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("identifierDescription")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("counterpartyLegalName");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Identifiers.AustralianBusinessNumber.Identifier")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("counterpartyABN");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("identifierDateOfBirth")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("counterpartyDateOfBirth");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("")) {
                    gse2 = (GlenixStringElement)this.getOrAddChild("counterpartyEmailAddress");
                    gse2.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("identifierEMail")) {
                    nodeList2 = el.getChildNodes();
                    for (j = 0; j < nodeList2.getLength(); ++j) {
                        node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1) continue;
                        el2 = (Element)node;
                        if (!el.getLocalName().equals("identifierEmailAddress")) continue;
                        gse = (GlenixStringElement)this.getOrAddChild("counterpartyEmailAddress");
                        gse.setGlenixElementValue(el.getTextContent());
                    }
                    continue;
                }
                if (el.getLocalName().equals("identifierPhoneNumber")) {
                    nodeList2 = el.getChildNodes();
                    for (j = 0; j < nodeList2.getLength(); ++j) {
                        node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1) continue;
                        el2 = (Element)node;
                        if (!el.getLocalName().equals("identifierPhone")) continue;
                        gse = (GlenixStringElement)this.getOrAddChild("counterpartyTelephone");
                        gse.setGlenixElementValue(el.getTextContent());
                    }
                    continue;
                }
                if (el.getLocalName().equals("identifierAddress")) {
                    Address addr = (Address)this.getOrAddChild("counterpartyAddress");
                    addr.loadFasV2CounterpartyList(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("identifierTFNDeclaration")) {
                    SBRDocumentTFND0004 tfnd = (SBRDocumentTFND0004)this.getOrAddChild("SBRDocumentTFND0004");
                    tfnd.loadFasV2CounterpartyList(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("identifierPayrollDetails")) {
                    CounterpartyPayrollDetails proll = (CounterpartyPayrollDetails)this.getOrAddChild("counterpartyPayrollDetails");
                    proll.loadFasV2CounterpartyList(doc, el);
                    continue;
                }
                if (!el.getLocalName().equals("identifierSuperannuationDetails")) continue;
                CounterpartySuperDetails sup = (CounterpartySuperDetails)this.getOrAddChild("counterpartySuperDetails");
                sup.loadFasV2CounterpartyList(doc, el);
            }
            return;
        }
    }

    public void loadFasV2Transactions(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("identifierReference")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("identifierCode")) continue;
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("counterpartyIdentifier");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("counterpartyIdentifier")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }
}

