/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.BusinessEventItems;
import au.com.glenix.trn.CTR0009;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.OverallEventItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.beans.DefaultProperty;
import javafx.fxml.FXMLLoader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@DefaultProperty(value="children")
public class CTR0010
extends CTR0009 {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private final List<GlenixElementChildList> children = new ArrayList<GlenixElementChildList>();

    public CTR0010() throws Exception {
        super(false);
        this.name = "ctr0010";
        this.namespace = "http://www.glenix.com.au/";
        this.sbrNamespace = "http://www.xbrl.org/2003/instance";
        this.sbrName = "xbrli:xbrl";
        this.sbrContext = null;
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("ctr0010.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        fxmlLoader.load();
        for (GlenixElementChildList gecl : this.children) {
            this.childrenAndMeta.put(gecl.getName(), gecl);
        }
    }

    public List<GlenixElementChildList> getChildren() {
        return this.children;
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public String getIdentifiersTaxFileNumberIdentifier() {
        return this.getChildValue("Identifiers.TaxFileNumber.Identifier");
    }

    @Override
    public String getIdentifiersAustralianBusinessNumberIdentifier() {
        return this.getChildValue("Identifiers.AustralianBusinessNumber.Identifier");
    }

    @Override
    public String getAgentIdentifiersAustralianBusinessNumberIdentifier() {
        return this.getChildValue("Identifiers.AustralianBusinessNumber.Identifier.INT");
    }

    @Override
    public String getAgentIdentifiersTaxAgentNumberIdentifier() {
        return this.getChildValue("Identifiers.TaxAgentNumber.Identifier");
    }

    @Override
    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element element = document.createElementNS(this.namespace, this.name);
        document.appendChild(element);
        for (String key : this.childrenAndMeta.keySet()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(key);
            for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
                GlenixElement ge = glenixElementChildList.getChild(i);
                ge.appendToElement(document, element);
            }
        }
        return document;
    }

    @Override
    public void removeEventMessages() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("OverallEventItems");
        if (glenixElementChildList != null) {
            glenixElementChildList.clearChildren();
        }
        if ((glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("BusinessEventItems")) != null) {
            glenixElementChildList.clearChildren();
        }
    }

    @Override
    public void loadSBROverallEventItemsDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("OverallEventItems", new GlenixElementChildList(OverallEventItems.class, "http://www.glenix.com.au/", "OverallEventItems", null, null, null, 1, false));
        EventItems overallEventItems = (EventItems)this.getOrAddChild("OverallEventItems");
        overallEventItems.loadSBRDocumentRoot(doc, root);
    }

    @Override
    public void loadSBRBusinessEventItemsDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("BusinessEventItems", new GlenixElementChildList(BusinessEventItems.class, "http://www.glenix.com.au/", "BusinessEventItems", null, null, null, 1, false));
        EventItems businessEventItems = (EventItems)this.getOrAddChild("BusinessEventItems");
        businessEventItems.loadSBRDocumentRoot(doc, root);
    }

    @Override
    public EventItems getOverallEventItems() {
        return (EventItems)this.getChild("OverallEventItems");
    }

    @Override
    public EventItems getBusinessEventItems() {
        return (EventItems)this.getChild("BusinessEventItems");
    }

    public Document buildCTR0010Document(String startDate, String endDate) {
        Document doc = this.docBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element node_xbrl = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:xbrl");
        doc.appendChild(node_xbrl);
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xbrli", "http://www.xbrl.org/2003/instance");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:link", "http://www.xbrl.org/2003/linkbase");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xbrldi", "http://xbrl.org/2006/xbrldi");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:iso4217", "http://www.xbrl.org/2003/iso4217");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xbrldt", "http://xbrl.org/2005/xbrldt");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://www.sbr.gov.au/ato/ctr");
        Element node_schemaRef = doc.createElementNS("http://www.xbrl.org/2003/linkbase", "link:schemaRef");
        node_xbrl.appendChild(node_schemaRef);
        node_schemaRef.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "http://sbr.gov.au/taxonomy/sbr_au_reports/ato/ctr/ctr_0010/ato.ctr.0010.2019.01.00.report.xsd");
        node_schemaRef.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:type", "simple");
        String abn = this.getChildValue("Identifiers.AustralianBusinessNumber.Identifier");
        String tfn = this.getChildValue("Identifiers.TaxFileNumber.Identifier");
        ContextBuilder cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.buildContext(doc, node_xbrl, "RP", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.buildContext(doc, node_xbrl, "RP_INSTANT", abn, tfn, null, endDate);
        String agentABN = this.getChildValue("Identifiers.AustralianBusinessNumber.Identifier.INT");
        if (agentABN != null && !agentABN.equals("")) {
            cb = new ContextBuilder();
            cb.setRPDimension("Intermediary");
            cb.buildContext(doc, node_xbrl, "INT", agentABN, null, startDate, endDate);
        }
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setInternationalJurisdictionDimension("Australian");
        cb.buildContext(doc, node_xbrl, "RP_JAUS", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setInternationalJurisdictionDimension("Foreign");
        cb.buildContext(doc, node_xbrl, "RP_JFOREIGN", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setOpeningAndClosingBalanceDimension("Closing");
        cb.buildContext(doc, node_xbrl, "RP_CLOSINGINSTANT", abn, tfn, null, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setConsolidationDeductionTypeDimension("PreRules");
        cb.buildContext(doc, node_xbrl, "RP_PRERULES", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setConsolidationDeductionTypeDimension("InterimRules");
        cb.buildContext(doc, node_xbrl, "RP_INTERIMRULES", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setConsolidationDeductionTypeDimension("ProspectiveRules");
        cb.buildContext(doc, node_xbrl, "RP_PROSPECTIVERULES", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setCountryOfResidencyCFCClassificationDimension("ListedCountry");
        cb.buildContext(doc, node_xbrl, "RP_CFCLC", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setCountryOfResidencyCFCClassificationDimension("UnlistedCountry");
        cb.buildContext(doc, node_xbrl, "RP_CFCUC", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setSmallBusinessDepreciatingAssetTypeDimension("LowCost");
        cb.buildContext(doc, node_xbrl, "RP_LOWCOST", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setSmallBusinessDepreciatingAssetTypeDimension("GeneralPool");
        cb.buildContext(doc, node_xbrl, "RP_GENERALPOOL", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setOpeningAndClosingBalanceDimension("Opening");
        cb.buildContext(doc, node_xbrl, "RP_OPENINGINSTANT", abn, tfn, startDate, null);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setRelativePeriodDurationDimension("Y0Minus1");
        cb.buildContext(doc, node_xbrl, "RP_Y0MINUS1", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setRelativePeriodDurationDimension("Y0");
        cb.buildContext(doc, node_xbrl, "RP_Y0", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setFinancialArrangementTypeDimension("TOFA");
        cb.buildContext(doc, node_xbrl, "RP_TOFA", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setRelativePeriodDurationDimension("Y0Plus1");
        cb.buildContext(doc, node_xbrl, "RP_Y0PLUS1", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setRelativePeriodDurationDimension("YPrevious");
        cb.buildContext(doc, node_xbrl, "RP_YPREVIOUS", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setLifeInsurancePolicyClassTypeDimension("ComplyingSuperannuationClass");
        cb.buildContext(doc, node_xbrl, "RP_CMPLY", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setLifeInsurancePolicyClassTypeDimension("OrdinaryClass");
        cb.buildContext(doc, node_xbrl, "RP_ORD", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setEarlyInvestorDimension("Investor");
        cb.buildContext(doc, node_xbrl, "RP_INVESTOR", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setEarlyInvestorDimension("LimitedPartners");
        cb.buildContext(doc, node_xbrl, "RP_LIMITEDPARTNERS", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setEarlyInvestorDimension("Investor");
        cb.setRelativePeriodDurationDimension("YPrevious");
        cb.buildContext(doc, node_xbrl, "RP_INVESTOR_YPREVIOUS", abn, tfn, startDate, endDate);
        cb = new ContextBuilder();
        cb.setRPDimension("ReportingParty");
        cb.setEarlyInvestorDimension("LimitedPartners");
        cb.setRelativePeriodDurationDimension("YPrevious");
        cb.buildContext(doc, node_xbrl, "RP_LIMITEDPARTNERS_YPREVIOUS", abn, tfn, startDate, endDate);
        Element node_unit = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:unit");
        node_xbrl.appendChild(node_unit);
        node_unit.setAttribute("id", "U1");
        Element node_measure = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:measure");
        node_unit.appendChild(node_measure);
        node_measure.setTextContent("iso4217:AUD");
        node_unit = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:unit");
        node_xbrl.appendChild(node_unit);
        node_unit.setAttribute("id", "U2");
        node_measure = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:measure");
        node_unit.appendChild(node_measure);
        node_measure.setTextContent("xbrli:pure");
        node_unit = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:unit");
        node_xbrl.appendChild(node_unit);
        node_unit.setAttribute("id", "Y");
        node_measure = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:measure");
        node_unit.appendChild(node_measure);
        node_measure.setTextContent("tns:Y");
        Set<String> childNames = this.getChildElementNameSet();
        for (String childName : childNames) {
            List<GlenixElement> childGEs = this.getChildElementSet(childName);
            if (childGEs == null || childGEs.size() <= 0) continue;
            if (childName.equals("Declaration")) {
                if (agentABN != null && !agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("DeclarationINT")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("Identifiers.TaxAgentClientReference.Text")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("ElectronicContactTelephoneINT")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("PersonUnstructuredNameINT")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("Identifiers.TaxAgentNumber.Identifier")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("Identifiers.AustralianBusinessNumber.Identifier.INT")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            for (GlenixElement ge_child : childGEs) {
                ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
            }
        }
        return doc;
    }

    private class ContextBuilder {
        String openingAndClosingBalanceDimension;
        String internationalJurisdictionDimension;
        String consolidationDeductionTypeDimension;
        String countryOfResidencyCFCClassificationDimension;
        String relativePeriodDurationDimension;
        String financialArrangementTypeDimension;
        String lifeInsurancePolicyClassTypeDimension;
        String rpDimension;
        String smallBusinessDepreciatingAssetTypeDimension;
        String earlyInvestorDimension;

        public void setOpeningAndClosingBalanceDimension(String value) {
            this.openingAndClosingBalanceDimension = value;
        }

        public void setInternationalJurisdictionDimension(String value) {
            this.internationalJurisdictionDimension = value;
        }

        public void setConsolidationDeductionTypeDimension(String value) {
            this.consolidationDeductionTypeDimension = value;
        }

        public void setCountryOfResidencyCFCClassificationDimension(String value) {
            this.countryOfResidencyCFCClassificationDimension = value;
        }

        public void setRelativePeriodDurationDimension(String value) {
            this.relativePeriodDurationDimension = value;
        }

        public void setFinancialArrangementTypeDimension(String value) {
            this.financialArrangementTypeDimension = value;
        }

        public void setLifeInsurancePolicyClassTypeDimension(String value) {
            this.lifeInsurancePolicyClassTypeDimension = value;
        }

        public void setRPDimension(String value) {
            this.rpDimension = value;
        }

        public void setSmallBusinessDepreciatingAssetTypeDimension(String value) {
            this.smallBusinessDepreciatingAssetTypeDimension = value;
        }

        public void setEarlyInvestorDimension(String value) {
            this.earlyInvestorDimension = value;
        }

        public void buildContext(Document doc, Element node_xbrl, String contextId, String abn, String tfn, String startDate, String endDate) {
            Element node_explicitMember;
            Element node_context = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:context");
            node_xbrl.appendChild(node_context);
            node_context.setAttribute("id", contextId);
            Element node_entity = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:entity");
            node_context.appendChild(node_entity);
            Element node_identifier = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:identifier");
            node_entity.appendChild(node_identifier);
            if (tfn != null && !tfn.equals("")) {
                node_identifier.setAttribute("scheme", "http://www.ato.gov.au/tfn");
                node_identifier.setTextContent(tfn);
            } else {
                node_identifier.setAttribute("scheme", "http://www.ato.gov.au/abn");
                node_identifier.setTextContent(abn);
            }
            Element node_segment = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:segment");
            node_entity.appendChild(node_segment);
            if (this.openingAndClosingBalanceDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:OpeningAndClosingBalanceDimension");
                node_explicitMember.setTextContent("tns:" + this.openingAndClosingBalanceDimension);
            }
            if (this.internationalJurisdictionDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:InternationalJurisdictionDimension");
                node_explicitMember.setTextContent("tns:" + this.internationalJurisdictionDimension);
            }
            if (this.consolidationDeductionTypeDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:ConsolidationDeductionTypeDimension");
                node_explicitMember.setTextContent("tns:" + this.consolidationDeductionTypeDimension);
            }
            if (this.countryOfResidencyCFCClassificationDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:CountryOfResidencyCFCClassificationDimension");
                node_explicitMember.setTextContent("tns:" + this.countryOfResidencyCFCClassificationDimension);
            }
            if (this.relativePeriodDurationDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:RelativePeriodDurationDimension");
                node_explicitMember.setTextContent("tns:" + this.relativePeriodDurationDimension);
            }
            if (this.financialArrangementTypeDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:FinancialArrangementTypeDimension");
                node_explicitMember.setTextContent("tns:" + this.financialArrangementTypeDimension);
            }
            if (this.lifeInsurancePolicyClassTypeDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:LifeInsurancePolicyClassTypeDimension");
                node_explicitMember.setTextContent("tns:" + this.lifeInsurancePolicyClassTypeDimension);
            }
            if (this.rpDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:ReportPartyTypeDimension");
                node_explicitMember.setTextContent("tns:" + this.rpDimension);
            }
            if (this.smallBusinessDepreciatingAssetTypeDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:SmallBusinessDepreciatingAssetTypeDimension");
                node_explicitMember.setTextContent("tns:" + this.smallBusinessDepreciatingAssetTypeDimension);
            }
            if (this.earlyInvestorDimension != null) {
                node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
                node_segment.appendChild(node_explicitMember);
                node_explicitMember.setAttribute("dimension", "tns:EarlyInvestorDimension");
                node_explicitMember.setTextContent("tns:" + this.earlyInvestorDimension);
            }
            Element node_period = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:period");
            node_context.appendChild(node_period);
            if (endDate == null) {
                Element node_startDate = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:instant");
                node_period.appendChild(node_startDate);
                node_startDate.setTextContent(startDate);
            } else if (startDate == null) {
                Element node_endDate = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:instant");
                node_period.appendChild(node_endDate);
                node_endDate.setTextContent(endDate);
            } else {
                Element node_startDate = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:startDate");
                node_period.appendChild(node_startDate);
                node_startDate.setTextContent(startDate);
                Element node_endDate = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:endDate");
                node_period.appendChild(node_endDate);
                node_endDate.setTextContent(endDate);
            }
        }
    }
}

