/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessMessageFile
extends GlenixAbstractBranchElement {
    public BusinessMessageFile() {
        this.namespace = "http://www.glenix.com.au/";
        this.name = "businessMessageFile";
        this.childrenAndMeta.put("messageFileIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFileIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("messageFileName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFileName", null, null, null, 1, true));
        this.childrenAndMeta.put("messageFileOriginalName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFileOriginalName", null, null, null, 1, true));
        this.childrenAndMeta.put("messageFileDigest", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFileDigest", null, null, null, 1, true));
    }

    public GlenixStringElement getChild(String childName) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (GlenixStringElement)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getChildValue("messageFileIdentifier");
    }

    public String getMessageFileIdentifier() {
        return this.getChildValue("messageFileIdentifier");
    }

    public String getMessageFileName() {
        return this.getChildValue("messageFileName");
    }

    public String getMessageFileOriginalName() {
        return this.getChildValue("messageFileOriginalName");
    }

    public String getMessageFileDigest() {
        return this.getChildValue("messageFileDigest");
    }

    private void assignUUIDToMessageFileIdentifier() throws Exception {
        String messageFileIdentifier = this.getMessageFileIdentifier();
        if (messageFileIdentifier == null || messageFileIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("messageFileIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToMessageFileIdentifier();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToMessageFileIdentifier();
    }

    public int compareTo(BusinessMessageFile other) {
        String thisname = this.getMessageFileName();
        String othername = other.getMessageFileName();
        if (thisname != null && othername == null) {
            return 1;
        }
        if (thisname == null && othername != null) {
            return -1;
        }
        int subres = thisname.compareTo(othername);
        if (subres != 0) {
            return subres;
        }
        String thisid = this.getMessageFileIdentifier();
        String otherid = other.getMessageFileIdentifier();
        if (thisid != null && otherid == null) {
            return 1;
        }
        if (thisid == null && otherid != null) {
            return -1;
        }
        return thisid.compareTo(otherid);
    }
}

