/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.BusinessIssue;
import au.com.glenix.trn.BusinessMessageFile;
import au.com.glenix.trn.BusinessMessageSignature;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessMessage
extends GlenixAbstractBranchElement {
    private DateTimeFormatter basictime = DateTimeFormatter.ofPattern("HH:mm");

    public BusinessMessage() {
        this.namespace = "http://www.glenix.com.au/";
        this.name = "businessMessage";
        this.childrenAndMeta.put("businessMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("businessMessageTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessMessageTime", null, null, null, 1, true));
        this.childrenAndMeta.put("messagePublicKeyIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messagePublicKeyIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("messageFromName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFromName", null, null, null, 1, true));
        this.childrenAndMeta.put("messageText", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageText", null, null, null, 1, true));
        this.childrenAndMeta.put("declarationText", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "declarationText", null, null, null, 1, true));
        this.childrenAndMeta.put("messageDigest", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageDigest", null, null, null, 1, true));
        this.childrenAndMeta.put("businessIssue", new GlenixElementChildList(BusinessIssue.class, "http://www.glenix.com.au/", "businessIssue", null, null, null, 1, false));
        this.childrenAndMeta.put("businessMessageSignature", new GlenixElementChildList(BusinessMessageSignature.class, "http://www.glenix.com.au/", "businessMessageSignature", null, null, null, -1, false));
        this.childrenAndMeta.put("businessMessageFile", new GlenixElementChildList(BusinessMessageFile.class, "http://www.glenix.com.au/", "businessMessageFile", null, null, null, -1, false));
        this.childrenAndMeta.put("messageFromCertificate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFromCertificate", null, null, null, 1, true));
        this.childrenAndMeta.put("messageFromSignature", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageFromSignature", null, null, null, 1, true));
        this.childrenAndMeta.put("sourceBusinessFileName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "sourceBusinessFileName", null, null, null, 1, true));
        this.childrenAndMeta.put("messageStatus", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageStatus", null, null, null, 1, true));
        this.childrenAndMeta.put("messageStartDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageStartDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("messageEndDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageEndDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("messageBreakTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageBreakTime", null, null, null, 1, true));
        this.childrenAndMeta.put("messageWorkTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "messageWorkTime", null, null, null, 1, true));
    }

    public GlenixStringElement getChild(String childName) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (GlenixStringElement)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getChildValue("businessMessageIdentifier");
    }

    @Override
    public String getGlenixElementValue() {
        return this.getChildValue("messageText");
    }

    public String getBusinessMessageIdentifier() {
        return this.getChildValue("businessMessageIdentifier");
    }

    public String getBusinessMessageTime() {
        return this.getChildValue("businessMessageTime");
    }

    public String getMessagePublicKeyIdentifier() {
        return this.getChildValue("messagePublicKeyIdentifier");
    }

    public String getMessageFromName() {
        return this.getChildValue("messageFromName");
    }

    public String getMessageText() {
        return this.getChildValue("messageText");
    }

    public String getDeclarationText() {
        return this.getChildValue("declarationText");
    }

    public String getMessageDigest() {
        return this.getChildValue("messageDigest");
    }

    public String getMessageStatus() {
        return this.getChildValue("messageStatus");
    }

    public String getMessageFromCertificate() {
        return this.getChildValue("messageFromCertificate");
    }

    public String getMessageFromSignature() {
        return this.getChildValue("messageFromSignature");
    }

    public String getSourceBusinessFileName() {
        return this.getChildValue("sourceBusinessFileName");
    }

    public String getMessageStartDateTime() {
        return this.getChildValue("messageStartDateTime");
    }

    public String getMessageEndDateTime() {
        return this.getChildValue("messageEndDateTime");
    }

    public String getMessageBreakTime() {
        return this.getChildValue("messageBreakTime");
    }

    public String getMessageWorkTime() {
        return this.getChildValue("messageWorkTime");
    }

    public LocalDateTime getMessageStartDateTimeAsTime() {
        String timestr = this.getChildValue("messageStartDateTime");
        if (timestr == null || timestr.isEmpty()) {
            return null;
        }
        return LocalDateTime.parse(timestr, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LocalDateTime getMessageEndDateTimeAsTime() {
        String timestr = this.getChildValue("messageEndDateTime");
        if (timestr == null || timestr.isEmpty()) {
            return null;
        }
        return LocalDateTime.parse(timestr, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LocalTime getMessageBreakTimeAsTime() {
        String timestr = this.getChildValue("messageBreakTime");
        if (timestr == null || timestr.isEmpty()) {
            return null;
        }
        return LocalTime.parse(timestr, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public LocalTime getMessageWorkTimeAsTime() {
        String timestr = this.getChildValue("messageWorkTime");
        if (timestr == null || timestr.isEmpty()) {
            return null;
        }
        return LocalTime.parse(timestr, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public String getFormattedWorkTime() {
        LocalTime wt = this.getMessageWorkTimeAsTime();
        if (wt == null) {
            return null;
        }
        String result = wt.format(this.basictime);
        LocalDateTime st = this.getMessageStartDateTimeAsTime();
        if (st != null) {
            result = result + " (" + st.format(this.basictime);
            LocalDateTime et = this.getMessageEndDateTimeAsTime();
            if (et != null) {
                result = result + " - " + et.format(this.basictime);
                LocalTime bt = this.getMessageBreakTimeAsTime();
                if (bt != null) {
                    result = result + ", break: " + bt.format(this.basictime);
                }
            }
            result = result + ")";
        }
        return result;
    }

    public void setMessageFromCertificate(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageFromCertificate");
        gse.setGlenixElementValue(value);
    }

    public void setMessageFromSignature(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageFromSignature");
        gse.setGlenixElementValue(value);
    }

    public void setMessageStartDateTime(LocalDateTime value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageStartDateTime");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
    }

    public void setMessageEndDateTime(LocalDateTime value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageEndDateTime");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
    }

    public void setMessageBreakTime(LocalTime value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageBreakTime");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(value.format(DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }

    public void setMessageWorkTime(LocalTime value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageWorkTime");
        if (value == null) {
            gse.setGlenixElementValue((String)null);
        } else {
            gse.setGlenixElementValue(value.format(DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }

    public int getBusinessMessageFileCount() {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageFile");
        if (gecl == null) {
            return 0;
        }
        return gecl.getChildCount();
    }

    public BusinessMessageFile getBusinessMessageFile(int index) {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageFile");
        if (gecl == null) {
            return null;
        }
        return (BusinessMessageFile)gecl.getChild(index);
    }

    public void sortBusinessMessageFile() {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageFile");
        if (gecl == null) {
            return;
        }
        gecl.children.sort(new Comparator<BusinessMessageFile>(){

            @Override
            public int compare(BusinessMessageFile a, BusinessMessageFile b) {
                return a.compareTo(b);
            }
        });
    }

    public int getBusinessMessageSignatureCount() {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageSignature");
        if (gecl == null) {
            return 0;
        }
        return gecl.getChildCount();
    }

    public BusinessMessageSignature getBusinessMessageSignature(int index) {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageSignature");
        if (gecl == null) {
            return null;
        }
        return (BusinessMessageSignature)gecl.getChild(index);
    }

    public void setBusinessMessageTime(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("businessMessageTime");
        gse.setGlenixElementValue(value);
    }

    public void setMessageDigest(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageDigest");
        gse.setGlenixElementValue(value);
    }

    public void setMessageStatus(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("messageStatus");
        gse.setGlenixElementValue(value);
    }

    public BusinessIssue addBlankBusinessIssue() throws Exception {
        return (BusinessIssue)((GlenixElementChildList)this.childrenAndMeta.get("businessIssue")).addChild();
    }

    public void addBusinessMessageSignature(BusinessMessageSignature businessMessageSignature) throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageSignature");
        gecl.children.add(businessMessageSignature);
    }

    public void setSourceBusinessFileName(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("sourceBusinessFileName");
        gse.setGlenixElementValue(value);
    }

    private void assignUUIDToBusinessMessageIdentifier() throws Exception {
        String businessMessageIdentifier = this.getBusinessMessageIdentifier();
        if (businessMessageIdentifier == null || businessMessageIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessMessageIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToBusinessMessageIdentifier();
        this.sortBusinessMessageFile();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToBusinessMessageIdentifier();
        this.sortBusinessMessageFile();
    }

    public boolean matchFilter(String filter) {
        String name;
        int i;
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        filter = filter.toLowerCase();
        String messagefrom = this.getMessageFromName();
        if (messagefrom != null && messagefrom.toLowerCase().contains(filter)) {
            return true;
        }
        String dectext = this.getDeclarationText();
        if (dectext != null && dectext.toLowerCase().contains(filter)) {
            return true;
        }
        String messagetext = this.getMessageText();
        if (messagetext != null && messagetext.toLowerCase().contains(filter)) {
            return true;
        }
        for (i = 0; i < this.getBusinessMessageFileCount(); ++i) {
            BusinessMessageFile bmf = this.getBusinessMessageFile(i);
            name = bmf.getMessageFileOriginalName();
            if (name == null || !name.toLowerCase().contains(filter)) continue;
            return true;
        }
        for (i = 0; i < this.getBusinessMessageSignatureCount(); ++i) {
            BusinessMessageSignature bms = this.getBusinessMessageSignature(i);
            name = bms.getMessageSignatureName();
            if (name == null || !name.toLowerCase().contains(filter)) continue;
            return true;
        }
        return false;
    }
}

