/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.ElectronicContact;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.LicenseFee;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessMasterFile
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public BusinessMasterFile() throws Exception {
        this.namespace = "http://www.glenix.com.au/";
        this.name = "businessMasterFile";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("businessIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("businessLegalName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessLegalName", null, null, null, 1, true));
        this.childrenAndMeta.put("businessTradingName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessTradingName", null, null, null, 1, true));
        this.childrenAndMeta.put("businessDescription", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessDescription", null, null, null, 1, true));
        this.childrenAndMeta.put("businessABN", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessABN", null, null, null, 1, true));
        this.childrenAndMeta.put("businessABNBranch", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessABNBranch", null, null, null, 1, true));
        this.childrenAndMeta.put("businessWPN", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessWPN", null, null, null, 1, true));
        this.childrenAndMeta.put("businessTFN", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessTFN", null, null, null, 1, true));
        this.childrenAndMeta.put("ledgerStartDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "ledgerStartDate", null, null, null, 1, true));
        this.childrenAndMeta.put("ledgerEndDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "ledgerEndDate", null, null, null, 1, true));
        this.childrenAndMeta.put("SoftwareInformationBusinessManagementSystemId", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SoftwareInformationBusinessManagementSystemId", null, null, null, 1, true));
        this.childrenAndMeta.put("businessBusinessAddress", new GlenixElementChildList(TFND0004AddressDetailsBusiness.class, "http://www.glenix.com.au/", "businessBusinessAddress", null, null, null, 1, false));
        this.childrenAndMeta.put("businessPostalAddress", new GlenixElementChildList(TFND0004AddressDetailsBusiness.class, "http://www.glenix.com.au/", "businessPostalAddress", null, null, null, 1, false));
        this.childrenAndMeta.put("businessElectronicContact", new GlenixElementChildList(ElectronicContact.class, "http://www.glenix.com.au/", "businessElectronicContact", null, null, null, 1, false));
        this.childrenAndMeta.put("businessIsRegisteredForGST", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessIsRegisteredForGST", null, null, null, 1, true));
        this.childrenAndMeta.put("businessWebsite", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessWebsite", null, null, null, 1, true));
        this.childrenAndMeta.put("businessMasterFileLicenseFeeLevel", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessMasterFileLicenseFeeLevel", null, null, null, 1, true));
        this.childrenAndMeta.put("businessMasterFileLicenseExpires", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessMasterFileLicenseExpires", null, null, null, 1, true));
        this.childrenAndMeta.put("licenseFee", new GlenixElementChildList(LicenseFee.class, "http://www.glenix.com.au/", "licenseFee", null, null, null, 1, false));
    }

    public GlenixStringElement getChild(String childName) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (GlenixStringElement)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public String getGlenixElementKeyId() {
        String result = this.getChildValue("businessIdentifier");
        if (result == null || result.equals("")) {
            result = this.getChildValue("businessLegalName");
        }
        if (result == null || result.equals("")) {
            result = this.getChildValue("businessABN");
        }
        return result;
    }

    @Override
    public String getGlenixElementValue() {
        String result = this.getChildValue("businessLegalName");
        if (result == null || result.equals("")) {
            result = this.getChildValue("businessTradingName");
        }
        if (result == null || result.equals("")) {
            result = this.getChildValue("businessABN");
        }
        if (result == null || result.equals("")) {
            result = this.getChildValue("businessIdentifier");
        }
        return result;
    }

    public String getBusinessIdentifier() {
        return this.getChildValue("businessIdentifier");
    }

    public String getBusinessABN() {
        return this.getChildValue("businessABN");
    }

    public String getBusinessLegalName() {
        return this.getChildValue("businessLegalName");
    }

    public String getBusinessTradingName() {
        return this.getChildValue("businessTradingName");
    }

    public String getBusinessDescription() {
        return this.getChildValue("businessDescription");
    }

    public String getBusinessABNBranch() {
        return this.getChildValue("businessABNBranch");
    }

    public String getBusinessWPN() {
        return this.getChildValue("businessWPN");
    }

    public String getBusinessTFN() {
        return this.getChildValue("businessTFN");
    }

    public String getLedgerStartDate() {
        return this.getChildValue("ledgerStartDate");
    }

    public String getLedgerEndDate() {
        return this.getChildValue("ledgerEndDate");
    }

    public String getSoftwareInformationBusinessManagementSystemId() {
        return this.getChildValue("SoftwareInformationBusinessManagementSystemId");
    }

    public String getBusinessIsRegisteredForGST() {
        return this.getChildValue("businessIsRegisteredForGST");
    }

    public String getBusinessWebsite() {
        return this.getChildValue("businessWebsite");
    }

    public String getBusinessMasterFileLicenseFeeLevel() {
        return this.getChildValue("businessMasterFileLicenseFeeLevel");
    }

    public String getBusinessMasterFileLicenseExpires() {
        return this.getChildValue("businessMasterFileLicenseExpires");
    }

    public LocalDate getBusinessMasterFileLicenseExpiresAsDate() {
        String date = this.getChildValue("businessMasterFileLicenseExpires");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSoftwareInformationBusinessManagementSystemId(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("SoftwareInformationBusinessManagementSystemId");
        gse.setGlenixElementValue(value);
    }

    public TFND0004AddressDetailsBusiness getBusinessBusinessAddress() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessBusinessAddress");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (TFND0004AddressDetailsBusiness)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public TFND0004AddressDetailsBusiness getBusinessPostalAddress() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessPostalAddress");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (TFND0004AddressDetailsBusiness)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public ElectronicContact getBusinessElectronicContact() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessElectronicContact");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (ElectronicContact)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public void assignNewUUIDToBusinessIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessIdentifier");
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    public void assignUUIDToBusinessIdentifier() throws Exception {
        String businessIdentifier = this.getBusinessIdentifier();
        if (businessIdentifier == null || businessIdentifier.equals("")) {
            this.assignNewUUIDToBusinessIdentifier();
        }
    }

    public LicenseFee getLicenseFee() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("licenseFee");
        if (glenixElementChildList.getChildCount() == 0) {
            return null;
        }
        return (LicenseFee)glenixElementChildList.getChild(0);
    }

    public LicenseFee getOrAddLicenseFee() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("licenseFee");
        if (glenixElementChildList.getChildCount() == 0) {
            return (LicenseFee)glenixElementChildList.addChild();
        }
        return (LicenseFee)glenixElementChildList.getChild(0);
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        this.appendToElement(document, businessEl);
        return document;
    }
}

