/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.ActivityStatementList;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.BusinessIssue;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.BusinessMessage;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.DocumentLayout;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixCertificateList;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.LastUpdateIdentifier;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.TaxReturn;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Business
extends GlenixAbstractBranchElement {
    protected DateTimeFormatter prettyDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");

    public Business() {
        this.name = "business";
        this.namespace = "http://www.glenix.com.au/";
        this.childrenAndMeta.put("businessMasterFile", new GlenixElementChildList(BusinessMasterFile.class, "http://www.glenix.com.au/", "businessMasterFile", null, null, null, 1, false));
        this.childrenAndMeta.put("activityStatementList", new GlenixElementChildList(ActivityStatementList.class, "http://www.glenix.com.au/", "activityStatementList", null, null, null, 1, false));
        this.childrenAndMeta.put("transaction", new GlenixElementChildList(Transaction.class, "http://www.glenix.com.au/", "transaction", null, null, null, -1, false));
        this.childrenAndMeta.put("taxReturn", new GlenixElementChildList(TaxReturn.class, "http://www.glenix.com.au/", "taxReturn", null, null, null, -1, false));
        this.childrenAndMeta.put("glenixCertificateList", new GlenixElementChildList(GlenixCertificateList.class, "http://www.glenix.com.au/", "glenixCertificateList", null, null, null, 1, false));
        this.childrenAndMeta.put("documentLayout", new GlenixElementChildList(DocumentLayout.class, "http://www.glenix.com.au/", "documentLayout", null, null, null, 1, false));
        this.childrenAndMeta.put("businessMessage", new GlenixElementChildList(BusinessMessage.class, "http://www.glenix.com.au/", "businessMessage", null, null, null, -1, false));
        this.childrenAndMeta.put("updateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "updateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("updatedByPublicKeyIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "updatedByPublicKeyIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("updatedByPublicKey", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "updatedByPublicKey", null, null, null, 1, true));
        this.childrenAndMeta.put("businessFileName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "businessFileName", null, null, null, 1, true));
        this.childrenAndMeta.put("updateIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "updateIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("lastUpdateIdentifier", new GlenixElementChildList(LastUpdateIdentifier.class, "http://www.glenix.com.au/", "lastUpdateIdentifier", null, null, null, 1, false));
    }

    public GlenixStringElement getChild(String childName) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (GlenixStringElement)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    public BusinessMasterFile getBusinessMasterFile() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessMasterFile");
        if (glenixElementChildList == null) {
            return null;
        }
        if (glenixElementChildList.getChildCount() == 1) {
            return (BusinessMasterFile)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public BusinessMasterFile getOrAddBusinessMasterFile() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessMasterFile");
        if (glenixElementChildList == null) {
            throw new Exception("Error, business master file meta data not configured");
        }
        if (glenixElementChildList.getChildCount() == 1) {
            return (BusinessMasterFile)glenixElementChildList.getChild(0);
        }
        return (BusinessMasterFile)glenixElementChildList.addChild();
    }

    public String getBusinessMasterFileLicenseFeeLevel() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessMasterFileLicenseFeeLevel");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBusinessMasterFileLicenseExpires() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessMasterFileLicenseExpires");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LocalDate getBusinessMasterFileLicenseExpiresAsDate() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        return businessMasterFile.getBusinessMasterFileLicenseExpiresAsDate();
    }

    public DocumentLayout getDocumentLayout() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("documentLayout");
        if (glenixElementChildList == null) {
            return null;
        }
        if (glenixElementChildList.getChildCount() == 1) {
            return (DocumentLayout)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public String getBusinessLegalName() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessLegalName");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBusinessTradingName() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessTradingName");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBusinessDescription() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessDescription");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBusinessABN() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessABN");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBusinessABNBranch() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessABNBranch");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBusinessTFN() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("businessTFN");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLedgerStartDate() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("ledgerStartDate");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LocalDate getLedgerStartDateAsDate() {
        String date = this.getChildValue("ledgerStartDate");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLedgerEndDate() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        try {
            return businessMasterFile.getChildValue("ledgerEndDate");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LocalDate getLedgerEndDateAsDate() {
        String date = this.getChildValue("ledgerEndDate");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ActivityStatementList getActivityStatementList() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatementList");
        if (glenixElementChildList == null) {
            return null;
        }
        if (glenixElementChildList.getChildCount() == 1) {
            return (ActivityStatementList)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public void setActivityStatementList(ActivityStatementList activityStatementList) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatementList");
        if (glenixElementChildList.getChildCount() > 0) {
            glenixElementChildList.clearChildren();
        }
        glenixElementChildList.addChild(activityStatementList);
    }

    @Override
    public String getGlenixElementKeyId() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        return businessMasterFile.getGlenixElementKeyId();
    }

    @Override
    public String getGlenixElementKeyValue() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        return businessMasterFile.getGlenixElementKeyValue();
    }

    public void initActivityStatementList() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatementList");
        glenixElementChildList.addChild();
    }

    public void initActivityStatement() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("activityStatement");
        glenixElementChildList.addChild();
    }

    public String getUpdateTime() {
        return this.getChildValue("updateTime");
    }

    public String getUpdatedByPublicKeyIdentifier() {
        return this.getChildValue("updatedByPublicKeyIdentifier");
    }

    public String getUpdatedByPublicKey() {
        return this.getChildValue("updatedByPublicKey");
    }

    public String getBusinessFileName() {
        return this.getChildValue("businessFileName");
    }

    public String getBusinessIdentifier() {
        BusinessMasterFile businessMasterFile = this.getBusinessMasterFile();
        if (businessMasterFile == null) {
            return null;
        }
        return businessMasterFile.getBusinessIdentifier();
    }

    public LastUpdateIdentifier getLastUpdateIdentifier() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("lastUpdateIdentifier");
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return (LastUpdateIdentifier)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public int getTransactionCount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return 0;
        }
        return glenixElementChildList.getChildCount();
    }

    public Transaction getTransaction(int index) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        return (Transaction)glenixElementChildList.getChild(index);
    }

    public Transaction getTransaction(Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = transaction.getTransactionNumber();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (transaction != t && (hoi == null || hoi.isEmpty() || !hoi.equals(t.getTransactionNumber()))) continue;
            return t;
        }
        return null;
    }

    public ArrayList<Transaction> getTransactionArrayList() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        return glenixElementChildList.getArrayListNoType();
    }

    public void removeTransactionCollection(Collection<Transaction> removeCollection) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return;
        }
        glenixElementChildList.removeChildCollection(removeCollection);
    }

    public ArrayList<Transaction> getTransactionArrayListByBatch(String batchIdentifier) {
        if (batchIdentifier == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)transactionArrayList.get(i);
            String tBatchIdentifier = t.getBatchIdentifier();
            if (tBatchIdentifier == null || !tBatchIdentifier.equals(batchIdentifier)) continue;
            result.add(t);
        }
        return result;
    }

    public ArrayList<Transaction> getTransactionArrayListByCounterparty(String counterpartyIdentifier) {
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)transactionArrayList.get(i);
            String tCounterpartyIdentifier = t.getCounterpartyIdentifier();
            if (tCounterpartyIdentifier == null || !tCounterpartyIdentifier.equals(counterpartyIdentifier)) continue;
            result.add(t);
        }
        return result;
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineArrayListByAccount(String accountIdentifier, boolean includeCancelled, String filterText, LocalDate fromDate, LocalDate toDate, Set counterpartyIdentifiers, Set provisionIdentifiers) {
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction.TransactionTransactionLine> result = new ArrayList<Transaction.TransactionTransactionLine>();
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        if (filterText != null) {
            filterText = filterText.toLowerCase();
        }
        for (int i = 0; i < count; ++i) {
            String formattedDate;
            String transactionComment;
            String cid;
            Transaction t = (Transaction)transactionArrayList.get(i);
            String status = t.getTransactionStatus();
            if (!includeCancelled && status != null && status.equals("cancelled")) continue;
            LocalDate localDate = t.getTransactionDateAsDate();
            if ((fromDate != null || toDate != null) && (localDate == null || fromDate != null && localDate.isBefore(fromDate) || toDate != null && localDate.isAfter(toDate))) continue;
            boolean matchedTextFilter = false;
            if (!(counterpartyIdentifiers != null && counterpartyIdentifiers.size() != 0 || provisionIdentifiers != null && provisionIdentifiers.size() != 0 || filterText != null && !filterText.isEmpty())) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && counterpartyIdentifiers != null && counterpartyIdentifiers.size() > 0 && (cid = t.getCounterpartyIdentifier()) != null && !cid.isEmpty() && counterpartyIdentifiers.contains(cid)) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && filterText != null && !filterText.isEmpty() && (transactionComment = t.getTransactionComment()) != null && transactionComment.toLowerCase().contains(filterText)) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && localDate != null && filterText != null && !filterText.isEmpty() && (formattedDate = this.prettyDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(filterText)) {
                matchedTextFilter = true;
            }
            for (int j = 0; j < t.getTransactionLineCount(); ++j) {
                String pi;
                String lineComment;
                TransactionLine tl = t.getTransactionLine(j);
                String tai = tl.getAccountIdentifier();
                if (tai == null || !accountIdentifier.equals(tai)) continue;
                if (!matchedTextFilter && filterText != null && !filterText.isEmpty() && (lineComment = tl.getLineCommentString()) != null && lineComment.toLowerCase().contains(filterText)) {
                    matchedTextFilter = true;
                }
                if (!matchedTextFilter && provisionIdentifiers != null && provisionIdentifiers.size() > 0 && (pi = tl.getProvisionIdentifier()) != null && !pi.isEmpty() && provisionIdentifiers.contains(pi)) {
                    matchedTextFilter = true;
                }
                if (!matchedTextFilter) continue;
                result.add(t.buildTransactionTranscationLine(j));
            }
        }
        return result;
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineArrayListByProvision(String provisionIdentifier, boolean includeCancelled, String filterText, LocalDate fromDate, LocalDate toDate, Set counterpartyIdentifiers) {
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction.TransactionTransactionLine> result = new ArrayList<Transaction.TransactionTransactionLine>();
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        if (filterText != null) {
            filterText = filterText.toLowerCase();
        }
        for (int i = 0; i < count; ++i) {
            String formattedDate;
            String transactionComment;
            String cid;
            Transaction t = (Transaction)transactionArrayList.get(i);
            String status = t.getTransactionStatus();
            if (!includeCancelled && status != null && status.equals("cancelled")) continue;
            LocalDate localDate = t.getTransactionDateAsDate();
            if ((fromDate != null || toDate != null) && (localDate == null || fromDate != null && localDate.isBefore(fromDate) || toDate != null && localDate.isAfter(toDate))) continue;
            boolean matchedTextFilter = false;
            if (!(counterpartyIdentifiers != null && counterpartyIdentifiers.size() != 0 || filterText != null && !filterText.isEmpty())) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && counterpartyIdentifiers != null && counterpartyIdentifiers.size() > 0 && (cid = t.getCounterpartyIdentifier()) != null && !cid.isEmpty() && counterpartyIdentifiers.contains(cid)) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && filterText != null && !filterText.isEmpty() && (transactionComment = t.getTransactionComment()) != null && transactionComment.toLowerCase().contains(filterText)) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && localDate != null && filterText != null && !filterText.isEmpty() && (formattedDate = this.prettyDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(filterText)) {
                matchedTextFilter = true;
            }
            for (int j = 0; j < t.getTransactionLineCount(); ++j) {
                String lineComment;
                TransactionLine tl = t.getTransactionLine(j);
                String tpi = tl.getProvisionIdentifier();
                if (tpi == null || !provisionIdentifier.equals(tpi)) continue;
                if (!matchedTextFilter && filterText != null && !filterText.isEmpty() && (lineComment = tl.getLineCommentString()) != null && lineComment.toLowerCase().contains(filterText)) {
                    matchedTextFilter = true;
                }
                if (!matchedTextFilter) continue;
                result.add(t.buildTransactionTranscationLine(j));
            }
        }
        return result;
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineArrayListByProvision(String provisionIdentifier, boolean includeCancelled, String filterText, LocalDate fromDate, LocalDate toDate, Set counterpartyIdentifiers, Set accountIdentifiers) {
        HashSet<String> pis = new HashSet<String>();
        pis.add(provisionIdentifier);
        return this.getTransactionLineArrayListByProvision(pis, includeCancelled, filterText, fromDate, toDate, counterpartyIdentifiers, accountIdentifiers);
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineArrayListByProvision(Set<String> provisionIdentifier, boolean includeCancelled, String filterText, LocalDate fromDate, LocalDate toDate, Set counterpartyIdentifiers, Set accountIdentifiers) {
        if (provisionIdentifier == null || provisionIdentifier.size() == 0) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction.TransactionTransactionLine> result = new ArrayList<Transaction.TransactionTransactionLine>();
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        if (filterText != null) {
            filterText = filterText.toLowerCase();
        }
        for (int i = 0; i < count; ++i) {
            String formattedDate;
            String transactionComment;
            String cid;
            Transaction t = (Transaction)transactionArrayList.get(i);
            String status = t.getTransactionStatus();
            if (!includeCancelled && status != null && status.equals("cancelled")) continue;
            LocalDate localDate = t.getTransactionDateAsDate();
            if ((fromDate != null || toDate != null) && (localDate == null || fromDate != null && localDate.isBefore(fromDate) || toDate != null && localDate.isAfter(toDate))) continue;
            boolean matchedTextFilter = false;
            if (!(counterpartyIdentifiers != null && counterpartyIdentifiers.size() != 0 || accountIdentifiers != null && accountIdentifiers.size() != 0 || filterText != null && !filterText.isEmpty())) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && counterpartyIdentifiers != null && counterpartyIdentifiers.size() > 0 && (cid = t.getCounterpartyIdentifier()) != null && !cid.isEmpty() && counterpartyIdentifiers.contains(cid)) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && filterText != null && !filterText.isEmpty() && (transactionComment = t.getTransactionComment()) != null && transactionComment.toLowerCase().contains(filterText)) {
                matchedTextFilter = true;
            }
            if (!matchedTextFilter && localDate != null && filterText != null && !filterText.isEmpty() && (formattedDate = this.prettyDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(filterText)) {
                matchedTextFilter = true;
            }
            for (int j = 0; j < t.getTransactionLineCount(); ++j) {
                String ai;
                String lineComment;
                TransactionLine tl = t.getTransactionLine(j);
                String tlpi = tl.getProvisionIdentifier();
                if (tlpi == null || tlpi.isEmpty() || !provisionIdentifier.contains(tlpi)) continue;
                if (!matchedTextFilter && filterText != null && !filterText.isEmpty() && (lineComment = tl.getLineCommentString()) != null && lineComment.toLowerCase().contains(filterText)) {
                    matchedTextFilter = true;
                }
                if (!matchedTextFilter && accountIdentifiers != null && accountIdentifiers.size() > 0 && (ai = tl.getAccountIdentifier()) != null && !ai.isEmpty() && accountIdentifiers.contains(ai)) {
                    matchedTextFilter = true;
                }
                if (!matchedTextFilter) continue;
                result.add(t.buildTransactionTranscationLine(j));
            }
        }
        return result;
    }

    public Transaction getTransactionByTransactionNumber(String transactionNumber) {
        if (transactionNumber == null || transactionNumber.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)transactionArrayList.get(i);
            String tTransactionNumber = t.getTransactionNumber();
            if (tTransactionNumber == null || !tTransactionNumber.equals(transactionNumber)) continue;
            return t;
        }
        return null;
    }

    public Transaction getTransactionByBatchIdentifier(String batchIdentifier) {
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList transactionArrayList = glenixElementChildList.getArrayListNoType();
        int count = transactionArrayList.size();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)transactionArrayList.get(i);
            String tBatchIdentifier = t.getBatchIdentifier();
            if (tBatchIdentifier == null || !tBatchIdentifier.equals(batchIdentifier)) continue;
            return t;
        }
        return null;
    }

    public Transaction addBlankTransaction() throws Exception {
        return (Transaction)((GlenixElementChildList)this.childrenAndMeta.get("transaction")).addChild();
    }

    public void addTransaction(Transaction transaction) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, could not add transaction");
        }
        glenixElementChildList.addChild(transaction);
    }

    public void addTransactions(Set<Transaction> transactions) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, could not add transaction");
        }
        glenixElementChildList.addChildAll(transactions);
    }

    public void addTransactionsNew(Set<Transaction> transactions) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, could not add transaction");
        }
        glenixElementChildList.addChildNew(transactions);
    }

    public Set<Transaction> getTransactionsNew(Set<Transaction> transactions) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, could not add transaction");
        }
        return glenixElementChildList.getChildNew(transactions);
    }

    public BusinessMessage addBlankBusinessMessage() throws Exception {
        return (BusinessMessage)((GlenixElementChildList)this.childrenAndMeta.get("businessMessage")).addChild();
    }

    public void addBusinessMessage(BusinessMessage businessMessage) throws Exception {
        GlenixElementChildList gecl = (GlenixElementChildList)this.childrenAndMeta.get("businessMessage");
        if (gecl == null) {
            throw new Exception("Error, cannot add business message, child list is null");
        }
        gecl.addChild(businessMessage);
    }

    public BusinessIssue addBlankBusinessIssue() throws Exception {
        BusinessMessage bm = (BusinessMessage)this.getOrAddChild("businessMessage");
        return bm.addBlankBusinessIssue();
    }

    public Batch addBlankBatch() throws Exception {
        Transaction t = this.addBlankTransaction();
        return (Batch)t.getOrAddChild("batch");
    }

    public DocumentLayout addDocumentLayout() throws Exception {
        return (DocumentLayout)((GlenixElementChildList)this.childrenAndMeta.get("documentLayout")).addChild();
    }

    public void removeTransactions(Set<Transaction> transactions) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || transactions == null) {
            return;
        }
        glenixElementChildList.removeChildCollection(transactions);
    }

    public Transaction getCounterpartyTransaction(String counterpartyIdentifier) {
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!counterpartyIdentifier.equals(t.getCounterpartyIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getCounterpartyTransaction(Counterparty counterparty) {
        if (counterparty == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = counterparty.getCounterpartyIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((hoi == null || hoi.isEmpty() || !hoi.equals(t.getCounterpartyIdentifier())) && counterparty != t.getCounterparty()) continue;
            return t;
        }
        return null;
    }

    public void removeCounterpartyTransaction(Counterparty counterparty) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || counterparty == null) {
            return;
        }
        String ci = counterparty.getCounterpartyIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ci == null || !ci.equals(t.getCounterpartyIdentifier())) && counterparty != t.getCounterparty()) continue;
            glenixElementChildList.removeChild(t);
            return;
        }
    }

    public int getEmployeeCount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (t.getCounterpartyPayrollDetails() == null) continue;
            ++result;
        }
        return result;
    }

    public Transaction getAccountTransaction(String accountIdentifier) {
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!accountIdentifier.equals(t.getAccountIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getAccountTransaction(Account account) {
        if (account == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = account.getAccountIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((hoi == null || hoi.isEmpty() || !hoi.equals(t.getAccountIdentifier())) && account != t.getAccount()) continue;
            return t;
        }
        return null;
    }

    public void removeAccountTransaction(Account account) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || account == null) {
            return;
        }
        String ci = account.getAccountIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ci == null || !ci.equals(t.getAccountIdentifier())) && account != t.getAccount()) continue;
            glenixElementChildList.removeChild(t);
            return;
        }
    }

    public Transaction getHomeOfficeTransaction(String homeOfficeIdentifier) {
        if (homeOfficeIdentifier == null || homeOfficeIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!homeOfficeIdentifier.equals(t.getHomeOfficeIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getHomeOfficeTransaction(HomeOffice homeOffice) {
        if (homeOffice == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = homeOffice.getHomeOfficeIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((hoi == null || hoi.isEmpty() || !hoi.equals(t.getHomeOfficeIdentifier())) && homeOffice != t.getHomeOffice()) continue;
            return t;
        }
        return null;
    }

    public void removeHomeOfficeTransaction(HomeOffice homeOffice) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || homeOffice == null) {
            return;
        }
        String ci = homeOffice.getHomeOfficeIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ci == null || !ci.equals(t.getHomeOfficeIdentifier())) && homeOffice != t.getHomeOffice()) continue;
            glenixElementChildList.removeChild(t);
            return;
        }
    }

    public Transaction getFuelTaxCreditTransaction(String fuelTaxCreditIdentifier) {
        if (fuelTaxCreditIdentifier == null || fuelTaxCreditIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!fuelTaxCreditIdentifier.equals(t.getFuelTaxCreditIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getFuelTaxCreditTransaction(FuelTaxCredit fuelTaxCredit) {
        if (fuelTaxCredit == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String ftci = fuelTaxCredit.getFuelTaxCreditIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ftci == null || ftci.isEmpty() || !ftci.equals(t.getFuelTaxCreditIdentifier())) && fuelTaxCredit != t.getFuelTaxCredit()) continue;
            return t;
        }
        return null;
    }

    public void removeFuelTaxCreditTransaction(FuelTaxCredit fuelTaxCredit) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || fuelTaxCredit == null) {
            return;
        }
        String ci = fuelTaxCredit.getFuelTaxCreditIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ci == null || !ci.equals(t.getFuelTaxCreditIdentifier())) && fuelTaxCredit != t.getFuelTaxCredit()) continue;
            glenixElementChildList.removeChild(t);
            return;
        }
    }

    public Transaction getImportDataTransaction(String importDataIdentifier) {
        if (importDataIdentifier == null || importDataIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!importDataIdentifier.equals(t.getFirstImportDataIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getProvisionTransaction(String provisionIdentifier) {
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!provisionIdentifier.equals(t.getProvisionIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getProvisionTransaction(Provision provision) {
        if (provision == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = provision.getProvisionIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((hoi == null || hoi.isEmpty() || !hoi.equals(t.getProvisionIdentifier())) && provision != t.getProvision()) continue;
            return t;
        }
        return null;
    }

    public Provision getProvisionTransactionProvision(Provision provision) {
        if (provision == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = provision.getProvisionIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((hoi == null || hoi.isEmpty() || !hoi.equals(t.getProvisionIdentifier())) && provision != t.getProvision()) continue;
            return t.getProvision();
        }
        return null;
    }

    public void removeProvisionTransaction(Provision provision) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || provision == null) {
            return;
        }
        String ci = provision.getProvisionIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ci == null || !ci.equals(t.getProvisionIdentifier())) && provision != t.getProvision()) continue;
            glenixElementChildList.removeChild(t);
            return;
        }
    }

    public Transaction getBatchTransaction(String batchIdentifier) {
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!batchIdentifier.equals(t.getBatchIdentifier())) continue;
            return t;
        }
        return null;
    }

    public Transaction getBatchTransaction(Batch batch) {
        if (batch == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        String hoi = batch.getBatchIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((hoi == null || hoi.isEmpty() || !hoi.equals(t.getBatchIdentifier())) && batch != t.getBatch()) continue;
            return t;
        }
        return null;
    }

    public void removeBatchTransaction(Batch batch) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null || batch == null) {
            return;
        }
        String ci = batch.getBatchIdentifier();
        for (int i = 0; i < glenixElementChildList.getChildCount(); ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if ((ci == null || !ci.equals(t.getBatchIdentifier())) && batch != t.getBatch()) continue;
            glenixElementChildList.removeChild(t);
            return;
        }
    }

    public ActivityStatement getActivityStatement() {
        Transaction t = this.getTransaction(0);
        if (t == null) {
            return null;
        }
        return t.getActivityStatement();
    }

    public int getTaxReturnCount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("taxReturn");
        if (glenixElementChildList == null) {
            return 0;
        }
        return glenixElementChildList.getChildCount();
    }

    public TaxReturn getTaxReturn(int index) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("taxReturn");
        if (glenixElementChildList == null) {
            return null;
        }
        return (TaxReturn)glenixElementChildList.getChild(index);
    }

    public ArrayList<TaxReturn> getTaxReturnArrayList() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("taxReturn");
        if (glenixElementChildList == null) {
            return null;
        }
        return glenixElementChildList.getArrayListNoType();
    }

    public TaxReturn addBlankTaxReturn() throws Exception {
        int max = 0;
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("taxReturn");
        if (glenixElementChildList != null) {
            int count = glenixElementChildList.getChildCount();
            for (int i = 0; i < count; ++i) {
                TaxReturn taxReturn = (TaxReturn)glenixElementChildList.getChild(i);
                String trNumberString = taxReturn.getTaxReturnNumber();
                if (trNumberString == null) continue;
                try {
                    int thisTRNumber = Integer.parseInt(trNumberString);
                    if (thisTRNumber <= max) continue;
                    max = thisTRNumber;
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        TaxReturn tr = (TaxReturn)((GlenixElementChildList)this.childrenAndMeta.get("taxReturn")).addChild();
        tr.setTaxReturnNumber(Integer.toString(max + 1));
        return tr;
    }

    public void deleteTaxReturn(TaxReturn taxReturn) throws Exception {
        if (taxReturn == null) {
            return;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("taxReturn");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete tax return as cannot get tax return list");
        }
        GlenixAbstractBranchElement ge = taxReturn.getCGLS0006();
        if (ge == null) {
            ge = taxReturn.getCGNFT0002();
        }
        if (ge == null) {
            ge = taxReturn.getCGTS0006();
        }
        if (ge == null) {
            ge = taxReturn.getCTR0009();
        }
        if (ge == null) {
            ge = taxReturn.getDIDS0002(0);
        }
        if (ge == null) {
            ge = taxReturn.getDIS0003();
        }
        if (ge == null) {
            ge = taxReturn.getIDS0006();
        }
        if (ge == null) {
            ge = taxReturn.getIEE0003(0);
        }
        if (ge == null) {
            ge = taxReturn.getIITR0005();
        }
        if (ge == null) {
            ge = taxReturn.getLS0006();
        }
        if (ge == null) {
            ge = taxReturn.getNRFI0002(0);
        }
        if (ge == null) {
            ge = taxReturn.getPSS0002();
        }
        if (ge == null) {
            ge = taxReturn.getPTR0007();
        }
        if (ge != null) {
            throw new Exception("Error, cannot delete tax return as there is a schedule or main form still attached");
        }
        glenixElementChildList.removeChild(taxReturn);
    }

    public ArrayList<Transaction.TransactionTransactionLine> markActivityStatement(String asNumber, ArrayList<String> asNumberList, LocalDate startDate, LocalDate endDate, ArrayList<String> gsttaxes, LocalDate paySlipStartDate, LocalDate paySlipEndDate, ArrayList<String> paygwtaxes) throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction.TransactionTransactionLine> result = new ArrayList<Transaction.TransactionTransactionLine>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            LocalDate td = t.getTransactionDateAsDate();
            String status = t.getTransactionStatus();
            if (td == null || status != null && (status.equals("cancelled") || status.equals("draft"))) continue;
            String tt = t.getTransactionType();
            int tlcount = t.getTransactionLineCount();
            for (int j = 0; j < tlcount; ++j) {
                TransactionLine tl = t.getTransactionLine(j);
                String tasNumber = tl.getActivityStatementNumber();
                if (tasNumber == null || tasNumber.isEmpty() || tasNumber.equals(asNumber)) {
                    Provision p = tl.getProvision();
                    String pi = null;
                    if (p != null) {
                        pi = p.getProvisionIdentifier();
                    }
                    if (pi != null && (gsttaxes != null && endDate != null && startDate != null && gsttaxes.contains(pi) && !td.isAfter(endDate) && !td.isBefore(startDate) || paygwtaxes != null && paySlipEndDate != null && paySlipStartDate != null && paygwtaxes.contains(pi) && !td.isAfter(paySlipEndDate) && !td.isBefore(paySlipStartDate))) {
                        tl.setActivityStatementNumber(asNumber);
                        result.add(t.buildTransactionTranscationLine(j));
                        continue;
                    }
                    tl.deleteActivityStatement();
                    continue;
                }
                if (!asNumberList.contains(tasNumber)) continue;
                result.add(t.buildTransactionTranscationLine(j));
            }
        }
        return result;
    }

    public ArrayList<Transaction.TransactionTransactionLine> getASTransactionTransactionLineArrayList(ArrayList<String> asNumberList) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction.TransactionTransactionLine> result = new ArrayList<Transaction.TransactionTransactionLine>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            int tlcount = t.getTransactionLineCount();
            for (int j = 0; j < tlcount; ++j) {
                TransactionLine tl = t.getTransactionLine(j);
                String tasNumber = tl.getActivityStatementNumber();
                if (tasNumber == null || !asNumberList.contains(tasNumber)) continue;
                result.add(t.buildTransactionTranscationLine(j));
            }
        }
        return result;
    }

    public ArrayList<Transaction.TransactionTransactionLine> getASTransactionTransactionLineArrayList() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return null;
        }
        ArrayList<Transaction.TransactionTransactionLine> result = new ArrayList<Transaction.TransactionTransactionLine>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            int tlcount = t.getTransactionLineCount();
            for (int j = 0; j < tlcount; ++j) {
                TransactionLine tl = t.getTransactionLine(j);
                result.add(t.buildTransactionTranscationLine(j));
            }
        }
        return result;
    }

    public void deleteBatchTransaction(String batchIdentifier) throws Exception {
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            throw new Exception("Error, cannot delete account transaction specified account identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete account transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getBatchIdentifier();
            if (tai == null || !tai.equals(batchIdentifier)) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public boolean usesBatchIdentifier(String batchIdentifier) {
        if (batchIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getBatchIdentifier();
            if (tai == null || !tai.equals(batchIdentifier)) continue;
            return true;
        }
        return false;
    }

    public void deleteAccountTransaction(String accountIdentifier) throws Exception {
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            throw new Exception("Error, cannot delete account transaction specified account identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete account transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getAccountIdentifier();
            if (tai == null || !tai.equals(accountIdentifier)) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public boolean usesAccountIdentifier(String accountIdentifier) {
        if (accountIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!t.usesAccountIdentifier(accountIdentifier)) continue;
            return true;
        }
        return false;
    }

    public void deleteHomeOfficeTransaction(String homeOfficeIdentifier) throws Exception {
        if (homeOfficeIdentifier == null || homeOfficeIdentifier.isEmpty()) {
            throw new Exception("Error, cannot delete home office transaction specified home office identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete home office transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getHomeOfficeIdentifier();
            if (tai == null || !tai.equals(homeOfficeIdentifier)) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public boolean usesHomeOfficeIdentifier(String homeOfficeIdentifier) {
        if (homeOfficeIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!t.usesHomeOfficeIdentifier(homeOfficeIdentifier)) continue;
            return true;
        }
        return false;
    }

    public void deleteFuelTaxCreditTransaction(String fuelTaxCreditIdentifier) throws Exception {
        if (fuelTaxCreditIdentifier == null || fuelTaxCreditIdentifier.isEmpty()) {
            throw new Exception("Error, cannot delete fuel tax credit transaction specified home office identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete fuel tax credit transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getFuelTaxCreditIdentifier();
            if (tai == null || !tai.equals(fuelTaxCreditIdentifier)) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public boolean usesFuelTaxCreditIdentifier(String fuelTaxCreditIdentifier) {
        if (fuelTaxCreditIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!t.usesFuelTaxCreditIdentifier(fuelTaxCreditIdentifier)) continue;
            return true;
        }
        return false;
    }

    public void deleteImportDataTransaction(String importDataIdentifier) throws Exception {
        if (importDataIdentifier == null || importDataIdentifier.isEmpty()) {
            throw new Exception("Error, cannot delete import data transaction specified import data identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete import data transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            int startcount = t.getTransactionLineCount();
            if (startcount <= 0) continue;
            t.deleteImportDataTransactionLines(importDataIdentifier);
            int endcount = t.getTransactionLineCount();
            if (endcount != 0) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public void deleteTransactions(Set Transactions) throws Exception {
        if (Transactions == null || Transactions.isEmpty()) {
            throw new Exception("Error, cannot delete transaction specified transactions is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete import data transaction as cannot get transaction list");
        }
        glenixElementChildList.removeChildCollection(Transactions);
    }

    public boolean usesImportDataIdentifier(String importDataIdentifier) {
        if (importDataIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!t.usesImportDataIdentifier(importDataIdentifier)) continue;
            return true;
        }
        return false;
    }

    public void deleteProvisionTransaction(String provisionIdentifier) throws Exception {
        if (provisionIdentifier == null) {
            throw new Exception("Error, cannot delete provision transaction specified provision identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete provision transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getProvisionIdentifier();
            if (tai == null || !tai.equals(provisionIdentifier)) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public boolean usesProvisionIdentifier(String provisionIdentifier) {
        if (provisionIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            if (!t.usesProvisionIdentifier(provisionIdentifier)) continue;
            return true;
        }
        return false;
    }

    public void deleteCounterpartyTransaction(String counterpartyIdentifier) throws Exception {
        if (counterpartyIdentifier == null) {
            throw new Exception("Error, cannot delete counterparty transaction specified counterparty identifier is null");
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            throw new Exception("Error, cannot delete counterparty transaction as cannot get transaction list");
        }
        ArrayList<Transaction> al = new ArrayList<Transaction>();
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String tai = t.getCounterpartyIdentifier();
            if (tai == null || !tai.equals(counterpartyIdentifier)) continue;
            al.add(t);
        }
        if (al.size() > 0) {
            glenixElementChildList.removeChildCollection(al);
        }
    }

    public boolean usesCounterpartyIdentifier(String counterpartyIdentifier) {
        if (counterpartyIdentifier == null) {
            return false;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("transaction");
        if (glenixElementChildList == null) {
            return false;
        }
        int count = glenixElementChildList.getChildCount();
        for (int i = 0; i < count; ++i) {
            Transaction t = (Transaction)glenixElementChildList.getChild(i);
            String ci = t.getCounterpartyIdentifier();
            if (ci == null || !ci.equals(counterpartyIdentifier)) continue;
            return true;
        }
        return false;
    }

    public GlenixCertificateList getGlenixCertificateList() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("glenixCertificateList");
        if (glenixElementChildList == null) {
            return null;
        }
        if (glenixElementChildList.getChildCount() == 1) {
            return (GlenixCertificateList)glenixElementChildList.getChild(0);
        }
        return null;
    }

    public GlenixCertificateList getOrAddGlenixCertificateList() throws Exception {
        return (GlenixCertificateList)this.getOrAddChild("glenixCertificateList");
    }

    public void loadFasV2ProvisionList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            XPathFactory factory = XPathFactory.newInstance();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                NodeList nodeList2 = el.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element el2;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !(el2 = (Element)node2).getLocalName().equals("entryDetail")) continue;
                    NodeList nodeList3 = el2.getChildNodes();
                    block2: for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element el3;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || !(el3 = (Element)node3).getLocalName().equals("taxes")) continue;
                        NodeList nodeList4 = el3.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Element el4;
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1 || !(el4 = (Element)node4).getLocalName().equals("taxMaster")) continue;
                            String taxCode = null;
                            String taxDescription = null;
                            NodeList nodeList5 = el4.getChildNodes();
                            for (int n = 0; n < nodeList5.getLength(); ++n) {
                                Node node5 = nodeList5.item(n);
                                if (node5.getNodeType() != 1) continue;
                                Element el5 = (Element)node5;
                                if (el5.getLocalName().equals("taxCode")) {
                                    taxCode = el5.getTextContent();
                                    continue;
                                }
                                if (!el5.getLocalName().equals("taxDescription")) continue;
                                taxDescription = el5.getTextContent();
                            }
                            Transaction pt = null;
                            if (taxCode == null || taxCode.isEmpty() || taxDescription == null || taxDescription.isEmpty()) continue block2;
                            pt = this.getProvisionTransaction(taxCode);
                            if (pt == null) {
                                pt = this.addBlankTransaction();
                            }
                            pt.loadFasV2ProvisionList(doc, el4);
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    public void loadFasV2AccountList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            XPathFactory factory = XPathFactory.newInstance();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                NodeList nodeList2 = el.getChildNodes();
                block1: for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element el2;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !(el2 = (Element)node2).getLocalName().equals("entryDetail")) continue;
                    NodeList nodeList3 = el2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element el3;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || !(el3 = (Element)node3).getLocalName().equals("account")) continue;
                        String accountMainID = null;
                        String accountMainDescription = null;
                        NodeList nodeList4 = el3.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el4 = (Element)node4;
                            if (el4.getLocalName().equals("accountMainID")) {
                                accountMainID = el4.getTextContent();
                                continue;
                            }
                            if (!el4.getLocalName().equals("accountMainDescription")) continue;
                            accountMainDescription = el4.getTextContent();
                        }
                        Transaction at = null;
                        if (accountMainID == null || accountMainID.isEmpty() || accountMainDescription == null || accountMainDescription.isEmpty()) continue block1;
                        at = this.getAccountTransaction(accountMainID);
                        if (at == null) {
                            at = this.addBlankTransaction();
                        }
                        at.loadFasV2AccountList(doc, el3);
                        continue block1;
                    }
                }
            }
        }
    }

    public void loadFasV2AccountListMeasurable(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            XPathFactory factory = XPathFactory.newInstance();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                NodeList nodeList2 = el.getChildNodes();
                block1: for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element el2;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !(el2 = (Element)node2).getLocalName().equals("entryDetail")) continue;
                    NodeList nodeList3 = el2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element el3;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || !(el3 = (Element)node3).getLocalName().equals("measurable")) continue;
                        NodeList nodeList4 = el3.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Element el4;
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1 || !(el4 = (Element)node4).getLocalName().equals("measurableMaster")) continue;
                            String measurableID = null;
                            String measurableDescription = null;
                            NodeList nodeList5 = el4.getChildNodes();
                            for (int n = 0; n < nodeList5.getLength(); ++n) {
                                Node node5 = nodeList5.item(n);
                                if (node5.getNodeType() != 1) continue;
                                Element el5 = (Element)node5;
                                if (el5.getLocalName().equals("measurableID")) {
                                    measurableID = el5.getTextContent();
                                    continue;
                                }
                                if (!el5.getLocalName().equals("measurableDescription")) continue;
                                measurableDescription = el5.getTextContent();
                            }
                            Transaction mt = null;
                            if (measurableID == null || measurableID.isEmpty() || measurableDescription == null || measurableDescription.isEmpty()) continue block1;
                            mt = this.getAccountTransaction("meas_" + measurableID);
                            if (mt == null) {
                                mt = this.addBlankTransaction();
                            }
                            mt.loadFasV2AccountListMeasurable(doc, el4, this);
                            continue block1;
                        }
                        continue block1;
                    }
                }
            }
        }
    }

    public void loadFasV2CounterpartyList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            XPathFactory factory = XPathFactory.newInstance();
            NodeList nodeList = element.getChildNodes();
            block0: for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                NodeList nodeList3 = el.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    Element el3;
                    Node node3 = nodeList3.item(k);
                    if (node3.getNodeType() != 1 || !(el3 = (Element)node3).getLocalName().equals("identifierReference")) continue;
                    String identifierCode = null;
                    String identifierDescription = null;
                    NodeList nodeList4 = el3.getChildNodes();
                    for (int m = 0; m < nodeList4.getLength(); ++m) {
                        Node node4 = nodeList4.item(m);
                        if (node4.getNodeType() != 1) continue;
                        Element el4 = (Element)node4;
                        if (el4.getLocalName().equals("identifierCode")) {
                            identifierCode = el4.getTextContent();
                            continue;
                        }
                        if (!el4.getLocalName().equals("identifierDescription")) continue;
                        identifierDescription = el4.getTextContent();
                    }
                    Transaction ct = null;
                    if (identifierCode == null || identifierCode.isEmpty() || identifierDescription == null || identifierDescription.isEmpty()) continue block0;
                    ct = this.getCounterpartyTransaction(identifierCode);
                    if (ct == null) {
                        ct = this.addBlankTransaction();
                    }
                    ct.loadFasV2CounterpartyList(doc, el3);
                    continue block0;
                }
            }
        }
    }

    public void loadFasV2ActivityStatementList(Document doc, Element element, String ledgerStartDateStr, String ledgerEndDateStr) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("SBRDocumentAS")) continue;
                NodeList nodeList2 = el.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element el2;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !(el2 = (Element)node2).getLocalName().equals("SBREndDate") || ledgerStartDateStr.compareTo(el2.getTextContent()) > 0 || ledgerEndDateStr.compareTo(el2.getTextContent()) < 0) continue;
                    ActivityStatementList asl = (ActivityStatementList)this.getOrAddChild("activityStatementList");
                    asl.loadFasV2ActivityStatementList(doc, el);
                }
            }
        }
    }

    public void loadFasV2ActivityStatement(Document doc, Element element, String asNumber) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("SBRDocumentAS")) continue;
                NodeList nodeList2 = el.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element el2;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !(el2 = (Element)node2).getLocalName().equals("SBRDocumentASNumber") || !asNumber.equals(el2.getTextContent())) continue;
                    Transaction t = (Transaction)this.getOrAddChild("transaction");
                    t.loadFasV2ActivityStatement(doc, el);
                }
            }
        }
    }

    public void loadFasV2Transactions(Document doc, Element element, String ledgerStartDateStr, String ledgerEndDateStr, boolean has_general_journal_type) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int lineCount;
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                String en = null;
                String postingDate = null;
                String postingStatus = null;
                NodeList nodeList2 = el.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element el2 = (Element)node2;
                    if (el2.getLocalName().equals("entryNumber")) {
                        en = el2.getTextContent();
                        continue;
                    }
                    if (el2.getLocalName().equals("postingDate")) {
                        postingDate = el2.getTextContent();
                        continue;
                    }
                    if (!el2.getLocalName().equals("postingStatus")) continue;
                    postingStatus = el2.getTextContent();
                }
                if (en == null || en.isEmpty() || postingStatus == null || !postingStatus.equals("posted") || ledgerStartDateStr.compareTo(postingDate) > 0 || ledgerEndDateStr.compareTo(postingDate) < 0) continue;
                Transaction t = null;
                if (en != null && !en.isEmpty()) {
                    t = this.getTransactionByTransactionNumber(en);
                    if (t == null) {
                        t = this.addBlankTransaction();
                    }
                    t.loadFasV2Transactions(doc, el, has_general_journal_type);
                }
                if ((lineCount = t.getTransactionLineCount()) != 0) continue;
                int index = this.getTransactionCount() - 1;
                ((GlenixElementChildList)this.childrenAndMeta.get("transaction")).removeChild(index);
            }
        }
    }

    public void loadFasV2Batches(Document doc, Element element, String ledgerStartDateStr, String ledgerEndDateStr) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                String batchNumber = null;
                String batchPaymentDate = null;
                NodeList nodeList2 = el.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element el2;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !(el2 = (Element)node2).getLocalName().equals("batch")) continue;
                    NodeList nodeList3 = el2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1) continue;
                        Element el3 = (Element)node3;
                        if (el3.getLocalName().equals("batchNumber")) {
                            batchNumber = el3.getTextContent();
                            continue;
                        }
                        if (!el3.getLocalName().equals("batchPaymentDate")) continue;
                        batchPaymentDate = el3.getTextContent();
                    }
                    if (batchNumber == null || batchNumber.isEmpty() || batchPaymentDate == null || batchPaymentDate.isEmpty() || ledgerStartDateStr.compareTo(batchPaymentDate) > 0 || ledgerEndDateStr.compareTo(batchPaymentDate) < 0) continue;
                    Transaction t = null;
                    t = this.getTransactionByBatchIdentifier(batchNumber);
                    if (t == null) {
                        t = this.addBlankTransaction();
                    }
                    t.loadFasV2Batches(doc, el2);
                }
            }
        }
    }

    public void loadFasV2AddPaySlipBatches(Document doc, Element element, String ledgerStartDateStr, String ledgerEndDateStr) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("accountingEntries")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("entryHeader")) continue;
                String en = null;
                String postingDate = null;
                String postingStatus = null;
                String sjid = null;
                boolean hasbatch = false;
                NodeList nodeList2 = el.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element el2 = (Element)node2;
                    if (el2.getLocalName().equals("entryNumber")) {
                        en = el2.getTextContent();
                        continue;
                    }
                    if (el2.getLocalName().equals("sourceJournalID")) {
                        sjid = el2.getTextContent();
                        continue;
                    }
                    if (el2.getLocalName().equals("postingDate")) {
                        postingDate = el2.getTextContent();
                        continue;
                    }
                    if (el2.getLocalName().equals("postingStatus")) {
                        postingStatus = el2.getTextContent();
                        continue;
                    }
                    if (!el2.getLocalName().equals("batch")) continue;
                    hasbatch = true;
                }
                if (en == null || en.isEmpty() || postingStatus == null || !postingStatus.equals("posted") || sjid == null || !sjid.equals("pl") || hasbatch || ledgerStartDateStr.compareTo(postingDate) > 0 || ledgerEndDateStr.compareTo(postingDate) < 0) continue;
                Transaction t = null;
                if (en == null || en.isEmpty()) continue;
                t = this.getTransactionByTransactionNumber(en);
                if (t == null) {
                    t = this.addBlankTransaction();
                }
                t.loadFasV2AddPaySlipBatches(doc, el);
            }
        }
    }

    public int getBusinessMessageCount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessMessage");
        if (glenixElementChildList == null) {
            return 0;
        }
        return glenixElementChildList.getChildCount();
    }

    public BusinessMessage getBusinessMessage(int index) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("businessMessage");
        if (glenixElementChildList == null) {
            return null;
        }
        return (BusinessMessage)glenixElementChildList.getChild(index);
    }

    public int getBusinessMasterFileUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getBusinessMasterFileUpdateIdentifier();
    }

    public int getAccountUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getAccountUpdateIdentifier();
    }

    public int getProvisionUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getProvisionUpdateIdentifier();
    }

    public int getCounterpartyUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getCounterpartyUpdateIdentifier();
    }

    public int getDivisionUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getDivisionUpdateIdentifier();
    }

    public int getJobUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getJobUpdateIdentifier();
    }

    public int getHomeOfficeUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getHomeOfficeUpdateIdentifier();
    }

    public int getFuelTaxCreditUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getFuelTaxCreditUpdateIdentifier();
    }

    public int getTransactionUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTransactionUpdateIdentifier();
    }

    public int getTaxReturnUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTaxReturnUpdateIdentifier();
    }

    public int getActivityStatementUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getActivityStatementUpdateIdentifier();
    }

    public int getReconciliationUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getReconciliationUpdateIdentifier();
    }

    public int getBusinessMasterFilePreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getBusinessMasterFilePreviousUpdateIdentifier();
    }

    public int getAccountPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getAccountPreviousUpdateIdentifier();
    }

    public int getProvisionPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getProvisionPreviousUpdateIdentifier();
    }

    public int getCounterpartyPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getCounterpartyPreviousUpdateIdentifier();
    }

    public int getDivisionPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getDivisionPreviousUpdateIdentifier();
    }

    public int getJobPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getJobPreviousUpdateIdentifier();
    }

    public int getHomeOfficePreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getHomeOfficePreviousUpdateIdentifier();
    }

    public int getFuelTaxCreditPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getFuelTaxCreditPreviousUpdateIdentifier();
    }

    public int getTransactionPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTransactionPreviousUpdateIdentifier();
    }

    public int getTaxReturnPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getTaxReturnPreviousUpdateIdentifier();
    }

    public int getActivityStatementPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getActivityStatementPreviousUpdateIdentifier();
    }

    public int getReconciliationPreviousUpdateIdentifier() {
        LastUpdateIdentifier lui = this.getLastUpdateIdentifier();
        if (lui == null) {
            return -1;
        }
        return lui.getReconciliationPreviousUpdateIdentifier();
    }
}

